/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k;

import java.io.Serializable;
import java.util.Arrays;

public interface CacheTypeDescriptor<T> {
    public static final String DESCRIPTOR_TO_STRING_PREFIX = "CacheTypeDescriptor#";

    public Class<T> getType();

    public boolean hasTypeArguments();

    public boolean isArray();

    public CacheTypeDescriptor getComponentType();

    public CacheTypeDescriptor[] getTypeArguments();

    public String getTypeName();

    public CacheTypeDescriptor getBeanRepresentation();

    public static class OfGeneric
    extends BaseType {
        CacheTypeDescriptor[] typeArguments;
        Class<?> type;

        public OfGeneric() {
        }

        public OfGeneric(Class<?> type, CacheTypeDescriptor[] typeArguments) {
            this.typeArguments = typeArguments;
            this.type = type;
        }

        @Override
        public Class<?> getType() {
            return this.type;
        }

        public void setType(Class<?> type) {
            this.type = type;
        }

        @Override
        public boolean hasTypeArguments() {
            return true;
        }

        @Override
        public CacheTypeDescriptor[] getTypeArguments() {
            return this.typeArguments;
        }

        public void setTypeArguments(CacheTypeDescriptor[] typeArguments) {
            this.typeArguments = typeArguments;
        }

        static String arrayToString(CacheTypeDescriptor[] a) {
            if (a.length < 1) {
                throw new IllegalArgumentException();
            }
            StringBuilder sb = new StringBuilder();
            int l = a.length - 1;
            int i = 0;
            while (true) {
                sb.append(a[i].getTypeName());
                if (i == l) {
                    return sb.toString();
                }
                sb.append(',');
                ++i;
            }
        }

        @Override
        public String getTypeName() {
            return OfClass.shortenName(this.type.getCanonicalName()) + "<" + OfGeneric.arrayToString(this.typeArguments) + '>';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OfGeneric that = (OfGeneric)o;
            return Arrays.equals(this.typeArguments, that.typeArguments) && this.type.equals(that.type);
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.typeArguments);
            result = 31 * result + this.type.hashCode();
            return result;
        }
    }

    public static class OfArray
    extends BaseType {
        CacheTypeDescriptor componentType;

        public OfArray() {
        }

        public OfArray(CacheTypeDescriptor componentType) {
            this.componentType = componentType;
        }

        @Override
        public boolean isArray() {
            return true;
        }

        @Override
        public CacheTypeDescriptor getComponentType() {
            return this.componentType;
        }

        public void setComponentType(CacheTypeDescriptor componentType) {
            this.componentType = componentType;
        }

        static int countDimensions(CacheTypeDescriptor td) {
            int cnt = 0;
            while (td.isArray()) {
                td = td.getComponentType();
                ++cnt;
            }
            return cnt;
        }

        static Class<?> finalPrimitiveType(CacheTypeDescriptor td) {
            while (td.isArray()) {
                td = td.getComponentType();
            }
            return td.getType();
        }

        @Override
        public String getTypeName() {
            StringBuilder sb = new StringBuilder();
            int _dimensions = OfArray.countDimensions(this);
            if (_dimensions > 1) {
                sb.append(OfArray.finalPrimitiveType(this));
            } else {
                sb.append(this.getComponentType().getTypeName());
            }
            for (int i = 0; i < _dimensions; ++i) {
                sb.append("[]");
            }
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OfArray arrayType = (OfArray)o;
            return this.componentType.equals(arrayType.componentType);
        }

        public int hashCode() {
            return this.componentType.hashCode();
        }
    }

    public static class OfClass
    extends BaseType {
        Class<?> type;

        public OfClass() {
        }

        public OfClass(Class<?> type) {
            if (type.isArray()) {
                throw new IllegalArgumentException("array is not a regular class");
            }
            this.type = type;
        }

        @Override
        public Class<?> getType() {
            return this.type;
        }

        public void setType(Class<?> type) {
            this.type = type;
        }

        static String shortenName(String s) {
            String _LANG_PREFIX = "java.lang.";
            if (s.startsWith("java.lang.")) {
                return s.substring("java.lang.".length());
            }
            return s;
        }

        @Override
        public String getTypeName() {
            return OfClass.shortenName(this.type.getCanonicalName());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OfClass classType = (OfClass)o;
            return this.type.equals(classType.type);
        }

        public int hashCode() {
            return this.type.hashCode();
        }
    }

    public static abstract class BaseType
    implements CacheTypeDescriptor,
    Serializable {
        @Override
        public CacheTypeDescriptor getComponentType() {
            return null;
        }

        public Class<?> getType() {
            return null;
        }

        @Override
        public CacheTypeDescriptor[] getTypeArguments() {
            return null;
        }

        @Override
        public boolean hasTypeArguments() {
            return false;
        }

        @Override
        public boolean isArray() {
            return false;
        }

        @Override
        public CacheTypeDescriptor getBeanRepresentation() {
            return this;
        }

        public final String toString() {
            return CacheTypeDescriptor.DESCRIPTOR_TO_STRING_PREFIX + this.getTypeName();
        }
    }
}

