/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.configuration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.cache2k.configuration.CacheTypeDescriptor;
import org.cache2k.customization.ExpiryCalculator;
import org.cache2k.event.CacheEntryOperationListener;
import org.cache2k.integration.AdvancedCacheLoader;
import org.cache2k.integration.CacheLoader;
import org.cache2k.integration.CacheWriter;
import org.cache2k.integration.ExceptionPropagator;
import org.cache2k.integration.ResiliencePolicy;

public class CacheConfiguration<K, V>
implements Serializable {
    public final long EXPIRY_MILLIS_ETERNAL = Long.MAX_VALUE;
    private boolean storeByReference;
    private String name;
    private CacheTypeDescriptor keyType;
    private CacheTypeDescriptor valueType;
    private Class<?> implementation;
    private long entryCapacity = 2000L;
    private int heapEntryCapacity = -1;
    private boolean refreshAhead = false;
    private long expireAfterWriteMillis = -1L;
    private long retryIntervalMillis = -1L;
    private long maxRetryIntervalMillis = -1L;
    private long resilienceDurationMillis = -1L;
    private boolean keepDataAfterExpired = true;
    private boolean sharpExpiry = false;
    private List<Object> moduleConfiguration;
    private boolean suppressExceptions = true;
    private int loaderThreadCount;
    private ExpiryCalculator<K, V> expiryCalculator;
    private ResiliencePolicy<K, V> resiliencePolicy;
    private CacheLoader<K, V> loader;
    private CacheWriter<K, V> writer;
    private AdvancedCacheLoader<K, V> advancedLoader;
    private ExceptionPropagator exceptionPropagator;
    private Collection<CacheEntryOperationListener<K, V>> listeners;
    private Collection<CacheEntryOperationListener<K, V>> asyncListeners;

    public static <K, V> CacheConfiguration<K, V> of(Class<K> keyType, Class<V> valueType) {
        CacheConfiguration<K, V> c = new CacheConfiguration<K, V>();
        c.setKeyType(keyType);
        c.setValueType(valueType);
        return c;
    }

    public static <K, V> CacheConfiguration<K, V> of(Class<K> keyType, CacheTypeDescriptor<V> valueType) {
        CacheConfiguration<K, V> c = new CacheConfiguration<K, V>();
        c.setKeyType(keyType);
        c.setValueType(valueType);
        return c;
    }

    public static <K, V> CacheConfiguration<K, V> of(CacheTypeDescriptor<K> keyType, Class<V> valueType) {
        CacheConfiguration<K, V> c = new CacheConfiguration<K, V>();
        c.setKeyType(keyType);
        c.setValueType(valueType);
        return c;
    }

    public static <K, V> CacheConfiguration<K, V> of(CacheTypeDescriptor<K> keyType, CacheTypeDescriptor<V> valueType) {
        CacheConfiguration<K, V> c = new CacheConfiguration<K, V>();
        c.setKeyType(keyType);
        c.setValueType(valueType);
        return c;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getEntryCapacity() {
        return this.entryCapacity;
    }

    public void setEntryCapacity(long v) {
        this.entryCapacity = v;
    }

    public boolean isRefreshAhead() {
        return this.refreshAhead;
    }

    public void setRefreshAhead(boolean v) {
        this.refreshAhead = v;
    }

    public boolean isBackgroundRefresh() {
        return this.refreshAhead;
    }

    public void setBackgroundRefresh(boolean v) {
        this.refreshAhead = v;
    }

    public CacheTypeDescriptor getKeyType() {
        return this.keyType;
    }

    void checkNull(Object v) {
        if (v == null) {
            throw new NullPointerException("null value not allowed");
        }
    }

    public void setKeyType(Class<?> v) {
        this.checkNull(v);
        this.setKeyType(new CacheTypeDescriptor.OfClass(v));
    }

    public void setKeyType(CacheTypeDescriptor v) {
        this.checkNull(v);
        if (this.keyType != null && !v.equals(this.keyType)) {
            throw new IllegalArgumentException("Key type may only set once.");
        }
        if (v.isArray()) {
            throw new IllegalArgumentException("Arrays are not supported for keys");
        }
        this.keyType = v.getBeanRepresentation();
    }

    public CacheTypeDescriptor<V> getValueType() {
        return this.valueType;
    }

    public void setValueType(Class<?> v) {
        this.checkNull(v);
        this.setValueType(new CacheTypeDescriptor.OfClass(v));
    }

    public void setValueType(CacheTypeDescriptor v) {
        this.checkNull(v);
        if (this.valueType != null && !v.equals(this.valueType)) {
            throw new IllegalArgumentException("Value type may only set once.");
        }
        if (v.isArray()) {
            throw new IllegalArgumentException("Arrays are not supported for values");
        }
        this.valueType = v.getBeanRepresentation();
    }

    public boolean isEternal() {
        return this.expireAfterWriteMillis == -1L || this.expireAfterWriteMillis == Long.MAX_VALUE;
    }

    public void setEternal(boolean v) {
        if (v) {
            this.expireAfterWriteMillis = Long.MAX_VALUE;
        }
    }

    public void setExpirySeconds(int v) {
        if (v == -1 || v == Integer.MAX_VALUE) {
            this.expireAfterWriteMillis = -1L;
        }
        this.expireAfterWriteMillis = (long)v * 1000L;
    }

    public int getExpirySeconds() {
        if (this.isEternal()) {
            return -1;
        }
        return (int)(this.expireAfterWriteMillis / 1000L);
    }

    public long getExpireAfterWriteMillis() {
        return this.expireAfterWriteMillis;
    }

    public void setExpireAfterWriteMillis(long v) {
        this.expireAfterWriteMillis = v;
    }

    public long getRetryIntervalMillis() {
        return this.retryIntervalMillis;
    }

    public void setRetryIntervalMillis(long v) {
        this.retryIntervalMillis = v;
    }

    public long getMaxRetryIntervalMillis() {
        return this.maxRetryIntervalMillis;
    }

    public void setMaxRetryIntervalMillis(long _maxRetryIntervalMillis) {
        this.maxRetryIntervalMillis = _maxRetryIntervalMillis;
    }

    public long getResilienceDurationMillis() {
        return this.resilienceDurationMillis;
    }

    public void setResilienceDurationMillis(long _resilienceDurationMillis) {
        this.resilienceDurationMillis = _resilienceDurationMillis;
    }

    public boolean isKeepDataAfterExpired() {
        return this.keepDataAfterExpired;
    }

    public void setKeepDataAfterExpired(boolean v) {
        this.keepDataAfterExpired = v;
    }

    public boolean isSharpExpiry() {
        return this.sharpExpiry;
    }

    public void setSharpExpiry(boolean sharpExpiry) {
        this.sharpExpiry = sharpExpiry;
    }

    public boolean isSuppressExceptions() {
        return this.suppressExceptions;
    }

    public void setSuppressExceptions(boolean suppressExceptions) {
        this.suppressExceptions = suppressExceptions;
    }

    public int getHeapEntryCapacity() {
        return this.heapEntryCapacity;
    }

    public void setHeapEntryCapacity(int v) {
        this.heapEntryCapacity = v;
    }

    public List<Object> getModuleConfiguration() {
        return this.moduleConfiguration;
    }

    public void setModuleConfiguration(List<Object> moduleConfiguration) {
        this.moduleConfiguration = moduleConfiguration;
    }

    public Collection<Object> getModules() {
        if (this.moduleConfiguration == null) {
            this.moduleConfiguration = new ArrayList<Object>();
        }
        return this.moduleConfiguration;
    }

    public CacheLoader<K, V> getLoader() {
        return this.loader;
    }

    public void setLoader(CacheLoader<K, V> v) {
        this.loader = v;
    }

    public AdvancedCacheLoader<K, V> getAdvancedLoader() {
        return this.advancedLoader;
    }

    public void setAdvancedLoader(AdvancedCacheLoader<K, V> v) {
        this.advancedLoader = v;
    }

    public int getLoaderThreadCount() {
        return this.loaderThreadCount;
    }

    public void setLoaderThreadCount(int v) {
        this.loaderThreadCount = v;
    }

    public ExpiryCalculator<K, V> getExpiryCalculator() {
        return this.expiryCalculator;
    }

    public void setExpiryCalculator(ExpiryCalculator<K, V> _expiryCalculator) {
        this.expiryCalculator = _expiryCalculator;
    }

    public CacheWriter<K, V> getWriter() {
        return this.writer;
    }

    public void setWriter(CacheWriter<K, V> v) {
        this.writer = v;
    }

    public boolean isStoreByReference() {
        return this.storeByReference;
    }

    public void setStoreByReference(boolean _storeByReference) {
        this.storeByReference = _storeByReference;
    }

    public ExceptionPropagator getExceptionPropagator() {
        return this.exceptionPropagator;
    }

    public void setExceptionPropagator(ExceptionPropagator _exceptionPropagator) {
        this.exceptionPropagator = _exceptionPropagator;
    }

    public Collection<CacheEntryOperationListener<K, V>> getListeners() {
        if (this.listeners == null) {
            this.listeners = new HashSet<CacheEntryOperationListener<K, V>>();
        }
        return this.listeners;
    }

    public boolean hasListeners() {
        return this.listeners != null && !this.listeners.isEmpty();
    }

    public Collection<CacheEntryOperationListener<K, V>> getAsyncListeners() {
        if (this.asyncListeners == null) {
            this.asyncListeners = new HashSet<CacheEntryOperationListener<K, V>>();
        }
        return this.asyncListeners;
    }

    public boolean hasAsyncListeners() {
        return this.asyncListeners != null && !this.asyncListeners.isEmpty();
    }

    public ResiliencePolicy<K, V> getResiliencePolicy() {
        return this.resiliencePolicy;
    }

    public void setResiliencePolicy(ResiliencePolicy<K, V> _resiliencePolicy) {
        this.resiliencePolicy = _resiliencePolicy;
    }
}

