/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.cache2k.BulkCacheSource;
import org.cache2k.Cache;
import org.cache2k.Cache2kBuilder;
import org.cache2k.CacheEntry;
import org.cache2k.CacheManager;
import org.cache2k.CacheSource;
import org.cache2k.CacheSourceWithMetaInfo;
import org.cache2k.EntryExpiryCalculator;
import org.cache2k.ExceptionExpiryCalculator;
import org.cache2k.RefreshController;
import org.cache2k.configuration.Cache2kConfiguration;
import org.cache2k.configuration.CacheType;
import org.cache2k.event.CacheEntryOperationListener;
import org.cache2k.expiry.ExpiryPolicy;
import org.cache2k.integration.AdvancedCacheLoader;
import org.cache2k.integration.CacheLoader;
import org.cache2k.integration.CacheWriter;
import org.cache2k.integration.ExceptionInformation;
import org.cache2k.integration.ExceptionPropagator;
import org.cache2k.integration.ResiliencePolicy;

public class CacheBuilder<K, V> {
    Cache2kBuilder<K, V> builder;

    public static CacheBuilder<?, ?> newCache() {
        return new CacheBuilder(Cache2kBuilder.forUnknownTypes());
    }

    public static <K, V> CacheBuilder<K, V> newCache(Class<K> _keyType, Class<V> _valueType) {
        return CacheBuilder.fromConfig(Cache2kConfiguration.of(_keyType, _valueType));
    }

    public static <K, C extends Collection<T>, T> CacheBuilder<K, C> newCache(Class<K> _keyType, Class<C> _collectionType, Class<T> _entryType) {
        return CacheBuilder.newCache(_keyType, _collectionType);
    }

    public static <K1, T> CacheBuilder<K1, T> fromConfig(Cache2kConfiguration<K1, T> c) {
        return new CacheBuilder<K1, T>(Cache2kBuilder.of(c));
    }

    public CacheBuilder(Cache2kBuilder<K, V> _builder) {
        this.builder = _builder;
        this.builder.permitNullValues(true);
    }

    public CacheBuilder<K, V> addListener(CacheEntryOperationListener<K, V> listener) {
        this.builder.addListener(listener);
        return this;
    }

    public CacheBuilder<K, V> entryCapacity(int v) {
        this.builder.entryCapacity(v);
        return this;
    }

    public CacheBuilder<K, V> loaderThreadCount(int v) {
        this.builder.loaderThreadCount(v);
        return this;
    }

    public CacheBuilder<K, V> expiryDuration(long v, TimeUnit u) {
        this.builder.expireAfterWrite(v, u);
        return this;
    }

    public CacheBuilder<K, V> entryExpiryCalculator(EntryExpiryCalculator<K, V> c) {
        this.builder.expiryPolicy(c);
        return this;
    }

    public CacheBuilder<K, V> name(Class<?> _class) {
        this.name(_class.getSimpleName());
        return this;
    }

    public CacheBuilder<K, V> name(Object _containingObject, String _fieldName) {
        this.name(_containingObject.getClass(), _fieldName);
        return this;
    }

    public CacheBuilder<K, V> loader(CacheLoader<K, V> l) {
        this.builder.loader(l);
        return this;
    }

    public CacheBuilder<K, V> sharpExpiry(boolean f) {
        this.builder.sharpExpiry(f);
        return this;
    }

    public CacheBuilder<K, V> eternal(boolean v) {
        this.builder.eternal(v);
        return this;
    }

    public CacheBuilder<K, V> suppressExceptions(boolean v) {
        this.builder.suppressExceptions(v);
        return this;
    }

    public CacheBuilder<K, V> writer(CacheWriter<K, V> w) {
        this.builder.writer(w);
        return this;
    }

    public CacheBuilder<K, V> heapEntryCapacity(int v) {
        this.builder.toConfiguration().setHeapEntryCapacity(v);
        return this;
    }

    public <T2> CacheBuilder<K, T2> valueType(Class<T2> t) {
        this.builder.valueType(t);
        return this;
    }

    public <K2> CacheBuilder<K2, V> keyType(Class<K2> t) {
        this.builder.keyType(t);
        return this;
    }

    public CacheBuilder<K, V> expiryCalculator(ExpiryPolicy<K, V> c) {
        this.builder.expiryPolicy(c);
        return this;
    }

    public CacheBuilder<K, V> name(Class<?> _class, String _fieldName) {
        this.builder.name(_class.getSimpleName() + "." + _fieldName);
        return this;
    }

    public CacheBuilder<K, V> exceptionExpiryDuration(long v, TimeUnit u) {
        this.builder.retryInterval(v, u);
        return this;
    }

    public Cache<K, V> build() {
        return this.builder.build();
    }

    public Cache2kConfiguration createConfiguration() {
        return this.builder.toConfiguration();
    }

    public CacheBuilder<K, V> manager(CacheManager m) {
        this.builder.manager(m);
        return this;
    }

    public CacheBuilder<K, V> storeByReference(boolean v) {
        this.builder.storeByReference(v);
        return this;
    }

    @Deprecated
    public Cache2kConfiguration getConfig() {
        return this.builder.toConfiguration();
    }

    public CacheBuilder<K, V> expirySecs(int v) {
        this.builder.expireAfterWrite(v, TimeUnit.SECONDS);
        return this;
    }

    public CacheBuilder<K, V> maxSizeBound(int v) {
        return this;
    }

    public CacheBuilder<K, V> name(String v) {
        this.builder.name(v);
        return this;
    }

    public CacheBuilder<K, V> source(final CacheSourceWithMetaInfo<K, V> eg) {
        this.builder.loader(new AdvancedCacheLoader<K, V>(){

            @Override
            public V load(K key, long currentTime, CacheEntry<K, V> previousEntry) throws Exception {
                try {
                    if (previousEntry != null && previousEntry.getException() == null) {
                        return eg.get(key, currentTime, previousEntry.getValue(), previousEntry.getLastModification());
                    }
                    return eg.get(key, currentTime, null, 0L);
                }
                catch (Exception e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new RuntimeException("rethrow throwable", t);
                }
            }
        });
        return this;
    }

    public CacheBuilder<K, V> implementation(Class<?> c) {
        return this;
    }

    public <K2> CacheBuilder<K2, V> keyType(CacheType<K2> t) {
        this.builder.keyType(t);
        return this;
    }

    public CacheBuilder<K, V> expiryMillis(long v) {
        this.builder.expireAfterWrite(v, TimeUnit.MILLISECONDS);
        return this;
    }

    public CacheBuilder<K, V> backgroundRefresh(boolean f) {
        this.builder.refreshAhead(f);
        return this;
    }

    public CacheBuilder<K, V> source(final CacheSource<K, V> g) {
        this.builder.loader(new AdvancedCacheLoader<K, V>(){

            @Override
            public V load(K key, long currentTime, CacheEntry<K, V> previousEntry) throws Exception {
                try {
                    return g.get(key);
                }
                catch (Exception e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new RuntimeException("rethrow throwable", t);
                }
            }
        });
        return this;
    }

    public CacheBuilder<K, V> source(final BulkCacheSource<K, V> s) {
        this.builder.loader(new AdvancedCacheLoader<K, V>(){

            @Override
            public V load(final K key, long currentTime, CacheEntry<K, V> previousEntry) throws Exception {
                CacheEntry entry = previousEntry;
                if (previousEntry == null) {
                    entry = new CacheEntry<K, V>(){

                        @Override
                        public K getKey() {
                            return key;
                        }

                        @Override
                        public V getValue() {
                            return null;
                        }

                        @Override
                        public Throwable getException() {
                            return null;
                        }

                        @Override
                        public long getLastModification() {
                            return 0L;
                        }
                    };
                }
                try {
                    return s.getValues(Collections.singletonList(entry), currentTime).get(0);
                }
                catch (Exception e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new RuntimeException("rethrow throwable", t);
                }
            }
        });
        return this;
    }

    public CacheBuilder<K, V> exceptionExpiryCalculator(final ExceptionExpiryCalculator<K> c) {
        this.builder.resiliencePolicy(new ResiliencePolicy<K, V>(){

            @Override
            public long suppressExceptionUntil(K key, ExceptionInformation exceptionInformation, CacheEntry<K, V> cachedContent) {
                return c.calculateExpiryTime(key, exceptionInformation.getException(), exceptionInformation.getLoadTime());
            }

            @Override
            public long retryLoadAfter(K key, ExceptionInformation exceptionInformation) {
                return c.calculateExpiryTime(key, exceptionInformation.getException(), exceptionInformation.getLoadTime());
            }
        });
        return this;
    }

    public CacheBuilder<K, V> maxSize(int v) {
        this.builder.entryCapacity(v);
        return this;
    }

    public <T2> CacheBuilder<K, T2> valueType(CacheType<T2> t) {
        this.builder.valueType(t);
        return this;
    }

    public CacheBuilder<K, V> keepDataAfterExpired(boolean v) {
        this.builder.keepDataAfterExpired(v);
        return this;
    }

    public CacheBuilder<K, V> refreshController(final RefreshController lc) {
        this.expiryCalculator(new ExpiryPolicy<K, V>(){

            @Override
            public long calculateExpiryTime(K _key, V _value, long _loadTime, CacheEntry<K, V> _oldEntry) {
                if (_oldEntry != null) {
                    return lc.calculateNextRefreshTime(_oldEntry.getValue(), _value, _oldEntry.getLastModification(), _loadTime);
                }
                return lc.calculateNextRefreshTime(null, _value, 0L, _loadTime);
            }
        });
        return this;
    }

    public CacheBuilder<K, V> refreshAhead(boolean f) {
        this.builder.refreshAhead(f);
        return this;
    }

    public CacheBuilder<K, V> exceptionPropagator(ExceptionPropagator ep) {
        this.builder.exceptionPropagator(ep);
        return this;
    }

    public CacheBuilder<K, V> loader(AdvancedCacheLoader<K, V> l) {
        this.builder.loader(l);
        return this;
    }
}

