/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k;

import java.io.Closeable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.cache2k.AdvancedKeyValueSource;
import org.cache2k.CacheEntry;
import org.cache2k.CacheManager;
import org.cache2k.CacheOperationCompletionListener;
import org.cache2k.KeyValueStore;
import org.cache2k.processor.EntryProcessingResult;
import org.cache2k.processor.EntryProcessor;

public interface Cache<K, V>
extends AdvancedKeyValueSource<K, V>,
KeyValueStore<K, V>,
Iterable<CacheEntry<K, V>>,
Closeable {
    public String getName();

    @Override
    public V get(K var1);

    public CacheEntry<K, V> getEntry(K var1);

    @Override
    public void prefetch(K var1);

    public void prefetch(CacheOperationCompletionListener var1, K var2);

    @Override
    public void prefetch(Iterable<? extends K> var1);

    public void prefetchAll(Iterable<? extends K> var1);

    @Override
    public void prefetchAll(CacheOperationCompletionListener var1, Iterable<? extends K> var2);

    public void prefetchAll(CacheOperationCompletionListener var1, K ... var2);

    public void prefetch(List<? extends K> var1, int var2, int var3);

    public V peek(K var1);

    public CacheEntry<K, V> peekEntry(K var1);

    public boolean contains(K var1);

    public boolean containsKey(K var1);

    @Override
    public void put(K var1, V var2);

    public boolean putIfAbsent(K var1, V var2);

    public V peekAndReplace(K var1, V var2);

    public boolean replace(K var1, V var2);

    public boolean replaceIfEquals(K var1, V var2, V var3);

    public V peekAndRemove(K var1);

    public boolean containsAndRemove(K var1);

    @Override
    public void remove(K var1);

    public boolean removeIfEquals(K var1, V var2);

    public void removeAllAtOnce(Set<K> var1);

    @Override
    public void removeAll(Iterable<? extends K> var1);

    public V peekAndPut(K var1, V var2);

    public void expireAt(K var1, long var2);

    public void loadAll(CacheOperationCompletionListener var1, Iterable<? extends K> var2);

    public void reloadAll(CacheOperationCompletionListener var1, Iterable<? extends K> var2);

    public <R> R invoke(K var1, EntryProcessor<K, V, R> var2);

    public <R> Map<K, EntryProcessingResult<R>> invokeAll(Iterable<? extends K> var1, EntryProcessor<K, V, R> var2);

    @Override
    public Map<K, V> getAll(Iterable<? extends K> var1);

    public Map<K, V> peekAll(Iterable<? extends K> var1);

    @Override
    public void putAll(Map<? extends K, ? extends V> var1);

    @Deprecated
    public int getTotalEntryCount();

    @Override
    public Iterator<CacheEntry<K, V>> iterator();

    public Iterable<K> keys();

    public Iterable<CacheEntry<K, V>> entries();

    public void removeAll();

    public void clear();

    public void purge();

    public void flush();

    public void destroy();

    public void clearAndClose();

    @Override
    public void close();

    public CacheManager getCacheManager();

    public boolean isClosed();

    public String toString();

    public <X> X requestInterface(Class<X> var1);

    public ConcurrentMap<K, V> asMap();
}

