/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.configuration;

import java.util.concurrent.Executor;
import org.cache2k.configuration.CacheType;
import org.cache2k.configuration.CacheTypeCapture;
import org.cache2k.configuration.ConfigurationBean;
import org.cache2k.configuration.ConfigurationSectionContainer;
import org.cache2k.configuration.ConfigurationWithSections;
import org.cache2k.configuration.CustomizationCollection;
import org.cache2k.configuration.CustomizationSupplier;
import org.cache2k.configuration.DefaultCustomizationCollection;
import org.cache2k.event.CacheEntryOperationListener;
import org.cache2k.expiry.ExpiryPolicy;
import org.cache2k.integration.AdvancedCacheLoader;
import org.cache2k.integration.CacheLoader;
import org.cache2k.integration.CacheWriter;
import org.cache2k.integration.ExceptionPropagator;
import org.cache2k.integration.ResiliencePolicy;

public class Cache2kConfiguration<K, V>
implements ConfigurationBean,
ConfigurationWithSections {
    public static final long EXPIRY_NOT_ETERNAL = 0x7FFFFFFFFFFFFFFEL;
    private boolean storeByReference;
    private String name;
    private CacheType<K> keyType;
    private CacheType<V> valueType;
    private long entryCapacity = 2000L;
    private boolean strictEviction = false;
    private boolean refreshAhead = false;
    private long expireAfterWrite = -1L;
    private long retryInterval = -1L;
    private long maxRetryInterval = -1L;
    private long resilienceDuration = -1L;
    private boolean keepDataAfterExpired = false;
    private boolean sharpExpiry = false;
    private boolean suppressExceptions = true;
    private int loaderThreadCount;
    private boolean permitNullValues = false;
    private boolean disableStatistics = false;
    private int evictionSegmentCount = -1;
    private boolean externalConfigurationPresent = false;
    private CustomizationSupplier<Executor> loaderExecutor;
    private CustomizationSupplier<Executor> prefetchExecutor;
    private CustomizationSupplier<ExpiryPolicy<K, V>> expiryPolicy;
    private CustomizationSupplier<ResiliencePolicy<K, V>> resiliencePolicy;
    private CustomizationSupplier<CacheLoader<K, V>> loader;
    private CustomizationSupplier<CacheWriter<K, V>> writer;
    private CustomizationSupplier<AdvancedCacheLoader<K, V>> advancedLoader;
    private CustomizationSupplier<ExceptionPropagator<K>> exceptionPropagator;
    private CustomizationCollection<CacheEntryOperationListener<K, V>> listeners;
    private CustomizationCollection<CacheEntryOperationListener<K, V>> asyncListeners;
    private ConfigurationSectionContainer sections;

    public static <K, V> Cache2kConfiguration<K, V> of(Class<K> keyType, Class<V> valueType) {
        Cache2kConfiguration<K, V> c = new Cache2kConfiguration<K, V>();
        c.setKeyType(keyType);
        c.setValueType(valueType);
        return c;
    }

    public static <K, V> Cache2kConfiguration<K, V> of(Class<K> keyType, CacheType<V> valueType) {
        Cache2kConfiguration<K, V> c = new Cache2kConfiguration<K, V>();
        c.setKeyType(keyType);
        c.setValueType(valueType);
        return c;
    }

    public static <K, V> Cache2kConfiguration<K, V> of(CacheType<K> keyType, Class<V> valueType) {
        Cache2kConfiguration<K, V> c = new Cache2kConfiguration<K, V>();
        c.setKeyType(keyType);
        c.setValueType(valueType);
        return c;
    }

    public static <K, V> Cache2kConfiguration<K, V> of(CacheType<K> keyType, CacheType<V> valueType) {
        Cache2kConfiguration<K, V> c = new Cache2kConfiguration<K, V>();
        c.setKeyType(keyType);
        c.setValueType(valueType);
        return c;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getEntryCapacity() {
        return this.entryCapacity;
    }

    public void setEntryCapacity(long v) {
        this.entryCapacity = v;
    }

    public boolean isRefreshAhead() {
        return this.refreshAhead;
    }

    public void setRefreshAhead(boolean v) {
        this.refreshAhead = v;
    }

    public boolean isBackgroundRefresh() {
        return this.refreshAhead;
    }

    public void setBackgroundRefresh(boolean v) {
        this.refreshAhead = v;
    }

    public CacheType<K> getKeyType() {
        return this.keyType;
    }

    private void checkNull(Object v) {
        if (v == null) {
            throw new NullPointerException("null value not allowed");
        }
    }

    public void setKeyType(Class<?> v) {
        this.checkNull(v);
        this.setKeyType(CacheTypeCapture.of(v));
    }

    public void setKeyType(CacheType v) {
        this.checkNull(v);
        if (v.isArray()) {
            throw new IllegalArgumentException("Arrays are not supported for keys");
        }
        this.keyType = v.getBeanRepresentation();
    }

    public CacheType<V> getValueType() {
        return this.valueType;
    }

    public void setValueType(Class<?> v) {
        this.checkNull(v);
        this.setValueType(CacheTypeCapture.of(v));
    }

    public void setValueType(CacheType v) {
        this.checkNull(v);
        if (v.isArray()) {
            throw new IllegalArgumentException("Arrays are not supported for values");
        }
        this.valueType = v.getBeanRepresentation();
    }

    public boolean isEternal() {
        return this.expireAfterWrite == -1L || this.expireAfterWrite == Long.MAX_VALUE;
    }

    public void setEternal(boolean v) {
        if (v) {
            this.setExpireAfterWrite(Long.MAX_VALUE);
        } else {
            this.setExpireAfterWrite(0x7FFFFFFFFFFFFFFEL);
        }
    }

    public void setExpirySeconds(int v) {
        if (v == -1 || v == Integer.MAX_VALUE) {
            this.expireAfterWrite = -1L;
        }
        this.expireAfterWrite = (long)v * 1000L;
    }

    public int getExpirySeconds() {
        if (this.isEternal()) {
            return -1;
        }
        return (int)(this.expireAfterWrite / 1000L);
    }

    public long getExpireAfterWrite() {
        return this.expireAfterWrite;
    }

    public void setExpireAfterWrite(long millis) {
        if (millis == this.expireAfterWrite) {
            return;
        }
        if (this.expireAfterWrite != -1L) {
            if (millis == Long.MAX_VALUE) {
                throw new IllegalArgumentException("not eternal or expiry was set, refusing to reset back to eternal");
            }
            if (this.expireAfterWrite == Long.MAX_VALUE) {
                throw new IllegalArgumentException("eternal was set, refusing to reset to expire time span");
            }
        }
        this.expireAfterWrite = millis;
    }

    public long getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(long millis) {
        this.retryInterval = millis;
    }

    public long getMaxRetryInterval() {
        return this.maxRetryInterval;
    }

    public void setMaxRetryInterval(long millis) {
        this.maxRetryInterval = millis;
    }

    public long getResilienceDuration() {
        return this.resilienceDuration;
    }

    public void setResilienceDuration(long millis) {
        this.resilienceDuration = millis;
    }

    public boolean isKeepDataAfterExpired() {
        return this.keepDataAfterExpired;
    }

    public void setKeepDataAfterExpired(boolean v) {
        this.keepDataAfterExpired = v;
    }

    public boolean isSharpExpiry() {
        return this.sharpExpiry;
    }

    public void setSharpExpiry(boolean v) {
        this.sharpExpiry = v;
    }

    public boolean isSuppressExceptions() {
        return this.suppressExceptions;
    }

    public void setSuppressExceptions(boolean v) {
        this.suppressExceptions = v;
    }

    public boolean isExternalConfigurationPresent() {
        return this.externalConfigurationPresent;
    }

    public void setExternalConfigurationPresent(boolean v) {
        this.externalConfigurationPresent = v;
    }

    @Override
    public ConfigurationSectionContainer getSections() {
        if (this.sections == null) {
            this.sections = new ConfigurationSectionContainer();
        }
        return this.sections;
    }

    public CustomizationSupplier<CacheLoader<K, V>> getLoader() {
        return this.loader;
    }

    public void setLoader(CustomizationSupplier<CacheLoader<K, V>> v) {
        this.loader = v;
    }

    public CustomizationSupplier<AdvancedCacheLoader<K, V>> getAdvancedLoader() {
        return this.advancedLoader;
    }

    public void setAdvancedLoader(CustomizationSupplier<AdvancedCacheLoader<K, V>> v) {
        this.advancedLoader = v;
    }

    public int getLoaderThreadCount() {
        return this.loaderThreadCount;
    }

    public void setLoaderThreadCount(int v) {
        this.loaderThreadCount = v;
    }

    public CustomizationSupplier<ExpiryPolicy<K, V>> getExpiryPolicy() {
        return this.expiryPolicy;
    }

    public void setExpiryPolicy(CustomizationSupplier<ExpiryPolicy<K, V>> _expiryPolicy) {
        this.expiryPolicy = _expiryPolicy;
    }

    public CustomizationSupplier<CacheWriter<K, V>> getWriter() {
        return this.writer;
    }

    public void setWriter(CustomizationSupplier<CacheWriter<K, V>> v) {
        this.writer = v;
    }

    public boolean isStoreByReference() {
        return this.storeByReference;
    }

    public void setStoreByReference(boolean v) {
        this.storeByReference = v;
    }

    public CustomizationSupplier<ExceptionPropagator<K>> getExceptionPropagator() {
        return this.exceptionPropagator;
    }

    public void setExceptionPropagator(CustomizationSupplier<ExceptionPropagator<K>> v) {
        this.exceptionPropagator = v;
    }

    public CustomizationCollection<CacheEntryOperationListener<K, V>> getListeners() {
        if (this.listeners == null) {
            this.listeners = new DefaultCustomizationCollection<CacheEntryOperationListener<K, V>>();
        }
        return this.listeners;
    }

    public boolean hasListeners() {
        return this.listeners != null && !this.listeners.isEmpty();
    }

    public CustomizationCollection<CacheEntryOperationListener<K, V>> getAsyncListeners() {
        if (this.asyncListeners == null) {
            this.asyncListeners = new DefaultCustomizationCollection<CacheEntryOperationListener<K, V>>();
        }
        return this.asyncListeners;
    }

    public boolean hasAsyncListeners() {
        return this.asyncListeners != null && !this.asyncListeners.isEmpty();
    }

    public CustomizationSupplier<ResiliencePolicy<K, V>> getResiliencePolicy() {
        return this.resiliencePolicy;
    }

    public void setResiliencePolicy(CustomizationSupplier<ResiliencePolicy<K, V>> _resiliencePolicy) {
        this.resiliencePolicy = _resiliencePolicy;
    }

    public boolean isStrictEviction() {
        return this.strictEviction;
    }

    public void setStrictEviction(boolean v) {
        this.strictEviction = v;
    }

    public boolean isPermitNullValues() {
        return this.permitNullValues;
    }

    public void setPermitNullValues(boolean v) {
        this.permitNullValues = v;
    }

    public boolean isDisableStatistics() {
        return this.disableStatistics;
    }

    public void setDisableStatistics(boolean v) {
        this.disableStatistics = v;
    }

    public int getEvictionSegmentCount() {
        return this.evictionSegmentCount;
    }

    public void setEvictionSegmentCount(int v) {
        this.evictionSegmentCount = v;
    }

    public CustomizationSupplier<Executor> getLoaderExecutor() {
        return this.loaderExecutor;
    }

    public void setLoaderExecutor(CustomizationSupplier<Executor> v) {
        this.loaderExecutor = v;
    }

    public CustomizationSupplier<Executor> getPrefetchExecutor() {
        return this.prefetchExecutor;
    }

    public void setPrefetchExecutor(CustomizationSupplier<Executor> v) {
        this.prefetchExecutor = v;
    }
}

