/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.spi;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.HashMap;
import java.util.Map;

public class SingleProviderResolver {
    private static Map<Class, Object> providers = new HashMap<Class, Object>();

    public static <T> T resolveMandatory(Class<T> c) {
        T obj = SingleProviderResolver.resolve(c);
        if (obj == null) {
            LinkageError err = new LinkageError("No implementation found for: " + c.getName());
            err.printStackTrace();
            throw err;
        }
        return obj;
    }

    public static synchronized <T> T resolve(Class<T> c) {
        if (providers.containsKey(c)) {
            return (T)providers.get(c);
        }
        try {
            String _className = SingleProviderResolver.readFile("org/cache2k/services/" + c.getName());
            if (_className == null) {
                return null;
            }
            Object obj = SingleProviderResolver.class.getClassLoader().loadClass(_className).newInstance();
            providers.put(c, obj);
            return (T)obj;
        }
        catch (Exception ex) {
            LinkageError err = new LinkageError("Error instantiating " + c.getName(), ex);
            err.printStackTrace();
            throw err;
        }
    }

    private static String readFile(String _name) throws IOException {
        InputStream in = SingleProviderResolver.class.getClassLoader().getResourceAsStream(_name);
        if (in == null) {
            return null;
        }
        LineNumberReader r = new LineNumberReader(new InputStreamReader(in));
        String l = r.readLine();
        while (l != null) {
            if (!l.startsWith("#")) {
                return l;
            }
            l = r.readLine();
        }
        throw new IOException("No class file name in resource: " + _name);
    }
}

