/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.configuration;

import java.util.Collection;
import java.util.concurrent.Executor;
import org.cache2k.TimeReference;
import org.cache2k.Weigher;
import org.cache2k.configuration.CacheType;
import org.cache2k.configuration.CacheTypeCapture;
import org.cache2k.configuration.ConfigurationBean;
import org.cache2k.configuration.ConfigurationSection;
import org.cache2k.configuration.ConfigurationSectionContainer;
import org.cache2k.configuration.ConfigurationWithSections;
import org.cache2k.configuration.CustomizationCollection;
import org.cache2k.configuration.CustomizationSupplier;
import org.cache2k.configuration.DefaultCustomizationCollection;
import org.cache2k.event.CacheClosedListener;
import org.cache2k.event.CacheEntryOperationListener;
import org.cache2k.expiry.ExpiryPolicy;
import org.cache2k.integration.AdvancedCacheLoader;
import org.cache2k.integration.AsyncCacheLoader;
import org.cache2k.integration.CacheWriter;
import org.cache2k.integration.ExceptionPropagator;
import org.cache2k.integration.FunctionalCacheLoader;
import org.cache2k.integration.ResiliencePolicy;

public class Cache2kConfiguration<K, V>
implements ConfigurationBean,
ConfigurationWithSections {
    public static final long EXPIRY_NOT_ETERNAL = 0x7FFFFFFFFFFFFFFEL;
    private boolean storeByReference;
    private String name;
    private CacheType<K> keyType;
    private CacheType<V> valueType;
    private long entryCapacity = -1L;
    private boolean strictEviction = false;
    private boolean refreshAhead = false;
    private long expireAfterWrite = -1L;
    private long retryInterval = -1L;
    private long maxRetryInterval = -1L;
    private long resilienceDuration = -1L;
    private long maximumWeight = -1L;
    private boolean keepDataAfterExpired = false;
    private boolean sharpExpiry = false;
    private boolean suppressExceptions = true;
    private int loaderThreadCount;
    private boolean permitNullValues = false;
    private boolean disableStatistics = false;
    private boolean recordRefreshedTime = false;
    private boolean externalConfigurationPresent = false;
    private boolean boostConcurrency = false;
    private boolean enableJmx = false;
    private CustomizationSupplier<Executor> loaderExecutor;
    private CustomizationSupplier<Executor> prefetchExecutor;
    private CustomizationSupplier<Executor> asyncListenerExecutor;
    private CustomizationSupplier<Executor> executor;
    private CustomizationSupplier<ExpiryPolicy<K, V>> expiryPolicy;
    private CustomizationSupplier<ResiliencePolicy<K, V>> resiliencePolicy;
    private CustomizationSupplier<? extends FunctionalCacheLoader<K, V>> loader;
    private CustomizationSupplier<CacheWriter<K, V>> writer;
    private CustomizationSupplier<AdvancedCacheLoader<K, V>> advancedLoader;
    private CustomizationSupplier<AsyncCacheLoader<K, V>> asyncLoader;
    private CustomizationSupplier<ExceptionPropagator<K>> exceptionPropagator;
    private CustomizationSupplier<TimeReference> timeReference;
    private CustomizationSupplier<Weigher> weigher;
    private CustomizationCollection<CacheEntryOperationListener<K, V>> listeners;
    private CustomizationCollection<CacheEntryOperationListener<K, V>> asyncListeners;
    private CustomizationCollection<CacheClosedListener> closedListeners;
    private ConfigurationSectionContainer sections;

    public static <K, V> Cache2kConfiguration<K, V> of(Class<K> keyType, Class<V> valueType) {
        Cache2kConfiguration<K, V> c = new Cache2kConfiguration<K, V>();
        c.setKeyType(keyType);
        c.setValueType(valueType);
        return c;
    }

    public static <K, V> Cache2kConfiguration<K, V> of(Class<K> keyType, CacheType<V> valueType) {
        Cache2kConfiguration<K, V> c = new Cache2kConfiguration<K, V>();
        c.setKeyType(keyType);
        c.setValueType(valueType);
        return c;
    }

    public static <K, V> Cache2kConfiguration<K, V> of(CacheType<K> keyType, Class<V> valueType) {
        Cache2kConfiguration<K, V> c = new Cache2kConfiguration<K, V>();
        c.setKeyType(keyType);
        c.setValueType(valueType);
        return c;
    }

    public static <K, V> Cache2kConfiguration<K, V> of(CacheType<K> keyType, CacheType<V> valueType) {
        Cache2kConfiguration<K, V> c = new Cache2kConfiguration<K, V>();
        c.setKeyType(keyType);
        c.setValueType(valueType);
        return c;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getEntryCapacity() {
        return this.entryCapacity;
    }

    public void setEntryCapacity(long v) {
        this.entryCapacity = v;
    }

    public boolean isRefreshAhead() {
        return this.refreshAhead;
    }

    public void setRefreshAhead(boolean v) {
        this.refreshAhead = v;
    }

    public CacheType<K> getKeyType() {
        return this.keyType;
    }

    private void checkNull(Object v) {
        if (v == null) {
            throw new NullPointerException("null value not allowed");
        }
    }

    public void setKeyType(Class<K> v) {
        this.checkNull(v);
        this.setKeyType(CacheTypeCapture.of(v));
    }

    public void setKeyType(CacheType<K> v) {
        this.checkNull(v);
        if (v.isArray()) {
            throw new IllegalArgumentException("Arrays are not supported for keys");
        }
        this.keyType = v.getBeanRepresentation();
    }

    public CacheType<V> getValueType() {
        return this.valueType;
    }

    public void setValueType(Class<V> v) {
        this.checkNull(v);
        this.setValueType(CacheTypeCapture.of(v));
    }

    public void setValueType(CacheType<V> v) {
        this.checkNull(v);
        if (v.isArray()) {
            throw new IllegalArgumentException("Arrays are not supported for values");
        }
        this.valueType = v.getBeanRepresentation();
    }

    public boolean isEternal() {
        return this.expireAfterWrite == -1L || this.expireAfterWrite == Long.MAX_VALUE;
    }

    public void setEternal(boolean v) {
        if (v) {
            this.setExpireAfterWrite(Long.MAX_VALUE);
        } else {
            this.setExpireAfterWrite(0x7FFFFFFFFFFFFFFEL);
        }
    }

    public long getExpireAfterWrite() {
        return this.expireAfterWrite;
    }

    public void setExpireAfterWrite(long millis) {
        if (millis == this.expireAfterWrite) {
            return;
        }
        if (this.expireAfterWrite != -1L) {
            if (millis == Long.MAX_VALUE) {
                throw new IllegalArgumentException("eternal disabled or expiry was set, refusing to reset back to eternal");
            }
            if (this.expireAfterWrite == Long.MAX_VALUE) {
                throw new IllegalArgumentException("eternal enabled explicitly, refusing to enable expiry");
            }
        }
        this.expireAfterWrite = millis;
    }

    public long getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(long millis) {
        this.retryInterval = millis;
    }

    public long getMaxRetryInterval() {
        return this.maxRetryInterval;
    }

    public void setMaxRetryInterval(long millis) {
        if (this.entryCapacity >= 0L) {
            // empty if block
        }
        this.maxRetryInterval = millis;
    }

    public long getResilienceDuration() {
        return this.resilienceDuration;
    }

    public void setResilienceDuration(long millis) {
        this.resilienceDuration = millis;
    }

    public boolean isKeepDataAfterExpired() {
        return this.keepDataAfterExpired;
    }

    public long getMaximumWeight() {
        return this.maximumWeight;
    }

    public void setMaximumWeight(long v) {
        if (this.entryCapacity >= 0L) {
            throw new IllegalArgumentException("entryCapacity already set, setting maximumWeight is illegal");
        }
        this.maximumWeight = v;
    }

    public void setKeepDataAfterExpired(boolean v) {
        this.keepDataAfterExpired = v;
    }

    public boolean isSharpExpiry() {
        return this.sharpExpiry;
    }

    public void setSharpExpiry(boolean v) {
        this.sharpExpiry = v;
    }

    public boolean isSuppressExceptions() {
        return this.suppressExceptions;
    }

    public void setSuppressExceptions(boolean v) {
        this.suppressExceptions = v;
    }

    public boolean isExternalConfigurationPresent() {
        return this.externalConfigurationPresent;
    }

    public void setExternalConfigurationPresent(boolean v) {
        this.externalConfigurationPresent = v;
    }

    @Override
    public ConfigurationSectionContainer getSections() {
        if (this.sections == null) {
            this.sections = new ConfigurationSectionContainer();
        }
        return this.sections;
    }

    public void setSections(Collection<ConfigurationSection> c) {
        this.getSections().addAll(c);
    }

    public CustomizationSupplier<? extends FunctionalCacheLoader<K, V>> getLoader() {
        return this.loader;
    }

    public void setLoader(CustomizationSupplier<? extends FunctionalCacheLoader<K, V>> v) {
        this.loader = v;
    }

    public CustomizationSupplier<AdvancedCacheLoader<K, V>> getAdvancedLoader() {
        return this.advancedLoader;
    }

    public void setAdvancedLoader(CustomizationSupplier<AdvancedCacheLoader<K, V>> v) {
        this.advancedLoader = v;
    }

    public CustomizationSupplier<AsyncCacheLoader<K, V>> getAsyncLoader() {
        return this.asyncLoader;
    }

    public void setAsyncLoader(CustomizationSupplier<AsyncCacheLoader<K, V>> v) {
        this.asyncLoader = v;
    }

    public int getLoaderThreadCount() {
        return this.loaderThreadCount;
    }

    public void setLoaderThreadCount(int v) {
        this.loaderThreadCount = v;
    }

    public CustomizationSupplier<ExpiryPolicy<K, V>> getExpiryPolicy() {
        return this.expiryPolicy;
    }

    public void setExpiryPolicy(CustomizationSupplier<ExpiryPolicy<K, V>> v) {
        this.expiryPolicy = v;
    }

    public CustomizationSupplier<CacheWriter<K, V>> getWriter() {
        return this.writer;
    }

    public void setWriter(CustomizationSupplier<CacheWriter<K, V>> v) {
        this.writer = v;
    }

    public boolean isStoreByReference() {
        return this.storeByReference;
    }

    public void setStoreByReference(boolean v) {
        this.storeByReference = v;
    }

    public CustomizationSupplier<ExceptionPropagator<K>> getExceptionPropagator() {
        return this.exceptionPropagator;
    }

    public void setExceptionPropagator(CustomizationSupplier<ExceptionPropagator<K>> v) {
        this.exceptionPropagator = v;
    }

    public CustomizationCollection<CacheEntryOperationListener<K, V>> getListeners() {
        if (this.listeners == null) {
            this.listeners = new DefaultCustomizationCollection<CacheEntryOperationListener<K, V>>();
        }
        return this.listeners;
    }

    public boolean hasListeners() {
        return this.listeners != null && !this.listeners.isEmpty();
    }

    public void setListeners(Collection<CustomizationSupplier<CacheEntryOperationListener<K, V>>> c) {
        this.getListeners().addAll(c);
    }

    public CustomizationCollection<CacheEntryOperationListener<K, V>> getAsyncListeners() {
        if (this.asyncListeners == null) {
            this.asyncListeners = new DefaultCustomizationCollection<CacheEntryOperationListener<K, V>>();
        }
        return this.asyncListeners;
    }

    public boolean hasAsyncListeners() {
        return this.asyncListeners != null && !this.asyncListeners.isEmpty();
    }

    public void setAsyncListeners(Collection<CustomizationSupplier<CacheEntryOperationListener<K, V>>> c) {
        this.getAsyncListeners().addAll(c);
    }

    public CustomizationCollection<CacheClosedListener> getCacheClosedListeners() {
        if (this.closedListeners == null) {
            this.closedListeners = new DefaultCustomizationCollection<CacheClosedListener>();
        }
        return this.closedListeners;
    }

    public boolean hasCacheClosedListeners() {
        return this.closedListeners != null && !this.closedListeners.isEmpty();
    }

    public void setCacheClosedListeners(Collection<CustomizationSupplier<CacheClosedListener>> c) {
        this.getCacheClosedListeners().addAll(c);
    }

    public CustomizationSupplier<ResiliencePolicy<K, V>> getResiliencePolicy() {
        return this.resiliencePolicy;
    }

    public void setResiliencePolicy(CustomizationSupplier<ResiliencePolicy<K, V>> v) {
        this.resiliencePolicy = v;
    }

    public boolean isStrictEviction() {
        return this.strictEviction;
    }

    public void setStrictEviction(boolean v) {
        this.strictEviction = v;
    }

    public boolean isPermitNullValues() {
        return this.permitNullValues;
    }

    public void setPermitNullValues(boolean v) {
        this.permitNullValues = v;
    }

    public boolean isDisableStatistics() {
        return this.disableStatistics;
    }

    public void setDisableStatistics(boolean v) {
        this.disableStatistics = v;
    }

    public CustomizationSupplier<Executor> getLoaderExecutor() {
        return this.loaderExecutor;
    }

    @Deprecated
    public boolean isDisableLastModificationTime() {
        return false;
    }

    @Deprecated
    public void setDisableLastModificationTime(boolean v) {
    }

    public boolean isRecordRefreshedTime() {
        return this.recordRefreshedTime;
    }

    public void setRecordRefreshedTime(boolean v) {
        this.recordRefreshedTime = v;
    }

    public void setLoaderExecutor(CustomizationSupplier<Executor> v) {
        this.loaderExecutor = v;
    }

    public CustomizationSupplier<Executor> getPrefetchExecutor() {
        return this.prefetchExecutor;
    }

    public void setPrefetchExecutor(CustomizationSupplier<Executor> v) {
        this.prefetchExecutor = v;
    }

    public CustomizationSupplier<Executor> getExecutor() {
        return this.executor;
    }

    public void setExecutor(CustomizationSupplier<Executor> v) {
        this.executor = v;
    }

    public CustomizationSupplier<Executor> getAsyncListenerExecutor() {
        return this.asyncListenerExecutor;
    }

    public void setAsyncListenerExecutor(CustomizationSupplier<Executor> v) {
        this.asyncListenerExecutor = v;
    }

    public CustomizationSupplier<TimeReference> getTimeReference() {
        return this.timeReference;
    }

    public void setTimeReference(CustomizationSupplier<TimeReference> v) {
        this.timeReference = v;
    }

    public CustomizationSupplier<Weigher> getWeigher() {
        return this.weigher;
    }

    public void setWeigher(CustomizationSupplier<Weigher> v) {
        if (this.entryCapacity >= 0L) {
            throw new IllegalArgumentException("entryCapacity already set, specifying a weigher is illegal");
        }
        this.weigher = v;
    }

    public boolean isBoostConcurrency() {
        return this.boostConcurrency;
    }

    public void setBoostConcurrency(boolean v) {
        this.boostConcurrency = v;
    }

    public boolean isEnableJmx() {
        return this.enableJmx;
    }

    public void setEnableJmx(boolean v) {
        this.enableJmx = v;
    }
}

