package org.cache2k;

/*
 * #%L
 * cache2k API
 * %%
 * Copyright (C) 2000 - 2020 headissue GmbH, Munich
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

/**
 * Base interface for all cache customizations. Customizations are code that get attached
 * to a cache which extend and modify its behavior. Typical exceptions are
 * {@link org.cache2k.io.CacheLoader} and the {@link org.cache2k.expiry.ExpiryPolicy}.
 *
 * <p>A customization may implement the interface
 * {@link org.cache2k.configuration.BuildContextAwareCustomization} if it needs access
 * to configuration values ore the cache manager properties.
 *
 * <p>A customization may implement {@link java.io.Closeable} to be notified upon
 * cache shutdown.
 *
 * @author Jens Wilke
 */
public interface Customization {
}
