/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.configuration;

import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.Executor;
import org.cache2k.TimeReference;
import org.cache2k.Weigher;
import org.cache2k.configuration.CacheType;
import org.cache2k.configuration.CacheTypeCapture;
import org.cache2k.configuration.ConfigurationBean;
import org.cache2k.configuration.ConfigurationSection;
import org.cache2k.configuration.ConfigurationSectionContainer;
import org.cache2k.configuration.ConfigurationWithSections;
import org.cache2k.configuration.CustomizationCollection;
import org.cache2k.configuration.CustomizationSupplier;
import org.cache2k.configuration.DefaultCustomizationCollection;
import org.cache2k.event.CacheClosedListener;
import org.cache2k.event.CacheEntryOperationListener;
import org.cache2k.expiry.ExpiryPolicy;
import org.cache2k.io.AdvancedCacheLoader;
import org.cache2k.io.AsyncCacheLoader;
import org.cache2k.io.CacheLoader;
import org.cache2k.io.CacheWriter;
import org.cache2k.io.ExceptionPropagator;
import org.cache2k.io.ResiliencePolicy;

public class Cache2kConfiguration<K, V>
implements ConfigurationBean,
ConfigurationWithSections {
    public static final Duration ETERNAL_DURATION = Duration.ofMillis(Long.MAX_VALUE);
    public static final Duration EXPIRY_NOT_ETERNAL = Duration.ofMillis(0x7FFFFFFFFFFFFFFEL);
    public static final long UNSET_LONG = -1L;
    private boolean storeByReference;
    private String name;
    private CacheType<K> keyType;
    private CacheType<V> valueType;
    private long entryCapacity = -1L;
    private boolean strictEviction = false;
    private boolean refreshAhead = false;
    private Duration expireAfterWrite = null;
    private Duration retryInterval = null;
    private Duration maxRetryInterval = null;
    private Duration resilienceDuration = null;
    private Duration timerLag = null;
    private long maximumWeight = -1L;
    private boolean keepDataAfterExpired = false;
    private boolean sharpExpiry = false;
    private boolean suppressExceptions = true;
    private int loaderThreadCount;
    private boolean permitNullValues = false;
    private boolean disableStatistics = false;
    private boolean recordRefreshedTime = false;
    private boolean externalConfigurationPresent = false;
    private boolean boostConcurrency = false;
    private boolean enableJmx = false;
    private boolean disableMonitoring = false;
    private CustomizationSupplier<Executor> loaderExecutor;
    private CustomizationSupplier<Executor> refreshExecutor;
    private CustomizationSupplier<Executor> asyncListenerExecutor;
    private CustomizationSupplier<Executor> executor;
    private CustomizationSupplier<ExpiryPolicy<K, V>> expiryPolicy;
    private CustomizationSupplier<ResiliencePolicy<K, V>> resiliencePolicy;
    private CustomizationSupplier<CacheLoader<K, V>> loader;
    private CustomizationSupplier<CacheWriter<K, V>> writer;
    private CustomizationSupplier<AdvancedCacheLoader<K, V>> advancedLoader;
    private CustomizationSupplier<AsyncCacheLoader<K, V>> asyncLoader;
    private CustomizationSupplier<ExceptionPropagator<K>> exceptionPropagator;
    private CustomizationSupplier<TimeReference> timeReference;
    private CustomizationSupplier<Weigher> weigher;
    private CustomizationCollection<CacheEntryOperationListener<K, V>> listeners;
    private CustomizationCollection<CacheEntryOperationListener<K, V>> asyncListeners;
    private CustomizationCollection<CacheClosedListener> closedListeners;
    private ConfigurationSectionContainer sections;

    public static <K, V> Cache2kConfiguration<K, V> of(Class<K> keyType, Class<V> valueType) {
        Cache2kConfiguration<K, V> c = new Cache2kConfiguration<K, V>();
        c.setKeyType(keyType);
        c.setValueType(valueType);
        return c;
    }

    public static <K, V> Cache2kConfiguration<K, V> of(Class<K> keyType, CacheType<V> valueType) {
        Cache2kConfiguration<K, V> c = new Cache2kConfiguration<K, V>();
        c.setKeyType(keyType);
        c.setValueType(valueType);
        return c;
    }

    public static <K, V> Cache2kConfiguration<K, V> of(CacheType<K> keyType, Class<V> valueType) {
        Cache2kConfiguration<K, V> c = new Cache2kConfiguration<K, V>();
        c.setKeyType(keyType);
        c.setValueType(valueType);
        return c;
    }

    public static <K, V> Cache2kConfiguration<K, V> of(CacheType<K> keyType, CacheType<V> valueType) {
        Cache2kConfiguration<K, V> c = new Cache2kConfiguration<K, V>();
        c.setKeyType(keyType);
        c.setValueType(valueType);
        return c;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getEntryCapacity() {
        return this.entryCapacity;
    }

    public void setEntryCapacity(long v) {
        this.entryCapacity = v;
    }

    public boolean isRefreshAhead() {
        return this.refreshAhead;
    }

    public void setRefreshAhead(boolean v) {
        this.refreshAhead = v;
    }

    public CacheType<K> getKeyType() {
        return this.keyType;
    }

    private void checkNull(Object v) {
        if (v == null) {
            throw new NullPointerException("null value not allowed");
        }
    }

    public void setKeyType(Class<K> v) {
        this.checkNull(v);
        this.setKeyType(CacheTypeCapture.of(v));
    }

    public void setKeyType(CacheType<K> v) {
        this.checkNull(v);
        if (v.isArray()) {
            throw new IllegalArgumentException("Arrays are not supported for keys");
        }
        this.keyType = v.getBeanRepresentation();
    }

    public CacheType<V> getValueType() {
        return this.valueType;
    }

    public void setValueType(Class<V> v) {
        this.checkNull(v);
        this.setValueType(CacheTypeCapture.of(v));
    }

    public void setValueType(CacheType<V> v) {
        this.checkNull(v);
        if (v.isArray()) {
            throw new IllegalArgumentException("Arrays are not supported for values");
        }
        this.valueType = v.getBeanRepresentation();
    }

    public boolean isEternal() {
        return this.expireAfterWrite == null || this.expireAfterWrite == ETERNAL_DURATION;
    }

    public void setEternal(boolean v) {
        if (v) {
            this.setExpireAfterWrite(ETERNAL_DURATION);
        } else {
            this.setExpireAfterWrite(EXPIRY_NOT_ETERNAL);
        }
    }

    public Duration getExpireAfterWrite() {
        return this.expireAfterWrite;
    }

    public void setExpireAfterWrite(Duration v) {
        if ((v = this.durationCeiling(v)).isNegative()) {
            throw new IllegalArgumentException("Duration must be positive");
        }
        if (v == this.expireAfterWrite || v.equals(this.expireAfterWrite)) {
            return;
        }
        if (this.expireAfterWrite != null) {
            if (v == ETERNAL_DURATION) {
                throw new IllegalArgumentException("eternal disabled or expiry was set, refusing to reset back to eternal");
            }
            if (this.expireAfterWrite == ETERNAL_DURATION) {
                throw new IllegalArgumentException("eternal enabled explicitly, refusing to enable expiry");
            }
        }
        this.expireAfterWrite = v;
    }

    public Duration getTimerLag() {
        return this.timerLag;
    }

    public void setTimerLag(Duration v) {
        this.timerLag = this.durationCeiling(v);
    }

    public Duration getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(Duration v) {
        this.retryInterval = this.durationCeiling(v);
    }

    public Duration getMaxRetryInterval() {
        return this.maxRetryInterval;
    }

    public void setMaxRetryInterval(Duration v) {
        this.maxRetryInterval = this.durationCeiling(v);
    }

    public Duration getResilienceDuration() {
        return this.resilienceDuration;
    }

    public void setResilienceDuration(Duration v) {
        this.resilienceDuration = this.durationCeiling(v);
    }

    public boolean isKeepDataAfterExpired() {
        return this.keepDataAfterExpired;
    }

    public long getMaximumWeight() {
        return this.maximumWeight;
    }

    public void setMaximumWeight(long v) {
        if (this.entryCapacity >= 0L) {
            throw new IllegalArgumentException("entryCapacity already set, setting maximumWeight is illegal");
        }
        this.maximumWeight = v;
    }

    public void setKeepDataAfterExpired(boolean v) {
        this.keepDataAfterExpired = v;
    }

    public boolean isSharpExpiry() {
        return this.sharpExpiry;
    }

    public void setSharpExpiry(boolean v) {
        this.sharpExpiry = v;
    }

    public boolean isSuppressExceptions() {
        return this.suppressExceptions;
    }

    public void setSuppressExceptions(boolean v) {
        this.suppressExceptions = v;
    }

    public boolean isExternalConfigurationPresent() {
        return this.externalConfigurationPresent;
    }

    public void setExternalConfigurationPresent(boolean v) {
        this.externalConfigurationPresent = v;
    }

    @Override
    public ConfigurationSectionContainer getSections() {
        if (this.sections == null) {
            this.sections = new ConfigurationSectionContainer();
        }
        return this.sections;
    }

    public void setSections(Collection<ConfigurationSection> c) {
        this.getSections().addAll(c);
    }

    public CustomizationSupplier<CacheLoader<K, V>> getLoader() {
        return this.loader;
    }

    public void setLoader(CustomizationSupplier<CacheLoader<K, V>> v) {
        this.loader = v;
    }

    public CustomizationSupplier<AdvancedCacheLoader<K, V>> getAdvancedLoader() {
        return this.advancedLoader;
    }

    public void setAdvancedLoader(CustomizationSupplier<AdvancedCacheLoader<K, V>> v) {
        this.advancedLoader = v;
    }

    public CustomizationSupplier<AsyncCacheLoader<K, V>> getAsyncLoader() {
        return this.asyncLoader;
    }

    public void setAsyncLoader(CustomizationSupplier<AsyncCacheLoader<K, V>> v) {
        this.asyncLoader = v;
    }

    public int getLoaderThreadCount() {
        return this.loaderThreadCount;
    }

    public void setLoaderThreadCount(int v) {
        this.loaderThreadCount = v;
    }

    public CustomizationSupplier<ExpiryPolicy<K, V>> getExpiryPolicy() {
        return this.expiryPolicy;
    }

    public void setExpiryPolicy(CustomizationSupplier<ExpiryPolicy<K, V>> v) {
        this.expiryPolicy = v;
    }

    public CustomizationSupplier<CacheWriter<K, V>> getWriter() {
        return this.writer;
    }

    public void setWriter(CustomizationSupplier<CacheWriter<K, V>> v) {
        this.writer = v;
    }

    public boolean isStoreByReference() {
        return this.storeByReference;
    }

    public void setStoreByReference(boolean v) {
        this.storeByReference = v;
    }

    public CustomizationSupplier<ExceptionPropagator<K>> getExceptionPropagator() {
        return this.exceptionPropagator;
    }

    public void setExceptionPropagator(CustomizationSupplier<ExceptionPropagator<K>> v) {
        this.exceptionPropagator = v;
    }

    public CustomizationCollection<CacheEntryOperationListener<K, V>> getListeners() {
        if (this.listeners == null) {
            this.listeners = new DefaultCustomizationCollection<CacheEntryOperationListener<K, V>>();
        }
        return this.listeners;
    }

    public boolean hasListeners() {
        return this.listeners != null && !this.listeners.isEmpty();
    }

    public void setListeners(Collection<CustomizationSupplier<CacheEntryOperationListener<K, V>>> c) {
        this.getListeners().addAll(c);
    }

    public CustomizationCollection<CacheEntryOperationListener<K, V>> getAsyncListeners() {
        if (this.asyncListeners == null) {
            this.asyncListeners = new DefaultCustomizationCollection<CacheEntryOperationListener<K, V>>();
        }
        return this.asyncListeners;
    }

    public boolean hasAsyncListeners() {
        return this.asyncListeners != null && !this.asyncListeners.isEmpty();
    }

    public void setAsyncListeners(Collection<CustomizationSupplier<CacheEntryOperationListener<K, V>>> c) {
        this.getAsyncListeners().addAll(c);
    }

    public CustomizationCollection<CacheClosedListener> getCacheClosedListeners() {
        if (this.closedListeners == null) {
            this.closedListeners = new DefaultCustomizationCollection<CacheClosedListener>();
        }
        return this.closedListeners;
    }

    public boolean hasCacheClosedListeners() {
        return this.closedListeners != null && !this.closedListeners.isEmpty();
    }

    public void setCacheClosedListeners(Collection<CustomizationSupplier<CacheClosedListener>> c) {
        this.getCacheClosedListeners().addAll(c);
    }

    public CustomizationSupplier<ResiliencePolicy<K, V>> getResiliencePolicy() {
        return this.resiliencePolicy;
    }

    public void setResiliencePolicy(CustomizationSupplier<ResiliencePolicy<K, V>> v) {
        this.resiliencePolicy = v;
    }

    public boolean isStrictEviction() {
        return this.strictEviction;
    }

    public void setStrictEviction(boolean v) {
        this.strictEviction = v;
    }

    public boolean isPermitNullValues() {
        return this.permitNullValues;
    }

    public void setPermitNullValues(boolean v) {
        this.permitNullValues = v;
    }

    public boolean isDisableStatistics() {
        return this.disableStatistics;
    }

    public void setDisableStatistics(boolean v) {
        this.disableStatistics = v;
    }

    public CustomizationSupplier<Executor> getLoaderExecutor() {
        return this.loaderExecutor;
    }

    public boolean isRecordRefreshedTime() {
        return this.recordRefreshedTime;
    }

    public void setRecordRefreshedTime(boolean v) {
        this.recordRefreshedTime = v;
    }

    public void setLoaderExecutor(CustomizationSupplier<Executor> v) {
        this.loaderExecutor = v;
    }

    public CustomizationSupplier<Executor> getRefreshExecutor() {
        return this.refreshExecutor;
    }

    public void setRefreshExecutor(CustomizationSupplier<Executor> v) {
        this.refreshExecutor = v;
    }

    public CustomizationSupplier<Executor> getExecutor() {
        return this.executor;
    }

    public void setExecutor(CustomizationSupplier<Executor> v) {
        this.executor = v;
    }

    public CustomizationSupplier<Executor> getAsyncListenerExecutor() {
        return this.asyncListenerExecutor;
    }

    public void setAsyncListenerExecutor(CustomizationSupplier<Executor> v) {
        this.asyncListenerExecutor = v;
    }

    public CustomizationSupplier<TimeReference> getTimeReference() {
        return this.timeReference;
    }

    public void setTimeReference(CustomizationSupplier<TimeReference> v) {
        this.timeReference = v;
    }

    public CustomizationSupplier<Weigher> getWeigher() {
        return this.weigher;
    }

    public void setWeigher(CustomizationSupplier<Weigher> v) {
        if (this.entryCapacity >= 0L) {
            throw new IllegalArgumentException("entryCapacity already set, specifying a weigher is illegal");
        }
        this.weigher = v;
    }

    public boolean isBoostConcurrency() {
        return this.boostConcurrency;
    }

    public void setBoostConcurrency(boolean v) {
        this.boostConcurrency = v;
    }

    public boolean isEnableJmx() {
        return this.enableJmx;
    }

    public void setEnableJmx(boolean v) {
        this.enableJmx = v;
    }

    public boolean isDisableMonitoring() {
        return this.disableMonitoring;
    }

    public void setDisableMonitoring(boolean disableMonitoring) {
        this.disableMonitoring = disableMonitoring;
    }

    private Duration durationCeiling(Duration v) {
        if (v != null && ETERNAL_DURATION.compareTo(v) <= 0) {
            v = ETERNAL_DURATION;
        }
        return v;
    }
}

