/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.configuration;

import org.cache2k.configuration.CacheBuildContext;
import org.cache2k.configuration.CustomizationSupplier;
import org.cache2k.configuration.ValidatingConfigurationBean;

public final class CustomizationSupplierByClassName<T>
implements CustomizationSupplier<T>,
ValidatingConfigurationBean {
    private String className;

    public CustomizationSupplierByClassName() {
    }

    public CustomizationSupplierByClassName(String className) {
        if (className == null) {
            throw new NullPointerException("className");
        }
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String v) {
        this.className = v;
    }

    @Override
    public void validate() {
        if (this.className == null) {
            throw new IllegalArgumentException("className not set");
        }
    }

    @Override
    public T supply(CacheBuildContext ctx) {
        try {
            return (T)ctx.getCacheManager().getClassLoader().loadClass(this.className).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new LinkageError("error loading customization class", e);
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CustomizationSupplierByClassName)) {
            return false;
        }
        CustomizationSupplierByClassName that = (CustomizationSupplierByClassName)other;
        return this.className.equals(that.className);
    }

    public int hashCode() {
        return this.className.hashCode();
    }
}

