/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k;

import java.io.Closeable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.cache2k.CacheEntry;
import org.cache2k.CacheManager;
import org.cache2k.CacheOperationCompletionListener;
import org.cache2k.DataAware;
import org.cache2k.KeyValueStore;
import org.cache2k.io.CacheLoaderException;
import org.cache2k.processor.EntryMutator;
import org.cache2k.processor.EntryProcessingResult;
import org.cache2k.processor.EntryProcessor;
import org.cache2k.processor.MutableCacheEntry;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface Cache<K, V>
extends KeyValueStore<K, V>,
DataAware<K, V>,
Closeable {
    public String getName();

    @Override
    public @Nullable V get(K var1);

    public @Nullable CacheEntry<K, V> getEntry(K var1);

    public @Nullable V peek(K var1);

    public @Nullable CacheEntry<K, V> peekEntry(K var1);

    public boolean containsKey(K var1);

    @Override
    public void put(K var1, V var2);

    @Deprecated
    default public V computeIfAbsent(K key, Callable<V> callable) {
        return (V)this.computeIfAbsent(key, (? super K k) -> {
            try {
                return callable.call();
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception exception) {
                throw new CacheLoaderException(exception);
            }
        });
    }

    public V computeIfAbsent(K var1, Function<? super K, ? extends V> var2);

    public boolean putIfAbsent(K var1, V var2);

    public @Nullable V peekAndReplace(K var1, V var2);

    public boolean replace(K var1, V var2);

    public boolean replaceIfEquals(K var1, V var2, V var3);

    public @Nullable V peekAndRemove(K var1);

    public boolean containsAndRemove(K var1);

    @Override
    public void remove(K var1);

    public boolean removeIfEquals(K var1, V var2);

    @Override
    public void removeAll(Iterable<? extends K> var1);

    public @Nullable V peekAndPut(K var1, V var2);

    @Deprecated
    public void expireAt(K var1, long var2);

    @Deprecated
    public void loadAll(Iterable<? extends K> var1, CacheOperationCompletionListener var2);

    @Deprecated
    public void reloadAll(Iterable<? extends K> var1, CacheOperationCompletionListener var2);

    public CompletableFuture<Void> loadAll(Iterable<? extends K> var1);

    public CompletableFuture<Void> reloadAll(Iterable<? extends K> var1);

    public <R> @Nullable R invoke(K var1, EntryProcessor<K, V, R> var2);

    default public void mutate(K key, final EntryMutator<K, V> mutator) {
        this.invoke(key, new EntryProcessor<K, V, Void>(){

            @Override
            public @Nullable Void process(MutableCacheEntry<K, V> entry) throws Exception {
                mutator.mutate(entry);
                return null;
            }
        });
    }

    public <R> Map<K, EntryProcessingResult<R>> invokeAll(Iterable<? extends K> var1, EntryProcessor<K, V, R> var2);

    default public void mutateAll(Iterable<? extends K> keys, EntryMutator<K, V> mutator) {
        this.invokeAll(keys, entry -> {
            mutator.mutate(entry);
            return null;
        });
    }

    @Override
    public Map<K, V> getAll(Iterable<? extends K> var1);

    public Map<K, V> peekAll(Iterable<? extends K> var1);

    @Override
    public void putAll(Map<? extends K, ? extends V> var1);

    public Set<K> keys();

    public Set<CacheEntry<K, V>> entries();

    public void removeAll();

    public void clear();

    @Override
    public void close();

    public CacheManager getCacheManager();

    public boolean isClosed();

    public String toString();

    public <T> T requestInterface(Class<T> var1);

    public ConcurrentMap<K, V> asMap();
}

