/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.config;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import org.cache2k.Cache2kBuilder;
import org.cache2k.DataAware;
import org.cache2k.Weigher;
import org.cache2k.config.CacheType;
import org.cache2k.config.CacheWrapper;
import org.cache2k.config.ConfigBean;
import org.cache2k.config.ConfigSection;
import org.cache2k.config.ConfigWithSections;
import org.cache2k.config.CustomizationSupplier;
import org.cache2k.config.Feature;
import org.cache2k.config.SectionContainer;
import org.cache2k.event.CacheEntryOperationListener;
import org.cache2k.event.CacheLifecycleListener;
import org.cache2k.expiry.ExpiryPolicy;
import org.cache2k.io.AdvancedCacheLoader;
import org.cache2k.io.AsyncCacheLoader;
import org.cache2k.io.CacheLoader;
import org.cache2k.io.CacheWriter;
import org.cache2k.io.ExceptionPropagator;
import org.cache2k.io.ResiliencePolicy;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Cache2kConfig<K, V>
implements ConfigBean<Cache2kConfig<K, V>, Cache2kBuilder<K, V>>,
DataAware<K, V>,
ConfigWithSections {
    public static final Duration EXPIRY_ETERNAL = Duration.ofMillis(Long.MAX_VALUE);
    public static final Duration EXPIRY_NOT_ETERNAL = Duration.ofMillis(0x7FFFFFFFFFFFFFFEL);
    public static final long UNSET_LONG = -1L;
    private boolean storeByReference;
    private @Nullable String name;
    private boolean nameWasGenerated;
    private @Nullable CacheType<K> keyType;
    private @Nullable CacheType<V> valueType;
    private long entryCapacity = -1L;
    private @Nullable Duration expireAfterWrite = null;
    private @Nullable Duration timerLag = null;
    private long maximumWeight = -1L;
    private int loaderThreadCount;
    private boolean eternal = false;
    private boolean keepDataAfterExpired = false;
    private boolean sharpExpiry = false;
    private boolean strictEviction = false;
    private boolean refreshAhead = false;
    private boolean permitNullValues = false;
    private boolean recordModificationTime = false;
    private boolean boostConcurrency = false;
    private boolean disableStatistics = false;
    private boolean disableMonitoring = false;
    private boolean externalConfigurationPresent = false;
    private @Nullable CustomizationSupplier<? extends Executor> loaderExecutor;
    private @Nullable CustomizationSupplier<? extends Executor> refreshExecutor;
    private @Nullable CustomizationSupplier<? extends Executor> asyncListenerExecutor;
    private @Nullable CustomizationSupplier<? extends Executor> executor;
    private @Nullable CustomizationSupplier<? extends ExpiryPolicy<? super K, ? super V>> expiryPolicy;
    private @Nullable CustomizationSupplier<? extends ResiliencePolicy<? super K, ? super V>> resiliencePolicy;
    private @Nullable CustomizationSupplier<? extends CacheLoader<K, V>> loader;
    private @Nullable CustomizationSupplier<? extends CacheWriter<K, V>> writer;
    private @Nullable CustomizationSupplier<? extends AdvancedCacheLoader<K, V>> advancedLoader;
    private @Nullable CustomizationSupplier<? extends AsyncCacheLoader<K, V>> asyncLoader;
    private @Nullable CustomizationSupplier<? extends ExceptionPropagator<? super K, ? super V>> exceptionPropagator;
    private @Nullable CustomizationSupplier<? extends Weigher<K, V>> weigher;
    private @Nullable Collection<CustomizationSupplier<CacheEntryOperationListener<K, V>>> listeners;
    private @Nullable Collection<CustomizationSupplier<CacheEntryOperationListener<K, V>>> asyncListeners;
    private @Nullable Collection<CustomizationSupplier<CacheLifecycleListener>> lifecycleListeners;
    private @Nullable Set<Feature> features;
    private @Nullable SectionContainer sections;
    private @Nullable CacheWrapper traceCacheWrapper;
    private @Nullable CacheWrapper cacheWrapper;

    public static <K, V> Cache2kConfig<K, V> of(Class<K> keyType, Class<V> valueType) {
        Cache2kConfig<K, V> c = new Cache2kConfig<K, V>();
        c.setKeyType(CacheType.of(keyType));
        c.setValueType(CacheType.of(valueType));
        return c;
    }

    public static <K, V> Cache2kConfig<K, V> of(CacheType<K> keyType, CacheType<V> valueType) {
        Cache2kConfig<K, V> c = new Cache2kConfig<K, V>();
        c.setKeyType(keyType);
        c.setValueType(valueType);
        return c;
    }

    public @Nullable String getName() {
        return this.name;
    }

    public void setName(@Nullable String name) {
        this.name = name;
    }

    public boolean isNameWasGenerated() {
        return this.nameWasGenerated;
    }

    public void setNameWasGenerated(boolean v) {
        this.nameWasGenerated = v;
    }

    public long getEntryCapacity() {
        return this.entryCapacity;
    }

    public void setEntryCapacity(long v) {
        this.entryCapacity = v;
    }

    public boolean isRefreshAhead() {
        return this.refreshAhead;
    }

    public void setRefreshAhead(boolean v) {
        this.refreshAhead = v;
    }

    public @Nullable CacheType<K> getKeyType() {
        return this.keyType;
    }

    public void setKeyType(@Nullable CacheType<K> v) {
        if (v == null) {
            this.valueType = null;
            return;
        }
        if (v.isArray()) {
            throw new IllegalArgumentException("Arrays are not supported for keys");
        }
        this.keyType = v;
    }

    public @Nullable CacheType<V> getValueType() {
        return this.valueType;
    }

    public void setValueType(@Nullable CacheType<V> v) {
        if (v == null) {
            this.valueType = null;
            return;
        }
        if (v.isArray()) {
            throw new IllegalArgumentException("Arrays are not supported for values");
        }
        this.valueType = v;
    }

    public @Nullable Duration getExpireAfterWrite() {
        return this.expireAfterWrite;
    }

    public void setExpireAfterWrite(@Nullable Duration v) {
        this.expireAfterWrite = this.durationCheckAndSanitize(v);
    }

    public boolean isEternal() {
        return this.eternal;
    }

    public void setEternal(boolean v) {
        this.eternal = v;
    }

    public @Nullable Duration getTimerLag() {
        return this.timerLag;
    }

    public void setTimerLag(@Nullable Duration v) {
        this.timerLag = this.durationCheckAndSanitize(v);
    }

    public boolean isKeepDataAfterExpired() {
        return this.keepDataAfterExpired;
    }

    public long getMaximumWeight() {
        return this.maximumWeight;
    }

    public void setMaximumWeight(long v) {
        this.maximumWeight = v;
    }

    public void setKeepDataAfterExpired(boolean v) {
        this.keepDataAfterExpired = v;
    }

    public boolean isSharpExpiry() {
        return this.sharpExpiry;
    }

    public void setSharpExpiry(boolean v) {
        this.sharpExpiry = v;
    }

    public boolean isExternalConfigurationPresent() {
        return this.externalConfigurationPresent;
    }

    public void setExternalConfigurationPresent(boolean v) {
        this.externalConfigurationPresent = v;
    }

    @Override
    public SectionContainer getSections() {
        if (this.sections == null) {
            this.sections = new SectionContainer();
        }
        return this.sections;
    }

    public void setSections(Collection<ConfigSection> c) {
        this.getSections().addAll(c);
    }

    public @Nullable CustomizationSupplier<? extends CacheLoader<K, V>> getLoader() {
        return this.loader;
    }

    public void setLoader(@Nullable CustomizationSupplier<? extends CacheLoader<K, V>> v) {
        this.loader = v;
    }

    public @Nullable CustomizationSupplier<? extends AdvancedCacheLoader<K, V>> getAdvancedLoader() {
        return this.advancedLoader;
    }

    public void setAdvancedLoader(@Nullable CustomizationSupplier<? extends AdvancedCacheLoader<K, V>> v) {
        this.advancedLoader = v;
    }

    public @Nullable CustomizationSupplier<? extends AsyncCacheLoader<K, V>> getAsyncLoader() {
        return this.asyncLoader;
    }

    public void setAsyncLoader(@Nullable CustomizationSupplier<? extends AsyncCacheLoader<K, V>> v) {
        this.asyncLoader = v;
    }

    public int getLoaderThreadCount() {
        return this.loaderThreadCount;
    }

    public void setLoaderThreadCount(int v) {
        this.loaderThreadCount = v;
    }

    public @Nullable CustomizationSupplier<? extends ExpiryPolicy<? super K, ? super V>> getExpiryPolicy() {
        return this.expiryPolicy;
    }

    public void setExpiryPolicy(@Nullable CustomizationSupplier<? extends ExpiryPolicy<? super K, ? super V>> v) {
        this.expiryPolicy = v;
    }

    public @Nullable CustomizationSupplier<? extends CacheWriter<K, V>> getWriter() {
        return this.writer;
    }

    public void setWriter(@Nullable CustomizationSupplier<? extends CacheWriter<K, V>> v) {
        this.writer = v;
    }

    public boolean isStoreByReference() {
        return this.storeByReference;
    }

    public void setStoreByReference(boolean v) {
        this.storeByReference = v;
    }

    public @Nullable CustomizationSupplier<? extends ExceptionPropagator<? super K, ? super V>> getExceptionPropagator() {
        return this.exceptionPropagator;
    }

    public void setExceptionPropagator(@Nullable CustomizationSupplier<? extends ExceptionPropagator<? super K, ? super V>> v) {
        this.exceptionPropagator = v;
    }

    public @NonNull Collection<CustomizationSupplier<CacheEntryOperationListener<K, V>>> getListeners() {
        if (this.listeners == null) {
            this.listeners = new ArrayList<CustomizationSupplier<CacheEntryOperationListener<K, V>>>();
        }
        return this.listeners;
    }

    public boolean hasListeners() {
        return this.listeners != null && !this.listeners.isEmpty();
    }

    public void setListeners(Collection<CustomizationSupplier<CacheEntryOperationListener<K, V>>> c) {
        this.getListeners().addAll(c);
    }

    public @NonNull Collection<CustomizationSupplier<CacheEntryOperationListener<K, V>>> getAsyncListeners() {
        if (this.asyncListeners == null) {
            this.asyncListeners = new ArrayList<CustomizationSupplier<CacheEntryOperationListener<K, V>>>();
        }
        return this.asyncListeners;
    }

    public boolean hasAsyncListeners() {
        return this.asyncListeners != null && !this.asyncListeners.isEmpty();
    }

    public void setAsyncListeners(Collection<CustomizationSupplier<CacheEntryOperationListener<K, V>>> c) {
        this.getAsyncListeners().addAll(c);
    }

    public @NonNull Collection<CustomizationSupplier<? extends CacheLifecycleListener>> getLifecycleListeners() {
        if (this.lifecycleListeners == null) {
            this.lifecycleListeners = new ArrayList<CustomizationSupplier<CacheLifecycleListener>>();
        }
        return this.lifecycleListeners;
    }

    public boolean hasLifecycleListeners() {
        return this.lifecycleListeners != null && !this.lifecycleListeners.isEmpty();
    }

    public void setLifecycleListeners(@NonNull Collection<CustomizationSupplier<? extends CacheLifecycleListener>> c) {
        this.getLifecycleListeners().addAll(c);
    }

    public @NonNull Set<Feature> getFeatures() {
        if (this.features == null) {
            this.features = new HashSet<Feature>();
        }
        return this.features;
    }

    public boolean hasFeatures() {
        return this.features != null && !this.features.isEmpty();
    }

    public void setFeatures(@NonNull Set<? extends Feature> v) {
        this.getFeatures().addAll(v);
    }

    public @Nullable CustomizationSupplier<? extends ResiliencePolicy<? super K, ? super V>> getResiliencePolicy() {
        return this.resiliencePolicy;
    }

    public void setResiliencePolicy(@Nullable CustomizationSupplier<? extends ResiliencePolicy<? super K, ? super V>> v) {
        this.resiliencePolicy = v;
    }

    public boolean isStrictEviction() {
        return this.strictEviction;
    }

    public void setStrictEviction(boolean v) {
        this.strictEviction = v;
    }

    public boolean isPermitNullValues() {
        return this.permitNullValues;
    }

    public void setPermitNullValues(boolean v) {
        this.permitNullValues = v;
    }

    public boolean isDisableStatistics() {
        return this.disableStatistics;
    }

    public void setDisableStatistics(boolean v) {
        this.disableStatistics = v;
    }

    public @Nullable CustomizationSupplier<? extends Executor> getLoaderExecutor() {
        return this.loaderExecutor;
    }

    public void setLoaderExecutor(@Nullable CustomizationSupplier<? extends Executor> v) {
        this.loaderExecutor = v;
    }

    public boolean isRecordModificationTime() {
        return this.recordModificationTime;
    }

    public void setRecordModificationTime(boolean v) {
        this.recordModificationTime = v;
    }

    public @Nullable CustomizationSupplier<? extends Executor> getRefreshExecutor() {
        return this.refreshExecutor;
    }

    public void setRefreshExecutor(@Nullable CustomizationSupplier<? extends Executor> v) {
        this.refreshExecutor = v;
    }

    public @Nullable CustomizationSupplier<? extends Executor> getExecutor() {
        return this.executor;
    }

    public void setExecutor(@Nullable CustomizationSupplier<? extends Executor> v) {
        this.executor = v;
    }

    public @Nullable CustomizationSupplier<? extends Executor> getAsyncListenerExecutor() {
        return this.asyncListenerExecutor;
    }

    public void setAsyncListenerExecutor(@Nullable CustomizationSupplier<? extends Executor> v) {
        this.asyncListenerExecutor = v;
    }

    public @Nullable CustomizationSupplier<? extends Weigher<K, V>> getWeigher() {
        return this.weigher;
    }

    public void setWeigher(@Nullable CustomizationSupplier<? extends Weigher<K, V>> v) {
        this.weigher = v;
    }

    public boolean isBoostConcurrency() {
        return this.boostConcurrency;
    }

    public void setBoostConcurrency(boolean v) {
        this.boostConcurrency = v;
    }

    public boolean isDisableMonitoring() {
        return this.disableMonitoring;
    }

    public void setDisableMonitoring(boolean disableMonitoring) {
        this.disableMonitoring = disableMonitoring;
    }

    public @Nullable CacheWrapper getTraceCacheWrapper() {
        return this.traceCacheWrapper;
    }

    public void setTraceCacheWrapper(@Nullable CacheWrapper traceCacheWrapper) {
        this.traceCacheWrapper = traceCacheWrapper;
    }

    public @Nullable CacheWrapper getCacheWrapper() {
        return this.cacheWrapper;
    }

    public void setCacheWrapper(@Nullable CacheWrapper cacheWrapper) {
        this.cacheWrapper = cacheWrapper;
    }

    private @Nullable Duration durationCheckAndSanitize(@Nullable Duration v) {
        if (v == null) {
            return null;
        }
        if (v.isNegative()) {
            throw new IllegalArgumentException("Duration must be positive");
        }
        if (EXPIRY_ETERNAL.compareTo(v) <= 0) {
            v = EXPIRY_ETERNAL;
        }
        return v;
    }

    @Override
    public Cache2kBuilder<K, V> builder() {
        return Cache2kBuilder.of(this);
    }
}

