/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.config;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.cache2k.config.CacheTypeCapture;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface CacheType<T> {
    public static final String DESCRIPTOR_TO_STRING_PREFIX = "CacheType:";

    public static <T> CacheType<T> of(Class<T> t) {
        return CacheType.of(t);
    }

    public static CacheType<?> of(Type t) {
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            Class c = (Class)pt.getRawType();
            CacheType[] ta = new CacheType[pt.getActualTypeArguments().length];
            for (int i = 0; i < ta.length; ++i) {
                ta[i] = CacheType.of(pt.getActualTypeArguments()[i]);
            }
            return new CacheTypeCapture.OfGeneric(c, ta);
        }
        if (t instanceof GenericArrayType) {
            GenericArrayType gat = (GenericArrayType)t;
            return new CacheTypeCapture.OfArray(CacheType.of(gat.getGenericComponentType()));
        }
        if (!(t instanceof Class)) {
            throw new IllegalArgumentException("The run time type is not available, got: " + t);
        }
        Class c = (Class)t;
        if (c.isArray()) {
            return new CacheTypeCapture.OfArray(CacheType.of(c.getComponentType()));
        }
        return new CacheTypeCapture.OfClass(c);
    }

    public @Nullable Class<T> getType();

    public boolean hasTypeArguments();

    public boolean isArray();

    public @Nullable CacheType<?> getComponentType();

    public @Nullable CacheType<?>[] getTypeArguments();

    public String getTypeName();
}

