/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.config;

import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import org.cache2k.config.CacheType;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CacheTypeCapture<T>
implements CacheType<T> {
    private final CacheType<T> descriptor = CacheType.of(((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0]);

    protected CacheTypeCapture() {
    }

    @Override
    public @Nullable CacheType<?> getComponentType() {
        return this.descriptor.getComponentType();
    }

    @Override
    public @Nullable Class<T> getType() {
        return this.descriptor.getType();
    }

    @Override
    public @Nullable CacheType<?>[] getTypeArguments() {
        return this.descriptor.getTypeArguments();
    }

    @Override
    public String getTypeName() {
        return this.descriptor.getTypeName();
    }

    @Override
    public boolean hasTypeArguments() {
        return this.descriptor.hasTypeArguments();
    }

    @Override
    public boolean isArray() {
        return this.descriptor.isArray();
    }

    public boolean equals(Object o) {
        return this.descriptor.equals(o);
    }

    public int hashCode() {
        return this.descriptor.hashCode();
    }

    public String toString() {
        return this.descriptor.toString();
    }

    static String arrayToString(CacheType<?>[] a) {
        if (a.length < 1) {
            throw new IllegalArgumentException();
        }
        StringBuilder sb = new StringBuilder();
        int l = a.length - 1;
        int i = 0;
        while (true) {
            sb.append(a[i].getTypeName());
            if (i == l) {
                return sb.toString();
            }
            sb.append(',');
            ++i;
        }
    }

    public static class OfGeneric<T>
    extends BaseType<T> {
        private final CacheType<?>[] typeArguments;
        private final Class<T> type;

        public OfGeneric(Class<T> type, CacheType<?>[] typeArguments) {
            this.typeArguments = typeArguments;
            this.type = type;
        }

        @Override
        public Class<T> getType() {
            return this.type;
        }

        @Override
        public boolean hasTypeArguments() {
            return true;
        }

        @Override
        public CacheType<?>[] getTypeArguments() {
            return this.typeArguments;
        }

        @Override
        public String getTypeName() {
            return OfClass.shortenName(this.type.getCanonicalName()) + "<" + CacheTypeCapture.arrayToString(this.typeArguments) + '>';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OfGeneric that = (OfGeneric)o;
            return Arrays.equals(this.typeArguments, that.typeArguments) && this.type.equals(that.type);
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.typeArguments);
            result = 31 * result + this.type.hashCode();
            return result;
        }
    }

    public static class OfArray
    extends BaseType<Void> {
        private final CacheType<?> componentType;

        public OfArray(CacheType<?> componentType) {
            this.componentType = componentType;
        }

        @Override
        public boolean isArray() {
            return true;
        }

        @Override
        public CacheType<?> getComponentType() {
            return this.componentType;
        }

        private static int countDimensions(CacheType<?> td) {
            int cnt = 0;
            while (td.isArray()) {
                td = td.getComponentType();
                ++cnt;
            }
            return cnt;
        }

        static Class<?> finalPrimitiveType(CacheType<?> td) {
            while (td.isArray()) {
                td = td.getComponentType();
            }
            return td.getType();
        }

        @Override
        public String getTypeName() {
            StringBuilder sb = new StringBuilder();
            int dimensions = OfArray.countDimensions(this);
            if (dimensions > 1) {
                sb.append(OfArray.finalPrimitiveType(this));
            } else {
                sb.append(this.getComponentType().getTypeName());
            }
            for (int i = 0; i < dimensions; ++i) {
                sb.append("[]");
            }
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OfArray arrayType = (OfArray)o;
            return this.componentType.equals(arrayType.componentType);
        }

        public int hashCode() {
            return this.componentType.hashCode();
        }
    }

    public static class OfClass<T>
    extends BaseType<T> {
        private final Class<T> type;

        public OfClass(Class<T> type) {
            if (type.isArray()) {
                throw new IllegalArgumentException("array is not a regular class");
            }
            this.type = type;
        }

        @Override
        public Class<T> getType() {
            return this.type;
        }

        static String shortenName(String s) {
            String langPrefix = "java.lang.";
            if (s.startsWith("java.lang.")) {
                return s.substring("java.lang.".length());
            }
            return s;
        }

        @Override
        public String getTypeName() {
            return OfClass.shortenName(this.type.getCanonicalName());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OfClass classType = (OfClass)o;
            return this.type.equals(classType.type);
        }

        public int hashCode() {
            return this.type.hashCode();
        }
    }

    private static abstract class BaseType<@Nullable T>
    implements CacheType<T> {
        private BaseType() {
        }

        @Override
        public @Nullable CacheType<?> getComponentType() {
            return null;
        }

        @Override
        public @Nullable Class<T> getType() {
            return null;
        }

        @Override
        public @Nullable CacheType<?>[] getTypeArguments() {
            return null;
        }

        @Override
        public boolean hasTypeArguments() {
            return false;
        }

        @Override
        public boolean isArray() {
            return false;
        }

        public final String toString() {
            return "CacheType:" + this.getTypeName();
        }
    }
}

