/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.config;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.cache2k.config.ConfigSection;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SectionContainer
extends AbstractCollection<ConfigSection>
implements Collection<ConfigSection> {
    private final Map<Class<? extends ConfigSection>, ConfigSection> class2section = new HashMap<Class<? extends ConfigSection>, ConfigSection>();

    @Override
    public boolean add(ConfigSection section) {
        if (this.getSection(section.getClass()) != null) {
            throw new IllegalArgumentException("Section of same type already inserted: " + section.getClass().getName());
        }
        this.class2section.put(section.getClass(), section);
        return true;
    }

    public <T extends ConfigSection> T getSection(Class<T> sectionType, T defaultFallback) {
        ConfigSection section = this.class2section.get(sectionType);
        return (T)(section != null ? (ConfigSection)sectionType.cast(section) : defaultFallback);
    }

    public <T extends ConfigSection> @Nullable T getSection(Class<T> sectionType) {
        ConfigSection section = this.class2section.get(sectionType);
        return (T)((ConfigSection)sectionType.cast(section));
    }

    @Override
    public Iterator<ConfigSection> iterator() {
        return this.class2section.values().iterator();
    }

    @Override
    public int size() {
        return this.class2section.size();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + this.class2section.values().toString();
    }
}

