/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.config;

import java.util.Iterator;
import java.util.Set;
import org.cache2k.Cache2kBuilder;
import org.cache2k.config.Cache2kConfig;
import org.cache2k.config.CacheBuildContext;
import org.cache2k.config.Feature;
import org.cache2k.config.SingleFeature;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class ToggleFeature
implements SingleFeature {
    private boolean enabled = true;

    public static <T extends ToggleFeature> T enable(Cache2kBuilder<?, ?> builder, Class<T> featureType) {
        try {
            ToggleFeature feature = (ToggleFeature)featureType.getConstructor(new Class[0]).newInstance(new Object[0]);
            Set<Feature> features = ((Cache2kConfig)builder.config()).getFeatures();
            features.remove(feature);
            features.add(feature);
            return (T)feature;
        }
        catch (Exception e) {
            throw new LinkageError("Instantiation failed", e);
        }
    }

    public static void disable(Cache2kBuilder<?, ?> builder, Class<? extends ToggleFeature> featureType) {
        Iterator<Feature> it = ((Cache2kConfig)builder.config()).getFeatures().iterator();
        while (it.hasNext()) {
            if (!it.next().getClass().equals(featureType)) continue;
            it.remove();
        }
    }

    public static <T extends ToggleFeature> @Nullable T extract(Cache2kBuilder<?, ?> builder, Class<T> featureType) {
        for (Feature feature : ((Cache2kConfig)builder.config()).getFeatures()) {
            if (!feature.getClass().equals(featureType)) continue;
            return (T)((ToggleFeature)feature);
        }
        return null;
    }

    public static boolean isEnabled(Cache2kBuilder<?, ?> builder, Class<? extends ToggleFeature> featureType) {
        ToggleFeature f = ToggleFeature.extract(builder, featureType);
        return f != null ? f.isEnabled() : false;
    }

    @Override
    public final void enlist(CacheBuildContext<?, ?> ctx) {
        if (this.enabled) {
            this.doEnlist(ctx);
        }
    }

    protected abstract void doEnlist(CacheBuildContext<?, ?> var1);

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean v) {
        this.enabled = v;
    }

    public final void setEnable(boolean v) {
        this.enabled = v;
    }

    public final boolean equals(@Nullable Object o) {
        if (o == null) {
            return false;
        }
        return this.getClass().equals(o.getClass());
    }

    public final int hashCode() {
        return this.getClass().hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + '{' + (this.enabled ? "enabled" : "disabled") + '}';
    }
}

