/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.config;

import org.cache2k.annotation.Nullable;
import org.cache2k.config.CacheBuildContext;
import org.cache2k.config.ConfigBuilder;
import org.cache2k.config.CustomizationSupplier;
import org.cache2k.config.ValidatingConfigBean;

public final class CustomizationSupplierByClassName<T>
implements CustomizationSupplier<T>,
ValidatingConfigBean {
    @Nullable
    private String className;

    public CustomizationSupplierByClassName() {
    }

    public CustomizationSupplierByClassName(String className) {
        this.checkNull(className);
        this.className = className;
    }

    @Nullable
    public String getClassName() {
        return this.className;
    }

    public void setClassName(String v) {
        this.className = v;
    }

    private String checkNull(@Nullable String className) {
        if (className == null) {
            throw new IllegalArgumentException("className not set");
        }
        return className;
    }

    @Override
    public void validate() {
        this.checkNull(this.className);
    }

    public ConfigBuilder builder() {
        throw new UnsupportedOperationException();
    }

    @Override
    public T supply(CacheBuildContext<?, ?> ctx) {
        try {
            return (T)ctx.getCacheManager().getClassLoader().loadClass(this.checkNull(this.className)).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new LinkageError("error loading customization class", e);
        }
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CustomizationSupplierByClassName)) {
            return false;
        }
        CustomizationSupplierByClassName that = (CustomizationSupplierByClassName)other;
        if (this.className == null) {
            return that.className == null;
        }
        return this.className.equals(that.className);
    }

    public int hashCode() {
        if (this.className != null) {
            return this.className.hashCode();
        }
        return 0;
    }
}

