/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.io;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import org.cache2k.Cache;
import org.cache2k.DataAware;
import org.cache2k.io.AsyncCacheLoader;

@FunctionalInterface
public interface AsyncBulkCacheLoader<K, V>
extends AsyncCacheLoader<K, V> {
    public void loadAll(Set<K> var1, BulkLoadContext<K, V> var2, BulkCallback<K, V> var3) throws Exception;

    @Override
    default public void load(final K key, final AsyncCacheLoader.Context<K, V> context, final AsyncCacheLoader.Callback<V> callback) throws Exception {
        final Set<K> keySet = Collections.singleton(key);
        final BulkCallback bulkCallback = new BulkCallback<K, V>(){

            @Override
            public void onLoadSuccess(Map<? extends K, ? extends V> data) {
                if (data.isEmpty()) {
                    return;
                }
                Map.Entry entry = data.entrySet().iterator().next();
                this.onLoadSuccess(entry.getKey(), entry.getValue());
            }

            @Override
            public void onLoadSuccess(K key, V value) {
                Objects.requireNonNull(key);
                callback.onLoadSuccess(value);
            }

            @Override
            public void onLoadFailure(Throwable exception) {
                callback.onLoadFailure(exception);
            }
        };
        BulkLoadContext bulkLoadContext = new BulkLoadContext<K, V>(){

            @Override
            public Cache<K, V> getCache() {
                return context.getCache();
            }

            @Override
            public Map<K, AsyncCacheLoader.Context<K, V>> getContextMap() {
                return Collections.singletonMap(key, context);
            }

            @Override
            public long getStartTime() {
                return context.getStartTime();
            }

            @Override
            public Set<K> getKeys() {
                return keySet;
            }

            @Override
            public Executor getExecutor() {
                return context.getExecutor();
            }

            @Override
            public Executor getLoaderExecutor() {
                return context.getLoaderExecutor();
            }

            @Override
            public BulkCallback<K, V> getCallback() {
                return bulkCallback;
            }
        };
        this.loadAll(keySet, bulkLoadContext, bulkCallback);
    }

    public static interface BulkCallback<K, V>
    extends DataAware<K, V> {
        public void onLoadSuccess(Map<? extends K, ? extends V> var1);

        public void onLoadSuccess(K var1, V var2);

        public void onLoadFailure(Throwable var1);
    }

    public static interface BulkLoadContext<K, V>
    extends DataAware<K, V> {
        public Cache<K, V> getCache();

        public Map<K, AsyncCacheLoader.Context<K, V>> getContextMap();

        public long getStartTime();

        public Set<K> getKeys();

        public Executor getExecutor();

        public Executor getLoaderExecutor();

        public BulkCallback<K, V> getCallback();
    }
}

