/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import org.cache2k.Cache;
import org.cache2k.CacheManager;
import org.cache2k.DataAware;
import org.cache2k.annotation.Nullable;
import org.cache2k.config.Cache2kConfig;
import org.cache2k.config.CacheType;
import org.cache2k.config.ConfigBean;
import org.cache2k.config.ConfigBuilder;
import org.cache2k.config.ConfigSection;
import org.cache2k.config.CustomizationReferenceSupplier;
import org.cache2k.config.CustomizationSupplier;
import org.cache2k.config.SectionBuilder;
import org.cache2k.config.ToggleFeature;
import org.cache2k.config.WithSection;
import org.cache2k.event.CacheClosedListener;
import org.cache2k.event.CacheEntryOperationListener;
import org.cache2k.expiry.ExpiryPolicy;
import org.cache2k.io.AdvancedCacheLoader;
import org.cache2k.io.AsyncBulkCacheLoader;
import org.cache2k.io.AsyncCacheLoader;
import org.cache2k.io.BulkCacheLoader;
import org.cache2k.io.CacheLoader;
import org.cache2k.io.CacheWriter;
import org.cache2k.io.ExceptionPropagator;
import org.cache2k.io.ResiliencePolicy;
import org.cache2k.operation.Scheduler;
import org.cache2k.operation.TimeReference;
import org.cache2k.operation.Weigher;

public class Cache2kBuilder<K, V>
implements ConfigBuilder<Cache2kBuilder<K, V>, Cache2kConfig<K, V>>,
DataAware<K, V> {
    private static final String MSG_NO_TYPES = "Use Cache2kBuilder.forUnknownTypes(), to construct a builder with no key and value types";
    @Nullable
    private CacheType<K> keyType;
    @Nullable
    private CacheType<V> valueType;
    @Nullable
    private Cache2kConfig<K, V> config = null;
    @Nullable
    private CacheManager manager = null;

    public static Cache2kBuilder<Object, Object> forUnknownTypes() {
        return new Cache2kBuilder<Object, Object>(null, null);
    }

    public static <K, V> Cache2kBuilder<K, V> of(Class<K> keyType, Class<V> valueType) {
        return new Cache2kBuilder<K, V>(CacheType.of(keyType), CacheType.of(valueType));
    }

    public static <K, V> Cache2kBuilder<K, V> of(Cache2kConfig<K, V> c) {
        Cache2kBuilder<K, V> cb = new Cache2kBuilder<K, V>(c);
        return cb;
    }

    private Cache2kBuilder(Cache2kConfig<K, V> cfg) {
        this.withConfig(cfg);
    }

    protected Cache2kBuilder() {
        Type t = this.getClass().getGenericSuperclass();
        if (!(t instanceof ParameterizedType)) {
            throw new IllegalArgumentException(MSG_NO_TYPES);
        }
        Type[] types = ((ParameterizedType)t).getActualTypeArguments();
        this.keyType = CacheType.of(types[0]);
        this.valueType = CacheType.of(types[1]);
        if (Object.class.equals(this.keyType.getType()) && Object.class.equals(this.valueType.getType())) {
            throw new IllegalArgumentException(MSG_NO_TYPES);
        }
    }

    private Cache2kBuilder(@Nullable CacheType<K> keyType, @Nullable CacheType<V> valueType) {
        this.keyType = keyType;
        this.valueType = valueType;
    }

    private void withConfig(Cache2kConfig<K, V> cfg) {
        this.config = cfg;
    }

    private Cache2kConfig<K, V> cfg() {
        if (this.config == null) {
            this.config = CacheManager.PROVIDER.getDefaultConfig(this.getManager());
            if (this.keyType != null) {
                this.config.setKeyType(this.keyType);
            }
            if (this.valueType != null) {
                this.config.setValueType(this.valueType);
            }
        }
        return this.config;
    }

    public final Cache2kBuilder<K, V> manager(CacheManager manager) {
        if (this.manager != null) {
            throw new IllegalStateException("manager() must be first operation on builder.");
        }
        this.manager = manager;
        return this;
    }

    public final <K2> Cache2kBuilder<K2, V> keyType(Class<K2> t) {
        Cache2kBuilder me = this;
        me.cfg().setKeyType(CacheType.of(t));
        return me;
    }

    public final <V2> Cache2kBuilder<K, V2> valueType(Class<V2> t) {
        Cache2kBuilder me = this;
        me.cfg().setValueType(CacheType.of(t));
        return me;
    }

    public final <K2> Cache2kBuilder<K2, V> keyType(CacheType<K2> t) {
        Cache2kBuilder me = this;
        me.cfg().setKeyType(t);
        return me;
    }

    public final <V2> Cache2kBuilder<K, V2> valueType(CacheType<V2> t) {
        Cache2kBuilder me = this;
        me.cfg().setValueType(t);
        return me;
    }

    public final Cache2kBuilder<K, V> name(String uniqueName, Class<?> clazz, String fieldName) {
        if (fieldName == null) {
            throw new NullPointerException();
        }
        if (uniqueName == null) {
            return this.name(clazz, fieldName);
        }
        this.cfg().setName(uniqueName + '~' + clazz.getName() + "." + fieldName);
        return this;
    }

    public final Cache2kBuilder<K, V> name(Class<?> clazz, String fieldName) {
        if (fieldName == null) {
            throw new NullPointerException();
        }
        this.cfg().setName(clazz.getName() + "." + fieldName);
        return this;
    }

    public final Cache2kBuilder<K, V> name(Class<?> clazz) {
        this.cfg().setName(clazz.getName());
        return this;
    }

    public final Cache2kBuilder<K, V> name(String v) {
        this.cfg().setName(v);
        return this;
    }

    public final Cache2kBuilder<K, V> keepDataAfterExpired(boolean v) {
        this.cfg().setKeepDataAfterExpired(v);
        return this;
    }

    public final Cache2kBuilder<K, V> entryCapacity(long v) {
        this.cfg().setEntryCapacity(v);
        return this;
    }

    public final Cache2kBuilder<K, V> eternal(boolean v) {
        this.cfg().setEternal(v);
        return this;
    }

    public final Cache2kBuilder<K, V> expireAfterWrite(long v, TimeUnit u) {
        this.cfg().setExpireAfterWrite(Cache2kBuilder.toDuration(v, u));
        return this;
    }

    public final Cache2kBuilder<K, V> timerLag(long v, TimeUnit u) {
        this.cfg().setTimerLag(Cache2kBuilder.toDuration(v, u));
        return this;
    }

    public final Cache2kBuilder<K, V> idleScanTime(long v, TimeUnit u) {
        this.cfg().setIdleScanTime(Cache2kBuilder.toDuration(v, u));
        return this;
    }

    private static Duration toDuration(long v, TimeUnit u) {
        return Duration.ofMillis(u.toMillis(v));
    }

    public final Cache2kBuilder<K, V> exceptionPropagator(ExceptionPropagator<? super K, ? super V> ep) {
        this.cfg().setExceptionPropagator(Cache2kBuilder.wrapCustomizationInstance(ep));
        return this;
    }

    private static <T> CustomizationReferenceSupplier<T> wrapCustomizationInstance(T obj) {
        return new CustomizationReferenceSupplier<T>(obj);
    }

    public final Cache2kBuilder<K, V> loader(CacheLoader<K, V> l) {
        this.cfg().setLoader(Cache2kBuilder.wrapCustomizationInstance(l));
        return this;
    }

    public final Cache2kBuilder<K, V> loader(AdvancedCacheLoader<K, V> l) {
        this.cfg().setAdvancedLoader(Cache2kBuilder.wrapCustomizationInstance(l));
        return this;
    }

    public final Cache2kBuilder<K, V> loader(AsyncCacheLoader<K, V> l) {
        this.cfg().setAsyncLoader(Cache2kBuilder.wrapCustomizationInstance(l));
        return this;
    }

    public final Cache2kBuilder<K, V> bulkLoader(AsyncBulkCacheLoader<K, V> l) {
        this.loader(l);
        return this;
    }

    public final Cache2kBuilder<K, V> bulkLoader(BulkCacheLoader<K, V> l) {
        this.loader(l);
        return this;
    }

    public final Cache2kBuilder<K, V> writer(CacheWriter<K, V> w) {
        this.cfg().setWriter(Cache2kBuilder.wrapCustomizationInstance(w));
        return this;
    }

    public final Cache2kBuilder<K, V> addCacheClosedListener(CacheClosedListener listener) {
        this.cfg().getLifecycleListeners().add(Cache2kBuilder.wrapCustomizationInstance(listener));
        return this;
    }

    public final Cache2kBuilder<K, V> addListener(CacheEntryOperationListener<K, V> listener) {
        this.cfg().getListeners().add(Cache2kBuilder.wrapCustomizationInstance(listener));
        return this;
    }

    public final Cache2kBuilder<K, V> addAsyncListener(CacheEntryOperationListener<K, V> listener) {
        this.cfg().getAsyncListeners().add(Cache2kBuilder.wrapCustomizationInstance(listener));
        return this;
    }

    public final Cache2kBuilder<K, V> expiryPolicy(ExpiryPolicy<? super K, ? super V> c) {
        this.cfg().setExpiryPolicy(Cache2kBuilder.wrapCustomizationInstance(c));
        return this;
    }

    public final Cache2kBuilder<K, V> refreshAhead(boolean f) {
        this.cfg().setRefreshAhead(f);
        return this;
    }

    public final Cache2kBuilder<K, V> sharpExpiry(boolean f) {
        this.cfg().setSharpExpiry(f);
        return this;
    }

    public final Cache2kBuilder<K, V> loaderThreadCount(int v) {
        this.cfg().setLoaderThreadCount(v);
        return this;
    }

    public final Cache2kBuilder<K, V> storeByReference(boolean v) {
        this.cfg().setStoreByReference(v);
        return this;
    }

    public final Cache2kBuilder<K, V> resiliencePolicy(ResiliencePolicy<? super K, ? super V> v) {
        this.cfg().setResiliencePolicy(Cache2kBuilder.wrapCustomizationInstance(v));
        return this;
    }

    public final Cache2kBuilder<K, V> resiliencePolicy(CustomizationSupplier<? extends ResiliencePolicy<? super K, ? super V>> v) {
        this.cfg().setResiliencePolicy(v);
        return this;
    }

    public final Cache2kBuilder<K, V> strictEviction(boolean flag) {
        this.cfg().setStrictEviction(flag);
        return this;
    }

    public final Cache2kBuilder<K, V> permitNullValues(boolean flag) {
        this.cfg().setPermitNullValues(flag);
        return this;
    }

    public final Cache2kBuilder<K, V> disableStatistics(boolean flag) {
        this.cfg().setDisableStatistics(flag);
        return this;
    }

    public final Cache2kBuilder<K, V> recordModificationTime(boolean flag) {
        this.cfg().setRecordModificationTime(flag);
        return this;
    }

    public final Cache2kBuilder<K, V> boostConcurrency(boolean f) {
        this.cfg().setBoostConcurrency(f);
        return this;
    }

    public final Cache2kBuilder<K, V> disableMonitoring(boolean f) {
        this.cfg().setDisableMonitoring(f);
        return this;
    }

    public final Cache2kBuilder<K, V> loaderExecutor(Executor v) {
        this.cfg().setLoaderExecutor(new CustomizationReferenceSupplier<Executor>(v));
        return this;
    }

    public final Cache2kBuilder<K, V> refreshExecutor(Executor v) {
        this.cfg().setRefreshExecutor(new CustomizationReferenceSupplier<Executor>(v));
        return this;
    }

    public final Cache2kBuilder<K, V> executor(Executor v) {
        this.cfg().setExecutor(new CustomizationReferenceSupplier<Executor>(v));
        return this;
    }

    public final Cache2kBuilder<K, V> scheduler(Scheduler v) {
        this.cfg().setScheduler(new CustomizationReferenceSupplier<Scheduler>(v));
        return this;
    }

    public final Cache2kBuilder<K, V> timeReference(TimeReference v) {
        this.cfg().setTimeReference(new CustomizationReferenceSupplier<TimeReference>(v));
        return this;
    }

    public final Cache2kBuilder<K, V> asyncListenerExecutor(Executor v) {
        this.cfg().setAsyncListenerExecutor(new CustomizationReferenceSupplier<Executor>(v));
        return this;
    }

    public final Cache2kBuilder<K, V> weigher(Weigher<K, V> v) {
        this.cfg().setWeigher(new CustomizationReferenceSupplier<Weigher<K, V>>(v));
        return this;
    }

    public final Cache2kBuilder<K, V> maximumWeight(long v) {
        this.cfg().setMaximumWeight(v);
        return this;
    }

    public final Cache2kBuilder<K, V> setup(Consumer<Cache2kBuilder<K, V>> consumer) {
        consumer.accept(this);
        return this;
    }

    public final Cache2kBuilder<K, V> enable(Class<? extends ToggleFeature> feature) {
        ToggleFeature.enable(this, feature);
        return this;
    }

    public final Cache2kBuilder<K, V> disable(Class<? extends ToggleFeature> feature) {
        ToggleFeature.disable(this, feature);
        return this;
    }

    public final <B extends SectionBuilder<B, CFG>, CFG extends ConfigSection<CFG, B>> Cache2kBuilder<K, V> with(Class<CFG> configSectionClass, Consumer<B> builderAction) {
        Object section = this.cfg().getSections().getSection(configSectionClass);
        if (section == null) {
            try {
                section = (ConfigSection)configSectionClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new Error("config bean needs working default constructor", e);
            }
            this.cfg().getSections().add((ConfigSection)section);
        }
        builderAction.accept(section.builder());
        return this;
    }

    public Cache2kBuilder<K, V> set(Consumer<Cache2kConfig<K, V>> configAction) {
        configAction.accept((Cache2kConfig<K, V>)this.config());
        return this;
    }

    public <B extends SectionBuilder<B, CFG>, CFG extends ConfigSection<CFG, B>, SUP extends WithSection<CFG, B> & CustomizationSupplier<?>> Cache2kBuilder<K, V> setupWith(Function<Cache2kBuilder<K, V>, SUP> setupAction, Consumer<B> builderAction) {
        this.with(((WithSection)setupAction.apply(this)).getConfigClass(), builderAction);
        return this;
    }

    public <B extends ConfigBuilder<B, CFG>, CFG extends ConfigBean<CFG, B>> Cache2kBuilder<K, V> setup(Function<Cache2kBuilder<K, V>, CFG> enabler, Consumer<B> builderAction) {
        builderAction.accept(((ConfigBean)enabler.apply(this)).builder());
        return this;
    }

    public <B extends ConfigBuilder<B, T>, T extends ToggleFeature> Cache2kBuilder<K, V> enable(Class<T> featureType, Consumer<B> builderAction) {
        T bean = ToggleFeature.enable(this, featureType);
        builderAction.accept(((ConfigBean)bean).builder());
        return this;
    }

    public <B extends SectionBuilder<B, CFG>, T extends ToggleFeature, CFG extends ConfigSection<CFG, B>> Cache2kBuilder<K, V> enableWith(Class<T> featureType, Consumer<B> builderAction) {
        T bean = ToggleFeature.enable(this, featureType);
        this.with(((WithSection)bean).getConfigClass(), builderAction);
        return this;
    }

    @Override
    public final Cache2kConfig<K, V> config() {
        return this.cfg();
    }

    public final CacheManager getManager() {
        if (this.manager == null) {
            this.manager = CacheManager.getInstance();
        }
        return this.manager;
    }

    public final Cache<K, V> build() {
        return CacheManager.PROVIDER.createCache(this.getManager(), this.cfg());
    }
}

