/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.at.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.cadixdev.at.AccessTransformSet;
import org.cadixdev.at.impl.AccessTransformSetMapper;
import org.cadixdev.at.impl.ClassAccessTransformSetImpl;
import org.cadixdev.lorenz.MappingSet;

public class AccessTransformSetImpl
implements AccessTransformSet {
    private final Map<String, AccessTransformSet.Class> classes = new HashMap<String, AccessTransformSet.Class>();

    @Override
    public Map<String, AccessTransformSet.Class> getClasses() {
        return Collections.unmodifiableMap(this.classes);
    }

    @Override
    public Optional<AccessTransformSet.Class> getClass(String name) {
        Objects.requireNonNull(name, "name");
        return Optional.ofNullable(this.classes.get(name.replace('.', '/')));
    }

    @Override
    public AccessTransformSet.Class getOrCreateClass(String name) {
        Objects.requireNonNull(name, "name");
        return this.classes.computeIfAbsent(name.replace('.', '/'), n -> new ClassAccessTransformSetImpl(this, (String)n));
    }

    @Override
    public Optional<AccessTransformSet.Class> removeClass(String name) {
        Objects.requireNonNull(name, "name");
        return Optional.ofNullable(this.classes.remove(name.replace('.', '/')));
    }

    @Override
    public AccessTransformSet remap(MappingSet mappings) {
        return AccessTransformSetMapper.remap(this, mappings);
    }

    @Override
    public void merge(AccessTransformSet other) {
        other.getClasses().forEach((name, classSet) -> this.getOrCreateClass((String)name).merge((AccessTransformSet.Class)classSet));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AccessTransformSetImpl)) {
            return false;
        }
        AccessTransformSetImpl that = (AccessTransformSetImpl)o;
        return this.classes.equals(that.classes);
    }

    public int hashCode() {
        return this.classes.hashCode();
    }

    public String toString() {
        return "AccessTransformSet{" + this.classes + '}';
    }
}

