/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.at.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.cadixdev.at.AccessTransform;
import org.cadixdev.at.AccessTransformSet;
import org.cadixdev.bombe.analysis.InheritanceProvider;
import org.cadixdev.bombe.type.signature.MethodSignature;

class ClassAccessTransformSetImpl
implements AccessTransformSet.Class {
    private final AccessTransformSet parent;
    private final String name;
    private AccessTransform classTransform = AccessTransform.EMPTY;
    private AccessTransform allFields = AccessTransform.EMPTY;
    private AccessTransform allMethods = AccessTransform.EMPTY;
    private final Map<String, AccessTransform> fields = new HashMap<String, AccessTransform>();
    private final Map<MethodSignature, AccessTransform> methods = new HashMap<MethodSignature, AccessTransform>();
    private boolean complete;

    ClassAccessTransformSetImpl(AccessTransformSet parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    @Override
    public AccessTransformSet getParent() {
        return this.parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public AccessTransform get() {
        return this.classTransform;
    }

    @Override
    public AccessTransform merge(AccessTransform transform) {
        this.classTransform = this.classTransform.merge(transform);
        return this.classTransform;
    }

    @Override
    public AccessTransform replace(AccessTransform transform) {
        this.classTransform = Objects.requireNonNull(transform, "transform");
        return this.classTransform;
    }

    @Override
    public AccessTransform allFields() {
        return this.allFields;
    }

    @Override
    public AccessTransform mergeAllFields(AccessTransform transform) {
        this.allFields = this.allFields.merge(transform);
        return this.allFields;
    }

    @Override
    public AccessTransform replaceAllFields(AccessTransform transform) {
        this.allFields = Objects.requireNonNull(transform, "transform");
        return this.allFields;
    }

    @Override
    public AccessTransform allMethods() {
        return this.allMethods;
    }

    @Override
    public AccessTransform mergeAllMethods(AccessTransform transform) {
        this.allMethods = this.allMethods.merge(transform);
        return this.allMethods;
    }

    @Override
    public AccessTransform replaceAllMethods(AccessTransform transform) {
        this.allMethods = Objects.requireNonNull(transform, "transform");
        return this.allMethods;
    }

    @Override
    public Map<String, AccessTransform> getFields() {
        return Collections.unmodifiableMap(this.fields);
    }

    @Override
    public AccessTransform getField(String name) {
        return this.fields.getOrDefault(Objects.requireNonNull(name, "name"), this.allFields);
    }

    @Override
    public AccessTransform mergeField(String name, AccessTransform transform) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(transform, "transform");
        if (transform.isEmpty()) {
            return this.fields.getOrDefault(name, AccessTransform.EMPTY);
        }
        return this.fields.merge(name, transform, AccessTransform::merge);
    }

    @Override
    public AccessTransform replaceField(String name, AccessTransform transform) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(transform, "transform");
        if (transform.isEmpty()) {
            return this.fields.remove(name);
        }
        return this.fields.put(name, transform);
    }

    @Override
    public Map<MethodSignature, AccessTransform> getMethods() {
        return Collections.unmodifiableMap(this.methods);
    }

    @Override
    public AccessTransform getMethod(MethodSignature signature) {
        return this.methods.getOrDefault(Objects.requireNonNull(signature, "signature"), this.allMethods);
    }

    @Override
    public AccessTransform mergeMethod(MethodSignature signature, AccessTransform transform) {
        Objects.requireNonNull(signature, "signature");
        Objects.requireNonNull(transform, "transform");
        if (transform.isEmpty()) {
            return this.methods.getOrDefault(signature, AccessTransform.EMPTY);
        }
        return this.methods.merge(signature, transform, AccessTransform::merge);
    }

    @Override
    public AccessTransform replaceMethod(MethodSignature signature, AccessTransform transform) {
        Objects.requireNonNull(signature, "signature");
        Objects.requireNonNull(transform, "transform");
        if (transform.isEmpty()) {
            return this.methods.remove(signature);
        }
        return this.methods.put(signature, transform);
    }

    @Override
    public void merge(AccessTransformSet.Class other) {
        Objects.requireNonNull(other, "other");
        this.merge(other.get());
        this.mergeAllFields(other.allFields());
        this.mergeAllMethods(other.allMethods());
        other.getFields().forEach(this::mergeField);
        other.getMethods().forEach(this::mergeMethod);
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void complete(InheritanceProvider provider, InheritanceProvider.ClassInfo info) {
        if (this.complete) {
            return;
        }
        for (InheritanceProvider.ClassInfo parent : info.provideParents(provider)) {
            AccessTransformSet.Class parentAts = this.getParent().getOrCreateClass(parent.getName());
            parentAts.complete(provider, parent);
            parentAts.getMethods().forEach((signature, transform) -> {
                if (info.overrides(signature, parent)) {
                    this.mergeMethod((MethodSignature)signature, (AccessTransform)transform);
                }
            });
        }
        this.complete = true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClassAccessTransformSetImpl)) {
            return false;
        }
        ClassAccessTransformSetImpl that = (ClassAccessTransformSetImpl)o;
        return this.classTransform.equals(that.classTransform) && this.allFields.equals(that.allFields) && this.allMethods.equals(that.allMethods) && this.fields.equals(that.fields) && this.methods.equals(that.methods);
    }

    public int hashCode() {
        return Objects.hash(this.classTransform, this.allFields, this.allMethods, this.fields, this.methods);
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", "AccessTransformSet.Class{", "}");
        if (!this.classTransform.isEmpty()) {
            joiner.add(this.classTransform.toString());
        }
        if (!this.allFields.isEmpty()) {
            joiner.add("allFields=" + this.allFields);
        }
        if (!this.allMethods.isEmpty()) {
            joiner.add("allMethods=" + this.allMethods);
        }
        if (!this.fields.isEmpty()) {
            joiner.add("fields=" + this.fields);
        }
        if (!this.methods.isEmpty()) {
            joiner.add("method=" + this.methods);
        }
        return joiner.toString();
    }
}

