/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.at.io.fml;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.function.BiConsumer;
import org.cadixdev.at.AccessChange;
import org.cadixdev.at.AccessTransform;
import org.cadixdev.at.AccessTransformSet;
import org.cadixdev.bombe.type.signature.MethodSignature;

final class FmlWriter {
    private static final char WILDCARD = '*';
    private static final String METHOD_WILDCARD = "*()";
    private final BufferedWriter writer;

    FmlWriter(BufferedWriter writer) {
        this.writer = writer;
    }

    void write(AccessTransformSet set) throws IOException {
        set.getClasses().forEach(FmlWriter.throwing((originalClassName, classSet) -> {
            String className = originalClassName.replace('/', '.');
            this.writeClass(className, classSet.get());
            this.writeField(className, null, classSet.allFields());
            classSet.getFields().forEach(FmlWriter.throwing((name, transform) -> this.writeField(className, (String)name, (AccessTransform)transform)));
            this.writeMethod(className, null, classSet.allMethods());
            classSet.getMethods().forEach(FmlWriter.throwing((name, transform) -> this.writeMethod(className, (MethodSignature)name, (AccessTransform)transform)));
        }));
    }

    private static String getAccessModifier(AccessChange change) {
        switch (change) {
            case PUBLIC: {
                return "public";
            }
            case PROTECTED: {
                return "protected";
            }
            case PACKAGE_PRIVATE: {
                return "default";
            }
            case PRIVATE: {
                return "private";
            }
        }
        throw new AssertionError((Object)change);
    }

    private void writeAccessTransform(String className, AccessTransform transform) throws IOException {
        if (transform.getAccess() != AccessChange.NONE) {
            this.writer.write(FmlWriter.getAccessModifier(transform.getAccess()));
        }
        switch (transform.getFinal()) {
            case NONE: {
                break;
            }
            case REMOVE: {
                this.writer.write("-f");
                break;
            }
            case ADD: {
                this.writer.write("+f");
                break;
            }
            default: {
                throw new AssertionError((Object)transform.getFinal());
            }
        }
        this.writer.write(32);
        this.writer.write(className);
    }

    private void writeClass(String className, AccessTransform transform) throws IOException {
        if (transform.isEmpty()) {
            return;
        }
        this.writeAccessTransform(className, transform);
        this.writer.newLine();
    }

    private void writeField(String className, String name, AccessTransform transform) throws IOException {
        if (transform.isEmpty()) {
            return;
        }
        this.writeAccessTransform(className, transform);
        this.writer.write(32);
        if (name != null) {
            this.writer.write(name);
        } else {
            this.writer.write(42);
        }
        this.writer.newLine();
    }

    private void writeMethod(String className, MethodSignature signature, AccessTransform transform) throws IOException {
        if (transform.isEmpty()) {
            return;
        }
        this.writeAccessTransform(className, transform);
        this.writer.write(32);
        if (signature != null) {
            this.writer.write(signature.getName());
            this.writer.write(signature.getDescriptor().toString());
        } else {
            this.writer.write(METHOD_WILDCARD);
        }
        this.writer.newLine();
    }

    private static <T, U> BiConsumer<T, U> throwing(ThrowingBiConsumer<T, U> consumer) {
        return consumer;
    }

    private static interface ThrowingBiConsumer<T, U>
    extends BiConsumer<T, U> {
        public void throwingAccept(T var1, U var2) throws IOException;

        @Override
        default public void accept(T t, U u) {
            try {
                this.throwingAccept(t, u);
            }
            catch (IOException e) {
                ThrowingBiConsumer.rethrow(e);
            }
        }

        public static <E extends Exception> void rethrow(Exception e) throws E {
            throw e;
        }
    }
}

