/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.atlas.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public final class JarRepacker {
    private JarRepacker() {
    }

    public static void verifyJarManifest(Path outputJar) throws IOException {
        boolean maybeNeedsRepack;
        try (JarInputStream input = new JarInputStream(Files.newInputStream(outputJar, new OpenOption[0]));){
            maybeNeedsRepack = input.getManifest() == null;
        }
        if (maybeNeedsRepack) {
            boolean hasManifest;
            try (JarFile outputJarFile = new JarFile(outputJar.toFile());){
                hasManifest = outputJarFile.getManifest() != null;
            }
            if (hasManifest) {
                JarRepacker.fixJarManifest(outputJar);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fixJarManifest(Path outputJar) throws IOException {
        byte[] buffer = new byte[8192];
        Path tempOut = Files.createTempFile(outputJar.getParent(), "atlas", "jar", new FileAttribute[0]);
        try {
            try (JarOutputStream out = new JarOutputStream(Files.newOutputStream(tempOut, new OpenOption[0]));
                 JarFile jarFile = new JarFile(outputJar.toFile());){
                boolean skipManifest = JarRepacker.copyManifest(jarFile, out);
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry currentEntry = entries.nextElement();
                    String name = currentEntry.getName();
                    if (skipManifest && (name.equals("META-INF/") || name.equalsIgnoreCase("META-INF/MANIFEST.MF"))) continue;
                    out.putNextEntry(new ZipEntry(name));
                    try {
                        InputStream input = jarFile.getInputStream(currentEntry);
                        try {
                            JarRepacker.copy(input, out, buffer);
                        }
                        finally {
                            if (input == null) continue;
                            input.close();
                        }
                    }
                    finally {
                        out.closeEntry();
                    }
                }
            }
            Files.move(tempOut, outputJar, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        finally {
            Files.deleteIfExists(tempOut);
        }
    }

    private static boolean copyManifest(JarFile jarFile, JarOutputStream out) throws IOException {
        Manifest manifest = jarFile.getManifest();
        if (manifest == null) {
            return false;
        }
        out.putNextEntry(new ZipEntry("META-INF/"));
        out.closeEntry();
        out.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
        manifest.write(out);
        out.closeEntry();
        return true;
    }

    private static void copy(InputStream from, OutputStream to, byte[] buffer) throws IOException {
        int read;
        while ((read = from.read(buffer)) != -1) {
            to.write(buffer, 0, read);
        }
    }
}

