/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.bombe.asm.analysis;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cadixdev.bombe.analysis.InheritanceProvider;
import org.cadixdev.bombe.analysis.InheritanceType;
import org.cadixdev.bombe.type.signature.FieldSignature;
import org.cadixdev.bombe.type.signature.MethodSignature;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

class InheritanceClassInfoVisitor
extends ClassVisitor {
    private String name;
    private boolean isInterface;
    private String superName;
    private List<String> interfaces = Collections.emptyList();
    private final Map<FieldSignature, InheritanceType> fields = new HashMap<FieldSignature, InheritanceType>();
    private final Map<String, InheritanceType> fieldsByName = new HashMap<String, InheritanceType>();
    private final Map<MethodSignature, InheritanceType> methods = new HashMap<MethodSignature, InheritanceType>();

    InheritanceClassInfoVisitor(int api) {
        super(api);
    }

    InheritanceProvider.ClassInfo create() {
        return new InheritanceProvider.ClassInfo.Impl(this.name, this.isInterface, this.superName, this.interfaces, this.fields, this.fieldsByName, this.methods);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.name = name;
        this.isInterface = (access & 0x200) != 0;
        this.superName = superName;
        this.interfaces = Arrays.asList(interfaces);
    }

    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        InheritanceType type = InheritanceType.fromModifiers((int)access);
        this.fields.put(FieldSignature.of((String)name, (String)descriptor), type);
        this.fieldsByName.put(name, type);
        return null;
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        this.methods.put(MethodSignature.of((String)name, (String)descriptor), InheritanceType.fromModifiers((int)access));
        return null;
    }
}

