/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.lorenz.io.jam;

import java.io.Reader;
import org.cadixdev.lorenz.MappingSet;
import org.cadixdev.lorenz.io.TextMappingsReader;
import org.cadixdev.lorenz.io.jam.JamConstants;

public class JamReader
extends TextMappingsReader {
    public JamReader(Reader reader) {
        super(reader, Processor::new);
    }

    public static class Processor
    extends TextMappingsReader.Processor {
        private static final String CLASS_MAPPING_KEY = "CL";
        private static final String FIELD_MAPPING_KEY = "FD";
        private static final String METHOD_MAPPING_KEY = "MD";
        private static final String PARAM_MAPPING_KEY = "MP";
        private static final int CLASS_MAPPING_ELEMENT_COUNT = 3;
        private static final int FIELD_MAPPING_ELEMENT_COUNT = 5;
        private static final int METHOD_MAPPING_ELEMENT_COUNT = 5;
        private static final int PARAM_MAPPING_ELEMENT_COUNT = 6;

        public Processor(MappingSet mappings) {
            super(mappings);
        }

        public Processor() {
            this(MappingSet.create());
        }

        public void accept(String rawLine) {
            String line = JamConstants.removeComments(rawLine).trim();
            if (line.isEmpty()) {
                return;
            }
            if (line.length() < 4) {
                throw new IllegalArgumentException("Faulty JAM mapping encountered: `" + line + "`!");
            }
            String[] split = SPACE.split(line);
            int len = split.length;
            String key = split[0];
            if (key.equals(CLASS_MAPPING_KEY) && len == 3) {
                String obfName = split[1];
                String deobfName = split[2];
                this.mappings.getOrCreateClassMapping(obfName).setDeobfuscatedName(deobfName);
            } else if (key.equals(FIELD_MAPPING_KEY) && len == 5) {
                String owningClass = split[1];
                String obfName = split[2];
                String obfDescriptor = split[3];
                String deobfName = split[4];
                this.mappings.getOrCreateClassMapping(owningClass).getOrCreateFieldMapping(obfName, obfDescriptor).setDeobfuscatedName(deobfName);
            } else if (key.equals(METHOD_MAPPING_KEY) && len == 5) {
                String owningClass = split[1];
                String obfName = split[2];
                String obfDescriptor = split[3];
                String deobfName = split[4];
                this.mappings.getOrCreateClassMapping(owningClass).getOrCreateMethodMapping(obfName, obfDescriptor).setDeobfuscatedName(deobfName);
            } else if (key.equals(PARAM_MAPPING_KEY) && len == 6) {
                int index;
                String owningClass = split[1];
                String owningMethod = split[2];
                String owningMethodDescriptor = split[3];
                try {
                    index = Integer.parseInt(split[4]);
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("'" + split[4] + "' is not an integer!");
                }
                String deobfName = split[5];
                this.mappings.getOrCreateClassMapping(owningClass).getOrCreateMethodMapping(owningMethod, owningMethodDescriptor).getOrCreateParameterMapping(index).setDeobfuscatedName(deobfName);
            }
        }
    }
}

