/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.lorenz.io.proguard;

import me.jamiemansfield.string.StringReader;
import org.cadixdev.bombe.type.ArrayType;
import org.cadixdev.bombe.type.BaseType;
import org.cadixdev.bombe.type.FieldType;
import org.cadixdev.bombe.type.ObjectType;
import org.cadixdev.bombe.type.Type;
import org.cadixdev.bombe.type.VoidType;

public class PGTypeReader
extends StringReader {
    public PGTypeReader(String source) {
        super(source);
    }

    public Type readType() {
        if (this.match("void")) {
            return VoidType.INSTANCE;
        }
        return this.readFieldType();
    }

    public FieldType readFieldType() {
        while (this.available() && this.peek() != '[') {
            this.advance();
        }
        FieldType type = PGTypeReader.getType(this.substring(0, this.index()));
        if (!this.available()) {
            return type;
        }
        int dims = 0;
        while (this.available()) {
            if (this.advance() != '[') continue;
            ++dims;
        }
        return new ArrayType(dims, type);
    }

    private boolean match(String raw) {
        for (int i = 0; i < raw.toCharArray().length; ++i) {
            if (raw.toCharArray()[i] == this.peek(i)) continue;
            return false;
        }
        return true;
    }

    private static FieldType getType(String raw) {
        if ("byte".equals(raw)) {
            return BaseType.BYTE;
        }
        if ("char".equals(raw)) {
            return BaseType.CHAR;
        }
        if ("double".equals(raw)) {
            return BaseType.DOUBLE;
        }
        if ("float".equals(raw)) {
            return BaseType.FLOAT;
        }
        if ("int".equals(raw)) {
            return BaseType.INT;
        }
        if ("long".equals(raw)) {
            return BaseType.LONG;
        }
        if ("short".equals(raw)) {
            return BaseType.SHORT;
        }
        if ("boolean".equals(raw)) {
            return BaseType.BOOLEAN;
        }
        return new ObjectType(raw);
    }
}

