/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.lorenz.impl.merge;

import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.cadixdev.bombe.type.signature.FieldSignature;
import org.cadixdev.bombe.type.signature.MethodSignature;
import org.cadixdev.lorenz.MappingSet;
import org.cadixdev.lorenz.merge.FieldMergeStrategy;
import org.cadixdev.lorenz.merge.MappingSetMerger;
import org.cadixdev.lorenz.merge.MappingSetMergerHandler;
import org.cadixdev.lorenz.merge.MergeConfig;
import org.cadixdev.lorenz.merge.MergeContext;
import org.cadixdev.lorenz.merge.MergeResult;
import org.cadixdev.lorenz.merge.MethodMergeStrategy;
import org.cadixdev.lorenz.model.ClassMapping;
import org.cadixdev.lorenz.model.FieldMapping;
import org.cadixdev.lorenz.model.InnerClassMapping;
import org.cadixdev.lorenz.model.MemberMapping;
import org.cadixdev.lorenz.model.MethodMapping;
import org.cadixdev.lorenz.model.MethodParameterMapping;
import org.cadixdev.lorenz.model.TopLevelClassMapping;

public class MappingSetMergerImpl
implements MappingSetMerger {
    private final MappingSetMergerHandler handler;
    private final MethodMergeStrategy methodMergeStrategy;
    private final FieldMergeStrategy fieldMergeStrategy;
    private final MappingSet left;
    private final MappingSet right;
    private final MergeContext context;

    public MappingSetMergerImpl(MappingSet left, MappingSet right, MergeConfig config) {
        this.left = left;
        this.right = right;
        this.handler = config.getHandler();
        this.methodMergeStrategy = config.getMethodMergeStrategy();
        this.fieldMergeStrategy = config.getFieldMergeStrategy();
        this.context = new MergeContext(this.left, this.right);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MappingSet merge(MappingSet target) {
        HashSet seenNames = new HashSet();
        ExecutorService executor = Executors.newWorkStealingPool();
        try {
            CompletableFuture<Void> leftFuture = CompletableFuture.allOf((CompletableFuture[])this.left.getTopLevelClassMappings().stream().peek(mapping -> {
                seenNames.add(mapping.getObfuscatedName());
                seenNames.add(mapping.getDeobfuscatedName());
            }).map(mapping -> CompletableFuture.runAsync(() -> {
                TopLevelClassMapping rightContinuation = this.right.getTopLevelClassMapping(mapping.getDeobfuscatedName()).orElse(null);
                TopLevelClassMapping rightDuplicate = this.right.getTopLevelClassMapping(mapping.getObfuscatedName()).orElse(null);
                this.mergeTopLevelClassInternal((TopLevelClassMapping)mapping, rightContinuation, rightDuplicate, target);
            }, executor)).toArray(CompletableFuture[]::new));
            CompletableFuture<Void> rightFuture = CompletableFuture.allOf((CompletableFuture[])this.right.getTopLevelClassMappings().stream().filter(mapping -> !seenNames.contains(mapping.getObfuscatedName())).map(mapping -> CompletableFuture.runAsync(() -> this.mergeTopLevelClassInternal(null, (TopLevelClassMapping)mapping, null, target), executor)).toArray(CompletableFuture[]::new));
            try {
                CompletableFuture.allOf(leftFuture, rightFuture).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException("Mapping operation failed", e);
            }
        }
        finally {
            executor.shutdown();
        }
        return target;
    }

    @Override
    public TopLevelClassMapping mergeTopLevelClass(TopLevelClassMapping left, TopLevelClassMapping right, MappingSet target) {
        if (left != null && right != null && left.getObfuscatedName().equals(right.getObfuscatedName())) {
            return this.mergeTopLevelClassInternal(left, null, right, target);
        }
        return this.mergeTopLevelClassInternal(left, right, null, target);
    }

    protected TopLevelClassMapping mergeTopLevelClassInternal(TopLevelClassMapping left, TopLevelClassMapping rightContinuation, TopLevelClassMapping rightDuplicate, MappingSet target) {
        MergeResult<TopLevelClassMapping> mergeResult;
        if (left != null && rightDuplicate != null) {
            mergeResult = this.handler.mergeDuplicateTopLevelClassMappings(left, rightDuplicate, rightContinuation, target, this.context);
        } else if (left != null && rightContinuation != null) {
            mergeResult = this.handler.mergeTopLevelClassMappings(left, rightContinuation, target, this.context);
        } else if (rightContinuation == null && left != null) {
            mergeResult = this.handler.addLeftTopLevelClassMapping(left, target, this.context);
        } else if (rightContinuation != null) {
            mergeResult = this.handler.addRightTopLevelClassMapping(rightContinuation, target, this.context);
        } else {
            throw new IllegalStateException("Cannot merge null mappings");
        }
        TopLevelClassMapping newMapping = mergeResult.getResult();
        if (newMapping == null) {
            return null;
        }
        if (mergeResult.getMappingsToMap().isEmpty()) {
            this.mergeClass(left, null, newMapping);
        } else {
            for (TopLevelClassMapping mapping : mergeResult.getMappingsToMap()) {
                this.mergeClass(left, mapping, newMapping);
            }
        }
        return newMapping;
    }

    @Override
    public InnerClassMapping mergeInnerClass(InnerClassMapping left, InnerClassMapping right, ClassMapping<?, ?> target) {
        if (left != null && right != null && left.getObfuscatedName().equals(right.getObfuscatedName())) {
            return this.mergeInnerClassInternal(left, null, right, target);
        }
        return this.mergeInnerClassInternal(left, right, null, target);
    }

    protected InnerClassMapping mergeInnerClassInternal(InnerClassMapping left, InnerClassMapping rightContinuation, InnerClassMapping rightDuplicate, ClassMapping<?, ?> target) {
        MergeResult<InnerClassMapping> mergeResult;
        if (left != null && rightDuplicate != null) {
            mergeResult = this.handler.mergeDuplicateInnerClassMappings(left, rightDuplicate, rightContinuation, target, this.context);
        } else if (left != null && rightContinuation != null) {
            mergeResult = this.handler.mergeInnerClassMappings(left, rightContinuation, target, this.context);
        } else if (rightContinuation == null && left != null) {
            mergeResult = this.handler.addLeftInnerClassMapping(left, target, this.context);
        } else if (rightContinuation != null) {
            mergeResult = this.handler.addRightInnerClassMapping(rightContinuation, target, this.context);
        } else {
            throw new IllegalStateException("Cannot merge null mappings");
        }
        InnerClassMapping newMapping = mergeResult.getResult();
        if (newMapping == null) {
            return null;
        }
        if (mergeResult.getMappingsToMap().isEmpty()) {
            this.mergeClass(left, null, newMapping);
        } else {
            for (InnerClassMapping mapping : mergeResult.getMappingsToMap()) {
                this.mergeClass(left, mapping, newMapping);
            }
        }
        return newMapping;
    }

    @Override
    public FieldMapping mergeField(FieldMapping left, FieldMapping right, ClassMapping<?, ?> target) {
        if (left != null && right != null && left.getObfuscatedName().equals(right.getObfuscatedName())) {
            return this.mergeFieldInternal(left, null, null, right, null, target);
        }
        return this.mergeFieldInternal(left, right, null, null, null, target);
    }

    protected FieldMapping mergeFieldInternal(FieldMapping left, FieldMapping strictRightContinuation, FieldMapping looseRightContinuation, FieldMapping strictRightDuplicate, FieldMapping looseRightDuplicate, ClassMapping<?, ?> target) {
        if (left != null && (strictRightDuplicate != null || looseRightDuplicate != null)) {
            return this.handler.mergeDuplicateFieldMappings(left, strictRightDuplicate, looseRightDuplicate, strictRightContinuation, looseRightContinuation, target, this.context);
        }
        if (left != null && (strictRightContinuation != null || looseRightContinuation != null)) {
            return this.handler.mergeFieldMappings(left, strictRightContinuation, looseRightContinuation, target, this.context);
        }
        if (strictRightContinuation == null && looseRightContinuation == null && left != null) {
            return this.handler.addLeftFieldMapping(left, target, this.context);
        }
        if (strictRightContinuation != null) {
            return this.handler.addRightFieldMapping(strictRightContinuation, target, this.context);
        }
        throw new IllegalStateException("Cannot merge null mappings");
    }

    @Override
    public MethodMapping mergeMethod(MethodMapping left, MethodMapping right, ClassMapping<?, ?> target) {
        if (left != null && right != null && left.getSignature().equals((Object)right.getDeobfuscatedSignature())) {
            return this.mergeMethodInternal(left, null, null, right, null, target);
        }
        return this.mergeMethodInternal(left, right, null, null, null, target);
    }

    protected MethodMapping mergeMethodInternal(MethodMapping left, MethodMapping strictRightContinuation, MethodMapping looseRightContinuation, MethodMapping strictRightDuplicate, MethodMapping looseRightDuplicate, ClassMapping<?, ?> target) {
        MergeResult<MethodMapping> mergeResult;
        if (left != null && (strictRightDuplicate != null || looseRightDuplicate != null)) {
            mergeResult = this.handler.mergeDuplicateMethodMappings(left, strictRightDuplicate, looseRightDuplicate, strictRightContinuation, looseRightContinuation, target, this.context);
        } else if (left != null && (strictRightContinuation != null || looseRightContinuation != null)) {
            mergeResult = this.handler.mergeMethodMappings(left, strictRightContinuation, looseRightContinuation, target, this.context);
        } else if (strictRightContinuation == null && looseRightContinuation == null && left != null) {
            mergeResult = this.handler.addLeftMethodMapping(left, target, this.context);
        } else if (strictRightContinuation != null) {
            mergeResult = this.handler.addRightMethodMapping(strictRightContinuation, target, this.context);
        } else {
            throw new IllegalStateException("Cannot merge null mappings");
        }
        MethodMapping newMapping = mergeResult.getResult();
        if (newMapping == null) {
            return null;
        }
        if (mergeResult.getMappingsToMap().isEmpty()) {
            this.mergeMethodInto(left, null, newMapping);
        } else {
            for (MethodMapping mapping : mergeResult.getMappingsToMap()) {
                this.mergeMethodInto(left, mapping, newMapping);
            }
        }
        return newMapping;
    }

    protected void mergeMethodInto(MethodMapping left, MethodMapping right, MethodMapping newMapping) {
        HashSet<Integer> seenIndexes = new HashSet<Integer>();
        if (left != null) {
            for (MethodParameterMapping leftMapping : left.getParameterMappings()) {
                MethodParameterMapping rightMapping = right != null ? (MethodParameterMapping)right.getParameterMapping(leftMapping.getIndex()).orElse(null) : null;
                this.mergeMethodParameter(leftMapping, rightMapping, newMapping);
                seenIndexes.add(leftMapping.getIndex());
            }
        }
        if (right != null) {
            for (MethodParameterMapping rightMapping : right.getParameterMappings()) {
                if (seenIndexes.contains(rightMapping.getIndex())) continue;
                this.mergeMethodParameter(null, rightMapping, newMapping);
            }
        }
    }

    @Override
    public MethodParameterMapping mergeMethodParameter(MethodParameterMapping left, MethodParameterMapping right, MethodMapping target) {
        if (left != null && right != null) {
            return this.handler.mergeParameterMappings(left, right, target, this.context);
        }
        if (right == null && left != null) {
            return this.handler.addLeftParameterMapping(left, target, this.context);
        }
        if (right != null) {
            return this.handler.addRightParameterMapping(right, target, this.context);
        }
        throw new IllegalStateException("Cannot merge 2 null mappings");
    }

    protected <T extends ClassMapping<T, ?>> void mergeClass(T left, T right, T newMapping) {
        MemberMapping<FieldMapping, ClassMapping> looseRightDuplicate;
        MemberMapping<FieldMapping, ClassMapping> looseRightContinuation;
        MemberMapping<FieldMapping, ClassMapping> strictRightDuplicate;
        MemberMapping<FieldMapping, ClassMapping> strictRightContinuation;
        HashSet<String> seenClasses = new HashSet<String>();
        HashSet<FieldSignature> seenFields = new HashSet<FieldSignature>();
        HashSet<String> seenFieldNames = new HashSet<String>();
        HashSet<MethodSignature> seenMethods = new HashSet<MethodSignature>();
        if (left != null) {
            for (InnerClassMapping innerClassMapping : left.getInnerClassMappings()) {
                InnerClassMapping rightDuplicate;
                InnerClassMapping rightContinuation;
                if (right != null) {
                    rightContinuation = right.getInnerClassMapping(innerClassMapping.getDeobfuscatedName()).orElse(null);
                    rightDuplicate = right.getInnerClassMapping(innerClassMapping.getObfuscatedName()).orElse(null);
                } else {
                    rightContinuation = null;
                    rightDuplicate = null;
                }
                this.mergeInnerClassInternal(innerClassMapping, rightContinuation, rightDuplicate, newMapping);
                seenClasses.add(innerClassMapping.getObfuscatedName());
                seenClasses.add(innerClassMapping.getDeobfuscatedName());
            }
        }
        if (right != null) {
            for (InnerClassMapping innerClassMapping : right.getInnerClassMappings()) {
                if (seenClasses.contains(innerClassMapping.getObfuscatedName())) continue;
                this.mergeInnerClassInternal(null, innerClassMapping, null, newMapping);
            }
        }
        if (left != null) {
            for (FieldMapping fieldMapping : left.getFieldMappings()) {
                if (right != null) {
                    strictRightContinuation = right.getFieldMapping(fieldMapping.getDeobfuscatedSignature()).orElse(null);
                    strictRightDuplicate = right.getFieldMapping(fieldMapping.getSignature()).orElse(null);
                    if (this.fieldMergeStrategy == FieldMergeStrategy.LOOSE) {
                        looseRightContinuation = right.getFieldMapping(fieldMapping.getDeobfuscatedName()).filter(arg_0 -> MappingSetMergerImpl.lambda$mergeClass$8((FieldMapping)strictRightContinuation, arg_0)).orElse(null);
                        looseRightDuplicate = right.getFieldMapping(fieldMapping.getObfuscatedName()).filter(arg_0 -> MappingSetMergerImpl.lambda$mergeClass$9((FieldMapping)strictRightDuplicate, arg_0)).orElse(null);
                    } else {
                        looseRightContinuation = null;
                        looseRightDuplicate = null;
                    }
                } else {
                    strictRightContinuation = null;
                    strictRightDuplicate = null;
                    looseRightContinuation = null;
                    looseRightDuplicate = null;
                }
                this.mergeFieldInternal(fieldMapping, (FieldMapping)strictRightContinuation, (FieldMapping)looseRightContinuation, (FieldMapping)strictRightDuplicate, (FieldMapping)looseRightDuplicate, newMapping);
                seenFields.add(fieldMapping.getSignature());
                seenFields.add(fieldMapping.getDeobfuscatedSignature());
                if (this.fieldMergeStrategy != FieldMergeStrategy.LOOSE) continue;
                seenFieldNames.add(fieldMapping.getObfuscatedName());
                seenFieldNames.add(fieldMapping.getDeobfuscatedName());
            }
        }
        if (right != null) {
            for (FieldMapping fieldMapping : right.getFieldMappings()) {
                if (seenFieldNames.contains(fieldMapping.getObfuscatedName()) || seenFields.contains(fieldMapping.getSignature())) continue;
                this.mergeFieldInternal(null, fieldMapping, null, null, null, newMapping);
            }
        }
        if (left != null) {
            for (MethodMapping methodMapping : left.getMethodMappings()) {
                MethodSignature looseContinuationSig = new MethodSignature(methodMapping.getDeobfuscatedName(), methodMapping.getDescriptor());
                MethodSignature looseDupSig = new MethodSignature(methodMapping.getObfuscatedName(), methodMapping.getDeobfuscatedSignature().getDescriptor());
                if (right != null) {
                    strictRightContinuation = right.getMethodMapping(methodMapping.getDeobfuscatedSignature()).orElse(null);
                    strictRightDuplicate = right.getMethodMapping(methodMapping.getSignature()).orElse(null);
                    if (this.methodMergeStrategy == MethodMergeStrategy.LOOSE) {
                        looseRightContinuation = right.getMethodMapping(looseContinuationSig).orElse(null);
                        looseRightDuplicate = right.getMethodMapping(looseDupSig).orElse(null);
                    } else {
                        looseRightContinuation = null;
                        looseRightDuplicate = null;
                    }
                } else {
                    strictRightContinuation = null;
                    looseRightContinuation = null;
                    strictRightDuplicate = null;
                    looseRightDuplicate = null;
                }
                this.mergeMethodInternal(methodMapping, (MethodMapping)strictRightContinuation, (MethodMapping)looseRightContinuation, (MethodMapping)strictRightDuplicate, (MethodMapping)looseRightDuplicate, newMapping);
                seenMethods.add(methodMapping.getSignature());
                seenMethods.add(methodMapping.getDeobfuscatedSignature());
                if (this.methodMergeStrategy != MethodMergeStrategy.LOOSE) continue;
                seenMethods.add(looseContinuationSig);
                seenMethods.add(looseDupSig);
            }
        }
        if (right != null) {
            for (MethodMapping methodMapping : right.getMethodMappings()) {
                if (seenMethods.contains(methodMapping.getSignature())) continue;
                this.mergeMethodInternal(null, methodMapping, null, null, null, newMapping);
            }
        }
    }

    private static /* synthetic */ boolean lambda$mergeClass$9(FieldMapping strictRightDuplicate, FieldMapping m) {
        return m != strictRightDuplicate;
    }

    private static /* synthetic */ boolean lambda$mergeClass$8(FieldMapping strictRightContinuation, FieldMapping m) {
        return m != strictRightContinuation;
    }
}

