/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.lorenz.impl.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.cadixdev.bombe.type.signature.MethodSignature;
import org.cadixdev.lorenz.impl.model.AbstractMemberMappingImpl;
import org.cadixdev.lorenz.model.ClassMapping;
import org.cadixdev.lorenz.model.MethodMapping;
import org.cadixdev.lorenz.model.MethodParameterMapping;

public class MethodMappingImpl
extends AbstractMemberMappingImpl<MethodMapping, ClassMapping>
implements MethodMapping {
    private final MethodSignature signature;
    private final MethodParameterMapping[] parameters;

    public MethodMappingImpl(ClassMapping parentClass, MethodSignature signature, String deobfuscatedName) {
        super(parentClass, signature.getName(), deobfuscatedName);
        this.signature = signature;
        this.parameters = new MethodParameterMapping[signature.getDescriptor().getParamTypes().size()];
    }

    @Override
    public MethodSignature getSignature() {
        return this.signature;
    }

    @Override
    public Collection<MethodParameterMapping> getParameterMappings() {
        return Collections.unmodifiableList(Arrays.stream(this.parameters).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    private void checkIndex(int index) {
        if (index < 0 || index >= this.parameters.length) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
    }

    @Override
    public MethodParameterMapping createParameterMapping(int index, String deobfuscatedName) {
        this.checkIndex(index);
        MethodParameterMapping mapping = this.parameters[index];
        if (mapping != null) {
            return (MethodParameterMapping)mapping.setDeobfuscatedName(deobfuscatedName);
        }
        this.parameters[index] = this.getMappings().getModelFactory().createMethodParameterMapping(this, index, deobfuscatedName);
        return this.parameters[index];
    }

    @Override
    public Optional<MethodParameterMapping> getParameterMapping(int index) {
        this.checkIndex(index);
        return Optional.ofNullable(this.parameters[index]);
    }

    @Override
    public boolean hasParameterMapping(int index) {
        this.checkIndex(index);
        return this.parameters[index] != null;
    }

    @Override
    protected StringJoiner buildToString() {
        return super.buildToString().add("obfuscatedSignature=" + this.getObfuscatedDescriptor()).add("deobfuscatedSignature=" + this.getDeobfuscatedDescriptor());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj) || !(obj instanceof MethodMapping)) {
            return false;
        }
        MethodMapping that = (MethodMapping)obj;
        return Objects.equals(this.signature, that.getSignature());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.signature);
    }
}

