/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.lorenz;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import org.cadixdev.bombe.type.ArrayType;
import org.cadixdev.bombe.type.FieldType;
import org.cadixdev.bombe.type.MethodDescriptor;
import org.cadixdev.bombe.type.ObjectType;
import org.cadixdev.bombe.type.Type;
import org.cadixdev.lorenz.MappingSetModelFactory;
import org.cadixdev.lorenz.impl.MappingSetImpl;
import org.cadixdev.lorenz.merge.MappingSetMerger;
import org.cadixdev.lorenz.model.ClassMapping;
import org.cadixdev.lorenz.model.TopLevelClassMapping;
import org.cadixdev.lorenz.model.jar.CascadingFieldTypeProvider;
import org.cadixdev.lorenz.model.jar.FieldTypeProvider;
import org.cadixdev.lorenz.util.Reversible;

public interface MappingSet
extends Reversible<MappingSet, MappingSet> {
    public static MappingSet create() {
        return new MappingSetImpl();
    }

    public static MappingSet create(MappingSetModelFactory modelFactory) {
        return new MappingSetImpl(modelFactory);
    }

    public MappingSetModelFactory getModelFactory();

    public Collection<TopLevelClassMapping> getTopLevelClassMappings();

    public TopLevelClassMapping createTopLevelClassMapping(String var1, String var2);

    public Optional<TopLevelClassMapping> getTopLevelClassMapping(String var1);

    default public TopLevelClassMapping getOrCreateTopLevelClassMapping(String obfuscatedName) {
        return this.getTopLevelClassMapping(obfuscatedName).orElseGet(() -> this.createTopLevelClassMapping(obfuscatedName, obfuscatedName));
    }

    public boolean hasTopLevelClassMapping(String var1);

    default public Optional<? extends ClassMapping<?, ?>> getClassMapping(String obfuscatedName) {
        int lastIndex = obfuscatedName.lastIndexOf(36);
        if (lastIndex == -1) {
            return this.getTopLevelClassMapping(obfuscatedName);
        }
        String parentClassName = obfuscatedName.substring(0, lastIndex);
        String innerClassName = obfuscatedName.substring(lastIndex + 1);
        return this.getClassMapping(parentClassName).flatMap(parentClassMapping -> parentClassMapping.getInnerClassMapping(innerClassName));
    }

    default public Optional<? extends ClassMapping<?, ?>> computeClassMapping(String obfuscatedName) {
        int lastIndex = obfuscatedName.lastIndexOf(36);
        if (lastIndex == -1) {
            return this.getTopLevelClassMapping(obfuscatedName);
        }
        String parentClassName = obfuscatedName.substring(0, lastIndex);
        String innerClassName = obfuscatedName.substring(lastIndex + 1);
        return this.getClassMapping(parentClassName).map(parentClassMapping -> parentClassMapping.getOrCreateInnerClassMapping(innerClassName));
    }

    default public ClassMapping<?, ?> getOrCreateClassMapping(String obfuscatedName) {
        int lastIndex = obfuscatedName.lastIndexOf(36);
        if (lastIndex == -1) {
            return this.getOrCreateTopLevelClassMapping(obfuscatedName);
        }
        String parentClassName = obfuscatedName.substring(0, lastIndex);
        String innerClassName = obfuscatedName.substring(lastIndex + 1);
        ClassMapping<?, ?> parentClass = this.getOrCreateClassMapping(parentClassName);
        return parentClass.getOrCreateInnerClassMapping(innerClassName);
    }

    public CascadingFieldTypeProvider getFieldTypeProvider();

    default public MappingSet addFieldTypeProvider(FieldTypeProvider fieldTypeProvider) {
        this.getFieldTypeProvider().add(fieldTypeProvider);
        return this;
    }

    default public MappingSet removeFieldTypeProvider(FieldTypeProvider fieldTypeProvider) {
        this.getFieldTypeProvider().remove(fieldTypeProvider);
        return this;
    }

    default public Type deobfuscate(Type type) {
        if (type instanceof FieldType) {
            return this.deobfuscate(this.deobfuscate((FieldType)type));
        }
        return type;
    }

    default public FieldType deobfuscate(FieldType type) {
        if (type instanceof ArrayType) {
            ArrayType arr = (ArrayType)type;
            FieldType component = this.deobfuscate(arr.getComponent());
            return component == arr.getComponent() ? arr : new ArrayType(arr.getDimCount(), component);
        }
        if (type instanceof ObjectType) {
            ObjectType obj = (ObjectType)type;
            return (FieldType)this.getClassMapping(obj.getClassName()).map(m -> new ObjectType(m.getFullDeobfuscatedName())).orElse(obj);
        }
        return type;
    }

    default public MethodDescriptor deobfuscate(MethodDescriptor descriptor) {
        return new MethodDescriptor(descriptor.getParamTypes().stream().map(this::deobfuscate).collect(Collectors.toList()), this.deobfuscate(descriptor.getReturnType()));
    }

    default public MappingSet reverse() {
        return this.reverse(MappingSet.create());
    }

    @Override
    default public MappingSet reverse(MappingSet parent) {
        this.getTopLevelClassMappings().forEach(klass -> klass.reverse(parent));
        return parent;
    }

    default public MappingSet merge(MappingSet with) {
        return this.merge(with, MappingSet.create());
    }

    default public MappingSet merge(MappingSet with, MappingSet parent) {
        return MappingSetMerger.create(this, with).merge(parent);
    }

    default public MappingSet copy() {
        MappingSet mappings = MappingSet.create();
        this.getTopLevelClassMappings().forEach(klass -> klass.copy(mappings));
        return mappings;
    }
}

