/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.lorenz.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.cadixdev.lorenz.MappingSet;
import org.cadixdev.lorenz.io.MappingsReader;

public abstract class TextMappingsReader
extends MappingsReader {
    protected final BufferedReader reader;
    protected final Function<MappingSet, Processor> processor;

    protected TextMappingsReader(Reader reader, Function<MappingSet, Processor> processor) {
        this.reader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        this.processor = processor;
    }

    @Override
    public MappingSet read(MappingSet mappings) {
        Processor processor = this.processor.apply(mappings);
        this.reader.lines().forEach(processor);
        return mappings;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public static abstract class Processor
    implements Consumer<String> {
        protected static final Pattern SPACE = Pattern.compile(" ", 16);
        protected final MappingSet mappings;

        protected Processor(MappingSet mappings) {
            this.mappings = mappings;
        }
    }
}

