/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.lorenz.model;

import java.util.Optional;
import org.cadixdev.bombe.type.FieldType;
import org.cadixdev.bombe.type.signature.FieldSignature;
import org.cadixdev.lorenz.merge.MappingSetMerger;
import org.cadixdev.lorenz.model.ClassMapping;
import org.cadixdev.lorenz.model.MemberMapping;

public interface FieldMapping
extends MemberMapping<FieldMapping, ClassMapping> {
    public FieldSignature getSignature();

    default public FieldSignature getDeobfuscatedSignature() {
        return this.getType().map(fieldType -> new FieldSignature(this.getDeobfuscatedName(), this.getMappings().deobfuscate((FieldType)fieldType))).orElseGet(() -> new FieldSignature(this.getDeobfuscatedName()));
    }

    @Override
    default public String getObfuscatedName() {
        return this.getSignature().getName();
    }

    default public Optional<FieldType> getType() {
        if (this.getSignature().getType().isPresent()) {
            return this.getSignature().getType();
        }
        return this.getMappings().getFieldTypeProvider().provide(this);
    }

    @Override
    default public String getFullObfuscatedName() {
        return String.format("%s/%s", ((ClassMapping)this.getParent()).getFullObfuscatedName(), this.getObfuscatedName());
    }

    @Override
    default public String getFullDeobfuscatedName() {
        return String.format("%s/%s", ((ClassMapping)this.getParent()).getFullDeobfuscatedName(), this.getDeobfuscatedName());
    }

    @Override
    default public FieldMapping reverse(ClassMapping parent) {
        return parent.createFieldMapping(this.getDeobfuscatedSignature(), this.getObfuscatedName());
    }

    @Override
    default public FieldMapping merge(FieldMapping with, ClassMapping parent) {
        return MappingSetMerger.create(this.getMappings(), with.getMappings()).mergeField(this, with, parent);
    }

    @Override
    default public FieldMapping copy(ClassMapping parent) {
        return parent.createFieldMapping(this.getSignature(), this.getDeobfuscatedName());
    }
}

