/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.mercury.at;

import java.util.List;
import org.cadixdev.at.AccessChange;
import org.cadixdev.at.AccessTransform;
import org.cadixdev.at.AccessTransformSet;
import org.cadixdev.at.ModifierChange;
import org.cadixdev.bombe.analysis.InheritanceProvider;
import org.cadixdev.bombe.type.signature.MethodSignature;
import org.cadixdev.mercury.RewriteContext;
import org.cadixdev.mercury.SourceRewriter;
import org.cadixdev.mercury.analysis.MercuryInheritanceProvider;
import org.cadixdev.mercury.util.BombeBindings;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;

public final class AccessTransformerRewriter
implements SourceRewriter {
    private final AccessTransformSet ats;

    public static SourceRewriter create(AccessTransformSet ats) {
        return new AccessTransformerRewriter(ats);
    }

    private AccessTransformerRewriter(AccessTransformSet ats) {
        this.ats = ats;
    }

    @Override
    public int getFlags() {
        return 1;
    }

    @Override
    public void rewrite(RewriteContext context) {
        context.getCompilationUnit().accept((ASTVisitor)new Visitor(context, this.ats));
    }

    private static class Visitor
    extends ASTVisitor {
        private final RewriteContext context;
        private final AccessTransformSet ats;
        private final InheritanceProvider inheritanceProvider;

        private Visitor(RewriteContext context, AccessTransformSet ats) {
            this.context = context;
            this.ats = ats;
            this.inheritanceProvider = MercuryInheritanceProvider.get(context.getMercury());
        }

        private void transform(BodyDeclaration declaration, AccessTransform transform) {
            if (transform.isEmpty()) {
                return;
            }
            Modifier accessModifier = null;
            AccessChange accessChange = transform.getAccess();
            ModifierChange finalChange = transform.getFinal();
            List modifiers = declaration.modifiers();
            block12: for (IExtendedModifier em : modifiers) {
                if (!em.isModifier()) continue;
                Modifier m = (Modifier)em;
                int modifier = m.getKeyword().toFlagValue();
                switch (modifier) {
                    case 1: 
                    case 2: 
                    case 4: {
                        switch (accessChange) {
                            case NONE: {
                                accessModifier = m;
                                continue block12;
                            }
                            case PACKAGE_PRIVATE: {
                                this.context.createASTRewrite().remove((ASTNode)m, null);
                                accessChange = AccessChange.NONE;
                                continue block12;
                            }
                        }
                        this.context.createASTRewrite().set((ASTNode)m, (StructuralPropertyDescriptor)Modifier.KEYWORD_PROPERTY, (Object)Modifier.ModifierKeyword.fromFlagValue((int)accessChange.getModifier()), null);
                        accessModifier = m;
                        accessChange = AccessChange.NONE;
                        continue block12;
                    }
                    case 16: {
                        switch (finalChange) {
                            case REMOVE: {
                                this.context.createASTRewrite().remove((ASTNode)m, null);
                            }
                            case ADD: {
                                finalChange = ModifierChange.NONE;
                                continue block12;
                            }
                        }
                        continue block12;
                    }
                }
            }
            if (accessChange == AccessChange.NONE && finalChange == ModifierChange.NONE) {
                return;
            }
            ListRewrite rewrite = this.context.createASTRewrite().getListRewrite((ASTNode)declaration, declaration.getModifiersProperty());
            if (accessChange != AccessChange.NONE) {
                accessModifier = declaration.getAST().newModifier(Modifier.ModifierKeyword.fromFlagValue((int)accessChange.getModifier()));
                rewrite.insertFirst((ASTNode)accessModifier, null);
            }
            if (finalChange != ModifierChange.NONE) {
                Modifier finalModifier = declaration.getAST().newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD);
                if (accessModifier != null) {
                    rewrite.insertAfter((ASTNode)finalModifier, (ASTNode)accessModifier, null);
                } else {
                    rewrite.insertFirst((ASTNode)finalModifier, null);
                }
            }
        }

        private AccessTransformSet.Class findClass(ITypeBinding declaringClass) {
            if (declaringClass == null) {
                return null;
            }
            return this.ats.getClass(declaringClass.getBinaryName()).orElse(null);
        }

        private void visitDeclaration(AbstractTypeDeclaration declaration) {
            ITypeBinding binding = declaration.resolveBinding();
            if (binding == null) {
                if (this.context.getMercury().isGracefulClasspathChecks()) {
                    return;
                }
                throw new IllegalStateException("No binding for type declaration " + declaration.getName() + " in class " + this.context.getQualifiedPrimaryType());
            }
            AccessTransformSet.Class classSet = this.findClass(binding);
            if (classSet != null) {
                this.transform((BodyDeclaration)declaration, classSet.get());
            }
        }

        public boolean visit(TypeDeclaration node) {
            this.visitDeclaration((AbstractTypeDeclaration)node);
            return true;
        }

        public boolean visit(EnumDeclaration node) {
            this.visitDeclaration((AbstractTypeDeclaration)node);
            return true;
        }

        public boolean visit(AnnotationTypeDeclaration node) {
            this.visitDeclaration((AbstractTypeDeclaration)node);
            return true;
        }

        public boolean visit(FieldDeclaration node) {
            AccessTransform transform = AccessTransform.EMPTY;
            List fragments = node.fragments();
            for (VariableDeclarationFragment fragment : fragments) {
                IVariableBinding binding = fragment.resolveBinding();
                if (binding == null) {
                    if (this.context.getMercury().isGracefulClasspathChecks()) continue;
                    throw new IllegalStateException("No binding for field node " + fragment.getName() + " in class " + this.context.getQualifiedPrimaryType());
                }
                AccessTransformSet.Class classSet = this.findClass(binding.getDeclaringClass());
                if (classSet == null) continue;
                transform = transform.merge(classSet.getField(binding.getName()));
            }
            this.transform((BodyDeclaration)node, transform);
            return true;
        }

        public boolean visit(MethodDeclaration node) {
            IMethodBinding binding = node.resolveBinding();
            if (binding == null) {
                if (this.context.getMercury().isGracefulClasspathChecks()) {
                    return false;
                }
                throw new IllegalStateException("No binding for method node " + node.getName() + " in class " + this.context.getQualifiedPrimaryType());
            }
            ITypeBinding declaringClass = binding.getDeclaringClass();
            if (declaringClass == null) {
                return true;
            }
            AccessTransformSet.Class classSet = this.ats.getOrCreateClass(declaringClass.getBinaryName());
            classSet.complete(this.inheritanceProvider, (Object)declaringClass);
            MethodSignature signature = BombeBindings.convertSignature(binding);
            this.transform((BodyDeclaration)node, classSet.getMethod(signature));
            return true;
        }
    }
}

