/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.mercury.extra;

import java.util.List;
import java.util.Optional;
import org.cadixdev.mercury.RewriteContext;
import org.cadixdev.mercury.SourceRewriter;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;

public final class BridgeMethodRewriter
implements SourceRewriter {
    private static final SourceRewriter INSTANCE = new BridgeMethodRewriter();

    public static SourceRewriter create() {
        return INSTANCE;
    }

    private BridgeMethodRewriter() {
    }

    @Override
    public int getFlags() {
        return 1;
    }

    @Override
    public void rewrite(RewriteContext context) {
        context.getCompilationUnit().accept((ASTVisitor)new Visitor(context));
    }

    private static class Visitor
    extends ASTVisitor {
        private final RewriteContext context;

        private Visitor(RewriteContext context) {
            this.context = context;
        }

        private static IMethodBinding findBridgedMethod(MethodDeclaration node) {
            Expression expression;
            Block body = node.getBody();
            if (body == null) {
                return null;
            }
            List statements = body.statements();
            if (statements.size() != 1) {
                return null;
            }
            Statement statement = (Statement)statements.get(0);
            switch (statement.getNodeType()) {
                case 21: {
                    expression = ((ExpressionStatement)statement).getExpression();
                    break;
                }
                case 41: {
                    expression = ((ReturnStatement)statement).getExpression();
                    break;
                }
                default: {
                    return null;
                }
            }
            if (expression == null || expression.getNodeType() != 32) {
                return null;
            }
            MethodInvocation invocation = (MethodInvocation)expression;
            if ((expression = invocation.getExpression()) == null || expression.getNodeType() != 52) {
                return null;
            }
            if (((ThisExpression)expression).getQualifier() != null) {
                return null;
            }
            List arguments = invocation.arguments();
            if (arguments.size() != node.parameters().size()) {
                return null;
            }
            block8: for (Expression arg : arguments) {
                switch (arg.getNodeType()) {
                    case 42: {
                        continue block8;
                    }
                    case 11: {
                        if (((CastExpression)arg).getExpression().getNodeType() != 42) break;
                        continue block8;
                    }
                }
                return null;
            }
            return invocation.resolveMethodBinding().getMethodDeclaration();
        }

        public boolean visit(MethodDeclaration node) {
            ITypeBinding[] otherTypes;
            String otherName;
            IMethodBinding bridged = Visitor.findBridgedMethod(node);
            if (bridged == null) {
                return true;
            }
            MethodDeclaration other = (MethodDeclaration)this.context.getCompilationUnit().findDeclaringNode((IBinding)bridged);
            if (other == null) {
                return true;
            }
            Optional<ASTRewrite> rewrite = this.context.getASTRewrite();
            String name = Visitor.getIdentifier(node.getName(), rewrite);
            if (!name.equals(otherName = Visitor.getIdentifier(other.getName(), rewrite))) {
                return true;
            }
            IMethodBinding binding = node.resolveBinding();
            ITypeBinding[] myTypes = binding.getParameterTypes();
            if (myTypes.length != (otherTypes = bridged.getParameterTypes()).length) {
                return true;
            }
            for (int i = 0; i < myTypes.length; ++i) {
                if (myTypes[i].getErasure().isEqualTo((IBinding)otherTypes[i].getErasure())) continue;
                return true;
            }
            this.context.createASTRewrite().remove((ASTNode)node, null);
            return true;
        }

        private static String getIdentifier(SimpleName name, Optional<ASTRewrite> rewrite) {
            return rewrite.map(r -> (String)r.get((ASTNode)name, (StructuralPropertyDescriptor)SimpleName.IDENTIFIER_PROPERTY)).orElseGet(() -> ((SimpleName)name).getIdentifier());
        }
    }
}

