/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.mercury.remapper;

import java.util.Objects;
import org.cadixdev.lorenz.MappingSet;
import org.cadixdev.mercury.RewriteContext;
import org.cadixdev.mercury.SourceRewriter;
import org.cadixdev.mercury.remapper.RemapperVisitor;
import org.cadixdev.mercury.remapper.SimpleRemapperVisitor;
import org.eclipse.jdt.core.dom.ASTVisitor;

public final class MercuryRemapper
implements SourceRewriter {
    private final MappingSet mappings;
    private final boolean simple;
    private final boolean javadoc;

    public static SourceRewriter create(MappingSet mappings) {
        return new MercuryRemapper(mappings, false, true);
    }

    public static SourceRewriter create(MappingSet mappings, boolean javadoc) {
        return new MercuryRemapper(mappings, false, javadoc);
    }

    public static SourceRewriter createSimple(MappingSet mappings) {
        return new MercuryRemapper(mappings, true, true);
    }

    public static SourceRewriter createSimple(MappingSet mappings, boolean javadoc) {
        return new MercuryRemapper(mappings, true, javadoc);
    }

    private MercuryRemapper(MappingSet mappings, boolean simple, boolean javadoc) {
        this.mappings = Objects.requireNonNull(mappings, "mappings");
        this.simple = simple;
        this.javadoc = javadoc;
    }

    @Override
    public int getFlags() {
        return 1;
    }

    @Override
    public void rewrite(RewriteContext context) {
        context.getCompilationUnit().accept((ASTVisitor)(this.simple ? new SimpleRemapperVisitor(context, this.mappings, this.javadoc) : new RemapperVisitor(context, this.mappings, this.javadoc)));
    }
}

