/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.mercury.remapper;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import org.cadixdev.bombe.analysis.InheritanceProvider;
import org.cadixdev.bombe.type.signature.FieldSignature;
import org.cadixdev.bombe.type.signature.MethodSignature;
import org.cadixdev.lorenz.MappingSet;
import org.cadixdev.lorenz.model.ClassMapping;
import org.cadixdev.lorenz.model.FieldMapping;
import org.cadixdev.lorenz.model.InnerClassMapping;
import org.cadixdev.lorenz.model.MemberMapping;
import org.cadixdev.lorenz.model.MethodMapping;
import org.cadixdev.lorenz.model.MethodParameterMapping;
import org.cadixdev.mercury.RewriteContext;
import org.cadixdev.mercury.analysis.MercuryInheritanceProvider;
import org.cadixdev.mercury.util.BombeBindings;
import org.cadixdev.mercury.util.GracefulCheck;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.VariableDeclaration;

class SimpleRemapperVisitor
extends ASTVisitor {
    private static final String LVT_NAMES_PROPERTY = "org.cadixdev.mercury.lvtNames";
    private static final String LOCAL_VARIABLE_NAME_PROPERTY = "org.cadixdev.mercury.localVariableName";
    private static final String NEW_PARAM_NAMES_PROPERTY = "org.cadixdev.mercury.newParamNames";
    final RewriteContext context;
    final MappingSet mappings;
    private final InheritanceProvider inheritanceProvider;

    SimpleRemapperVisitor(RewriteContext context, MappingSet mappings, boolean javadoc) {
        super(javadoc);
        this.context = context;
        this.mappings = mappings;
        this.inheritanceProvider = MercuryInheritanceProvider.get(context.getMercury());
    }

    final void updateIdentifier(SimpleName node, String newName) {
        if (!node.getIdentifier().equals(newName) && !node.isVar()) {
            this.context.createASTRewrite().set((ASTNode)node, (StructuralPropertyDescriptor)SimpleName.IDENTIFIER_PROPERTY, (Object)newName, null);
        }
    }

    private void remapMethod(SimpleName node, IMethodBinding binding) {
        ITypeBinding declaringClass = binding.getDeclaringClass();
        if (GracefulCheck.checkGracefully(this.context, declaringClass)) {
            return;
        }
        ClassMapping classMapping = this.mappings.getOrCreateClassMapping(declaringClass.getBinaryName());
        if (binding.isConstructor()) {
            this.updateIdentifier(node, classMapping.getSimpleDeobfuscatedName());
        } else {
            MethodMapping mapping = this.findMethodMapping(declaringClass, binding);
            if (mapping == null) {
                return;
            }
            this.updateIdentifier(node, mapping.getDeobfuscatedName());
        }
    }

    private void remapField(SimpleName node, IVariableBinding binding) {
        if (!binding.isField()) {
            if (binding.isParameter()) {
                this.remapParameter(node, binding);
            } else {
                this.checkLocalVariable(node, binding);
            }
            return;
        }
        ITypeBinding declaringClass = binding.getDeclaringClass();
        if (declaringClass == null) {
            return;
        }
        ClassMapping classMapping = this.mappings.getClassMapping(declaringClass.getBinaryName()).orElse(null);
        if (classMapping == null) {
            return;
        }
        FieldSignature bindingSignature = BombeBindings.convertSignature(binding);
        FieldMapping mapping = (FieldMapping)this.findMemberMapping(bindingSignature, classMapping, ClassMapping::computeFieldMapping);
        if (mapping == null) {
            return;
        }
        this.updateIdentifier(node, mapping.getDeobfuscatedName());
    }

    private MethodMapping findMethodMapping(ITypeBinding declaringClass, IMethodBinding declaringMethod) {
        ClassMapping classMapping = this.mappings.getClassMapping(declaringClass.getBinaryName()).orElse(null);
        if (classMapping == null) {
            return null;
        }
        MethodSignature methodSig = BombeBindings.convertSignature(declaringMethod);
        MethodMapping methodMapping = (MethodMapping)this.findMemberMapping(methodSig, classMapping, ClassMapping::getMethodMapping);
        if (methodMapping == null) {
            classMapping.complete(this.inheritanceProvider, (Object)declaringClass);
            methodMapping = classMapping.getMethodMapping(methodSig).orElse(null);
        }
        return methodMapping;
    }

    private <T extends MemberMapping<?, ?>, M> T findMemberMapping(M matcher, ClassMapping<?, ?> classMapping, BiFunction<ClassMapping<?, ?>, M, Optional<? extends T>> getMapping) {
        MemberMapping mapping = getMapping.apply(classMapping, matcher).orElse(null);
        if (mapping != null) {
            return (T)mapping;
        }
        if (!this.context.getMercury().isFlexibleAnonymousClassMemberLookups()) {
            return null;
        }
        return this.findMemberMappingAnonClass(matcher, classMapping, getMapping);
    }

    private <T extends MemberMapping<?, ?>, M> T findMemberMappingAnonClass(M matcher, ClassMapping<?, ?> classMapping, BiFunction<ClassMapping<?, ?>, M, Optional<? extends T>> getMapping) {
        MemberMapping mapping;
        if (Objects.equals(classMapping.getObfuscatedName(), classMapping.getDeobfuscatedName())) {
            return null;
        }
        if (!(classMapping instanceof InnerClassMapping)) {
            return null;
        }
        if (!classMapping.getObfuscatedName().chars().allMatch(Character::isDigit)) {
            return null;
        }
        ClassMapping parentMapping = (ClassMapping)((InnerClassMapping)classMapping).getParent();
        if (parentMapping == null) {
            return null;
        }
        ClassMapping otherClassMapping = parentMapping.getInnerClassMapping(classMapping.getDeobfuscatedName()).orElse(null);
        if (otherClassMapping != null && (mapping = (MemberMapping)getMapping.apply(otherClassMapping, matcher).orElse(null)) != null) {
            return (T)mapping;
        }
        for (InnerClassMapping innerClassMapping : parentMapping.getInnerClassMappings()) {
            if (!Objects.equals(classMapping.getObfuscatedName(), innerClassMapping.getDeobfuscatedName())) continue;
            otherClassMapping = innerClassMapping;
            break;
        }
        if (otherClassMapping == null) {
            return null;
        }
        return (T)((MemberMapping)getMapping.apply(otherClassMapping, matcher).orElse(null));
    }

    private void remapParameter(SimpleName node, IVariableBinding binding) {
        IMethodBinding declaringMethod = binding.getDeclaringMethod();
        if (declaringMethod == null) {
            return;
        }
        int index = -1;
        ASTNode n = this.context.getCompilationUnit().findDeclaringNode((IBinding)declaringMethod);
        if (n instanceof MethodDeclaration) {
            MethodDeclaration methodDeclaration = (MethodDeclaration)n;
            List parameters = methodDeclaration.parameters();
            for (int i = 0; i < parameters.size(); ++i) {
                if (!binding.equals(((SingleVariableDeclaration)parameters.get(i)).resolveBinding())) continue;
                index = i;
            }
        }
        if (index == -1) {
            return;
        }
        ITypeBinding declaringClass = declaringMethod.getDeclaringClass();
        if (declaringClass == null) {
            return;
        }
        MethodMapping methodMapping = this.findMethodMapping(declaringClass, declaringMethod);
        if (methodMapping == null) {
            return;
        }
        methodMapping.getParameterMapping(index).ifPresent(paramMapping -> this.updateIdentifier(node, paramMapping.getDeobfuscatedName()));
    }

    private void checkLocalVariable(SimpleName node, IVariableBinding binding) {
        ASTNode bindingNode = this.context.getCompilationUnit().findDeclaringNode((IBinding)binding);
        String localVariableName = (String)bindingNode.getProperty(LOCAL_VARIABLE_NAME_PROPERTY);
        if (localVariableName != null) {
            this.updateIdentifier(node, localVariableName);
            return;
        }
        IMethodBinding declaringMethod = binding.getDeclaringMethod();
        if (declaringMethod == null) {
            return;
        }
        if (declaringMethod.getDeclaringMember() != null) {
            LambdaExpression lambdaExpr = this.getLambdaMethodDeclaration(declaringMethod);
            if (lambdaExpr == null) {
                return;
            }
            IMethodBinding outerMethod = declaringMethod;
            while (outerMethod.getDeclaringMember() instanceof IMethodBinding) {
                outerMethod = (IMethodBinding)outerMethod.getDeclaringMember();
            }
            if (outerMethod == declaringMethod) {
                return;
            }
            ASTNode n = this.context.getCompilationUnit().findDeclaringNode((IBinding)outerMethod);
            if (!(n instanceof MethodDeclaration)) {
                return;
            }
            MethodDeclaration outerDeclaration = (MethodDeclaration)n;
            ASTNode body = lambdaExpr.getBody();
            if (!(body instanceof Block)) {
                body = null;
            }
            this.checkLocalVariableWithMappings(node, bindingNode, outerMethod, outerDeclaration, declaringMethod, (Block)body);
        } else {
            ASTNode n = this.context.getCompilationUnit().findDeclaringNode((IBinding)declaringMethod);
            if (!(n instanceof MethodDeclaration)) {
                return;
            }
            MethodDeclaration methodDeclaration = (MethodDeclaration)n;
            this.checkLocalVariableWithMappings(node, bindingNode, declaringMethod, methodDeclaration, declaringMethod, methodDeclaration.getBody());
        }
    }

    private void checkLocalVariableWithMappings(SimpleName node, ASTNode bindingNode, IMethodBinding binding, MethodDeclaration declaration, IMethodBinding blockDeclaringMethod, Block body) {
        ITypeBinding declaringClass = binding.getDeclaringClass();
        this.mappings.getClassMapping(declaringClass.getBinaryName()).flatMap(classMapping -> {
            classMapping.complete(this.inheritanceProvider, (Object)declaringClass);
            return classMapping.getMethodMapping(BombeBindings.convertSignature(binding));
        }).ifPresent(methodMapping -> {
            if (!methodMapping.getParameterMappings().isEmpty()) {
                Set<String> newParamNames = this.newParamNames(declaration, (MethodMapping)methodMapping);
                this.checkLocalVariableForConflicts(node, bindingNode, blockDeclaringMethod, body, newParamNames);
            }
        });
    }

    private void checkLocalVariableForConflicts(SimpleName node, ASTNode bindingNode, IMethodBinding blockDeclaringMethod, Block block, Set<String> newParamNames) {
        String name = node.getIdentifier();
        if (!newParamNames.contains(name)) {
            return;
        }
        Set<String> localVariableNames = this.collectLocalVariableNames(blockDeclaringMethod, block);
        int counter = 1;
        String newName = name + counter;
        while (localVariableNames.contains(newName) || newParamNames.contains(newName)) {
            newName = name + ++counter;
        }
        localVariableNames.add(newName);
        bindingNode.setProperty(LOCAL_VARIABLE_NAME_PROPERTY, (Object)newName);
        this.updateIdentifier(node, newName);
    }

    private LambdaExpression getLambdaMethodDeclaration(IMethodBinding declaringMethod) {
        ASTNode node = this.context.getCompilationUnit().findDeclaringNode(declaringMethod.getKey());
        if (node instanceof LambdaExpression) {
            return (LambdaExpression)node;
        }
        return null;
    }

    private Set<String> collectLocalVariableNames(IMethodBinding blockDeclaringMethod, Block block) {
        IVariableBinding[] synthLocals;
        if (block == null) {
            return Collections.emptySet();
        }
        Set<String> result = SimpleRemapperVisitor.checkProperty(LVT_NAMES_PROPERTY, (ASTNode)block);
        if (result != null) {
            return result;
        }
        result = new HashSet<String>();
        block.setProperty(LVT_NAMES_PROPERTY, result);
        for (IVariableBinding synthLocal : synthLocals = blockDeclaringMethod.getSyntheticOuterLocals()) {
            String name = synthLocal.getName();
            if (!name.startsWith("val$")) continue;
            result.add(name.substring(4));
        }
        List statements = block.statements();
        for (ASTNode statement : statements) {
            if (!(statement instanceof VariableDeclaration)) continue;
            VariableDeclaration declaration = (VariableDeclaration)statement;
            result.add(declaration.getName().getIdentifier());
        }
        return result;
    }

    private Set<String> newParamNames(MethodDeclaration methodDeclaration, MethodMapping mapping) {
        Set<String> result = SimpleRemapperVisitor.checkProperty(NEW_PARAM_NAMES_PROPERTY, (ASTNode)methodDeclaration);
        if (result != null) {
            return result;
        }
        result = new HashSet<String>();
        methodDeclaration.setProperty(NEW_PARAM_NAMES_PROPERTY, result);
        List parameters = methodDeclaration.parameters();
        for (int i = 0; i < parameters.size(); ++i) {
            Optional paramMapping = mapping.getParameterMapping(i);
            if (paramMapping.isPresent()) {
                result.add(((MethodParameterMapping)paramMapping.get()).getDeobfuscatedName());
                continue;
            }
            result.add(((SingleVariableDeclaration)parameters.get(i)).getName().getIdentifier());
        }
        return result;
    }

    private static Set<String> checkProperty(String propName, ASTNode node) {
        if (node == null) {
            return null;
        }
        Object value = node.getProperty(propName);
        if (value instanceof Set) {
            Set result = (Set)value;
            return result;
        }
        return null;
    }

    protected void visit(SimpleName node, IBinding binding) {
        switch (binding.getKind()) {
            case 4: {
                this.remapMethod(node, ((IMethodBinding)binding).getMethodDeclaration());
                break;
            }
            case 3: {
                this.remapField(node, ((IVariableBinding)binding).getVariableDeclaration());
            }
        }
    }

    public final boolean visit(SimpleName node) {
        IBinding binding = node.resolveBinding();
        if (binding != null) {
            this.visit(node, binding);
        }
        return false;
    }
}

