/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.mercury.util;

import java.util.ArrayList;
import org.cadixdev.bombe.type.ArrayType;
import org.cadixdev.bombe.type.FieldType;
import org.cadixdev.bombe.type.MethodDescriptor;
import org.cadixdev.bombe.type.ObjectType;
import org.cadixdev.bombe.type.PrimitiveType;
import org.cadixdev.bombe.type.Type;
import org.cadixdev.bombe.type.signature.FieldSignature;
import org.cadixdev.bombe.type.signature.MethodSignature;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;

public final class BombeBindings {
    private static final String BINARY_CONSTRUCTOR_NAME = "<init>";

    private BombeBindings() {
    }

    public static boolean isPackagePrivate(int modifiers) {
        return (modifiers & 7) == 0;
    }

    public static Type convertType(ITypeBinding binding) {
        if (binding.isPrimitive()) {
            return PrimitiveType.getFromKey((char)binding.getBinaryName().charAt(0));
        }
        if (binding.isArray()) {
            return new ArrayType(binding.getDimensions(), (FieldType)BombeBindings.convertType(binding.getElementType()));
        }
        return new ObjectType(binding.getErasure().getBinaryName());
    }

    private static String getBinaryName(IMethodBinding binding) {
        if (binding.isConstructor()) {
            return BINARY_CONSTRUCTOR_NAME;
        }
        return binding.getName();
    }

    public static MethodSignature convertSignature(IMethodBinding binding) {
        ITypeBinding[] parameterBindings = binding.getParameterTypes();
        ArrayList<FieldType> parameters = new ArrayList<FieldType>(parameterBindings.length);
        for (ITypeBinding parameterBinding : parameterBindings) {
            parameters.add((FieldType)BombeBindings.convertType(parameterBinding));
        }
        return new MethodSignature(BombeBindings.getBinaryName(binding), new MethodDescriptor(parameters, BombeBindings.convertType(binding.getReturnType())));
    }

    public static FieldSignature convertSignature(IVariableBinding binding) {
        return new FieldSignature(binding.getName(), (FieldType)BombeBindings.convertType(binding.getType()));
    }
}

