/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.junit5;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.function.Supplier;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.DecisionService;
import org.camunda.bpm.engine.ExternalTaskService;
import org.camunda.bpm.engine.FilterService;
import org.camunda.bpm.engine.FormService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineServices;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.diagnostics.PlatformDiagnosticsRegistry;
import org.camunda.bpm.engine.impl.test.TestHelper;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.Deployment;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.junit.jupiter.api.extension.TestWatcher;
import org.slf4j.Logger;

public class ProcessEngineExtension
implements TestWatcher,
TestInstancePostProcessor,
BeforeTestExecutionCallback,
AfterTestExecutionCallback,
AfterAllCallback,
ParameterResolver,
ProcessEngineServices {
    protected static final Logger LOG = ProcessEngineLogger.TEST_LOGGER.getLogger();
    protected ProcessEngine processEngine;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected RepositoryService repositoryService;
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected HistoryService historyService;
    protected IdentityService identityService;
    protected ManagementService managementService;
    protected FormService formService;
    protected FilterService filterService;
    protected AuthorizationService authorizationService;
    protected CaseService caseService;
    protected ExternalTaskService externalTaskService;
    protected DecisionService decisionService;
    protected String configurationResource = "camunda.cfg.xml";
    protected String deploymentId;
    protected boolean ensureCleanAfterTest = false;
    protected List<String> additionalDeployments = new ArrayList<String>();

    protected void initializeProcessEngine() {
        this.processEngine = TestHelper.getProcessEngine((String)this.configurationResource);
        this.processEngineConfiguration = (ProcessEngineConfigurationImpl)this.processEngine.getProcessEngineConfiguration();
    }

    protected void initializeServices() {
        this.processEngineConfiguration = ((ProcessEngineImpl)this.processEngine).getProcessEngineConfiguration();
        this.repositoryService = this.processEngine.getRepositoryService();
        this.runtimeService = this.processEngine.getRuntimeService();
        this.taskService = this.processEngine.getTaskService();
        this.historyService = this.processEngine.getHistoryService();
        this.identityService = this.processEngine.getIdentityService();
        this.managementService = this.processEngine.getManagementService();
        this.formService = this.processEngine.getFormService();
        this.authorizationService = this.processEngine.getAuthorizationService();
        this.caseService = this.processEngine.getCaseService();
        this.filterService = this.processEngine.getFilterService();
        this.externalTaskService = this.processEngine.getExternalTaskService();
        this.decisionService = this.processEngine.getDecisionService();
    }

    protected void clearServiceReferences() {
        this.processEngineConfiguration = null;
        this.repositoryService = null;
        this.runtimeService = null;
        this.taskService = null;
        this.formService = null;
        this.historyService = null;
        this.identityService = null;
        this.managementService = null;
        this.authorizationService = null;
        this.caseService = null;
        this.filterService = null;
        this.externalTaskService = null;
        this.decisionService = null;
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.getParameter().getType().equals(ProcessEngine.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        if (ProcessEngine.class.equals(parameterContext.getParameter().getType())) {
            LOG.debug("resolve the processEngine as parameter");
            return this.getProcessEngine();
        }
        return null;
    }

    public void beforeTestExecution(ExtensionContext context) {
        LOG.debug("beforeTestExecution: {}", (Object)context.getDisplayName());
        Method testMethod = (Method)context.getTestMethod().orElseThrow(this.illegalStateException("testMethod not set"));
        Class testClass = (Class)context.getTestClass().orElseThrow(this.illegalStateException("testClass not set"));
        this.deploymentId = TestHelper.annotationDeploymentSetUp((ProcessEngine)this.processEngine, (Class)testClass, (String)testMethod.getName(), null, (Class[])testMethod.getParameterTypes());
        boolean hasRequiredHistoryLevel = TestHelper.annotationRequiredHistoryLevelCheck((ProcessEngine)this.processEngine, (Class)testClass, (String)testMethod.getName(), (Class[])testMethod.getParameterTypes());
        boolean hasRequiredDatabase = TestHelper.annotationRequiredDatabaseCheck((ProcessEngine)this.processEngine, (Class)testClass, (String)testMethod.getName(), (Class[])testMethod.getParameterTypes());
        Assumptions.assumeTrue((boolean)hasRequiredHistoryLevel, (String)"ignored because the current history level is too low");
        Assumptions.assumeTrue((boolean)hasRequiredDatabase, (String)"ignored because the database doesn't match the required ones");
    }

    public void afterTestExecution(ExtensionContext context) {
        String testMethod = ((Method)context.getTestMethod().orElseThrow(this.illegalStateException("testMethod not set"))).getName();
        Class testClass = (Class)context.getTestClass().orElseThrow(this.illegalStateException("testClass not set"));
        TestHelper.annotationDeploymentTearDown((ProcessEngine)this.processEngine, (String)this.deploymentId, (Class)testClass, (String)testMethod);
        this.deploymentId = null;
        for (String additionalDeployment : this.additionalDeployments) {
            TestHelper.deleteDeployment((ProcessEngine)this.processEngine, (String)additionalDeployment);
        }
        this.additionalDeployments.clear();
        TestHelper.resetIdGenerator((ProcessEngineConfigurationImpl)this.processEngineConfiguration);
        ClockUtil.reset();
        PlatformDiagnosticsRegistry.clear();
        if (this.ensureCleanAfterTest) {
            TestHelper.assertAndEnsureCleanDbAndCache((ProcessEngine)this.processEngine);
        }
    }

    public void afterAll(ExtensionContext context) throws Exception {
        this.clearServiceReferences();
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) {
        if (this.processEngine == null) {
            this.initializeProcessEngine();
        }
        Arrays.stream(testInstance.getClass().getDeclaredFields()).filter(field -> field.getType() == ProcessEngine.class).forEach(field -> this.inject(testInstance, (Field)field));
    }

    public static ProcessEngineExtension builder() {
        return new ProcessEngineExtension();
    }

    public ProcessEngineExtension configurationResource(String configurationResource) {
        this.configurationResource = configurationResource;
        return this;
    }

    public ProcessEngineExtension useProcessEngine(ProcessEngine engine) {
        this.setProcessEngine(engine);
        return this;
    }

    public ProcessEngineExtension ensureCleanAfterTest(boolean ensureCleanAfterTest) {
        this.ensureCleanAfterTest = ensureCleanAfterTest;
        return this;
    }

    public ProcessEngineExtension manageDeployment(Deployment deployment) {
        this.additionalDeployments.add(deployment.getId());
        return this;
    }

    public ProcessEngineExtension build() {
        if (this.processEngine == null) {
            this.initializeProcessEngine();
        }
        this.initializeServices();
        return this;
    }

    protected Supplier<IllegalStateException> illegalStateException(String msg) {
        return () -> new IllegalStateException(msg);
    }

    protected void inject(Object instance, Field field) {
        field.setAccessible(true);
        try {
            field.set(instance, this.processEngine);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
    }

    public void setCurrentTime(Date currentTime) {
        ClockUtil.setCurrentTime((Date)currentTime);
    }

    public ProcessEngine getProcessEngine() {
        return this.processEngine;
    }

    public void setProcessEngine(ProcessEngine processEngine) {
        this.processEngine = processEngine;
        this.initializeServices();
    }

    public String getConfigurationResource() {
        return this.configurationResource;
    }

    public ProcessEngineConfigurationImpl getProcessEngineConfiguration() {
        return this.processEngineConfiguration;
    }

    public RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public RuntimeService getRuntimeService() {
        return this.runtimeService;
    }

    public void setRuntimeService(RuntimeService runtimeService) {
        this.runtimeService = runtimeService;
    }

    public TaskService getTaskService() {
        return this.taskService;
    }

    public void setTaskService(TaskService taskService) {
        this.taskService = taskService;
    }

    public HistoryService getHistoryService() {
        return this.historyService;
    }

    public void setHistoryService(HistoryService historyService) {
        this.historyService = historyService;
    }

    public IdentityService getIdentityService() {
        return this.identityService;
    }

    public void setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
    }

    public ManagementService getManagementService() {
        return this.managementService;
    }

    public void setManagementService(ManagementService managementService) {
        this.managementService = managementService;
    }

    public FormService getFormService() {
        return this.formService;
    }

    public void setFormService(FormService formService) {
        this.formService = formService;
    }

    public FilterService getFilterService() {
        return this.filterService;
    }

    public void setFilterService(FilterService filterService) {
        this.filterService = filterService;
    }

    public AuthorizationService getAuthorizationService() {
        return this.authorizationService;
    }

    public void setAuthorizationService(AuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    public CaseService getCaseService() {
        return this.caseService;
    }

    public void setCaseService(CaseService caseService) {
        this.caseService = caseService;
    }

    public ExternalTaskService getExternalTaskService() {
        return this.externalTaskService;
    }

    public void setExternalTaskService(ExternalTaskService externalTaskService) {
        this.externalTaskService = externalTaskService;
    }

    public DecisionService getDecisionService() {
        return this.decisionService;
    }

    public void setDecisionService(DecisionService decisionService) {
        this.decisionService = decisionService;
    }

    public void setProcessEngineConfiguration(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
    }

    public void setConfigurationResource(String configurationResource) {
        this.configurationResource = configurationResource;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public boolean isEnsureCleanAfterTest() {
        return this.ensureCleanAfterTest;
    }

    public void setEnsureCleanAfterTest(boolean ensureCleanAfterTest) {
        this.ensureCleanAfterTest = ensureCleanAfterTest;
    }
}

