/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.cdi.test.api;

import java.util.Collections;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.cdi.BusinessProcess;
import org.camunda.bpm.engine.cdi.ProcessEngineCdiException;
import org.camunda.bpm.engine.cdi.test.CdiProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class BusinessProcessBeanTest
extends CdiProcessEngineTestCase {
    @Test
    @Deployment
    public void test() throws Exception {
        BusinessProcess businessProcess = this.getBeanInstance(BusinessProcess.class);
        businessProcess.startProcessByKey("businessProcessBeanTest").getId();
        Assert.assertNotNull((Object)this.processEngine.getRuntimeService().createProcessInstanceQuery().singleResult());
        Task task = (Task)this.processEngine.getTaskService().createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        String value = "value";
        businessProcess.setVariable("key", (Object)Variables.stringValue((String)value));
        Assert.assertEquals((Object)value, (Object)businessProcess.getVariable("key"));
        TypedValue typedValue = businessProcess.getVariableTyped("key");
        Assert.assertEquals((Object)ValueType.STRING, (Object)typedValue.getType());
        Assert.assertEquals((Object)value, (Object)typedValue.getValue());
        String localValue = "localValue";
        businessProcess.setVariableLocal("localKey", (Object)Variables.stringValue((String)localValue));
        Assert.assertEquals((Object)localValue, (Object)businessProcess.getVariableLocal("localKey"));
        TypedValue typedLocalValue = businessProcess.getVariableLocalTyped("localKey");
        Assert.assertEquals((Object)ValueType.STRING, (Object)typedLocalValue.getType());
        Assert.assertEquals((Object)localValue, (Object)typedLocalValue.getValue());
        Assert.assertEquals((Object)task.getId(), (Object)businessProcess.startTask(task.getId()).getId());
        businessProcess.completeTask();
        Assert.assertNull((Object)this.processEngine.getTaskService().createTaskQuery().singleResult());
        Assert.assertNull((Object)this.processEngine.getRuntimeService().createProcessInstanceQuery().singleResult());
    }

    @Test
    @Deployment
    public void testProcessWithoutWatestate() {
        BusinessProcess businessProcess = this.getBeanInstance(BusinessProcess.class);
        businessProcess.startProcessByKey("businessProcessBeanTest").getId();
        Assert.assertNull((Object)this.processEngine.getRuntimeService().createProcessInstanceQuery().singleResult());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/cdi/test/api/BusinessProcessBeanTest.test.bpmn20.xml"})
    public void testResolveProcessInstanceBean() {
        BusinessProcess businessProcess = this.getBeanInstance(BusinessProcess.class);
        Assert.assertNull((Object)this.getBeanInstance(ProcessInstance.class));
        Assert.assertNull((Object)this.getBeanInstance("processInstanceId"));
        Assert.assertNull((Object)this.getBeanInstance(Execution.class));
        Assert.assertNull((Object)this.getBeanInstance("executionId"));
        String pid = businessProcess.startProcessByKey("businessProcessBeanTest").getId();
        Assert.assertEquals((Object)pid, (Object)this.getBeanInstance(ProcessInstance.class).getId());
        Assert.assertEquals((Object)pid, (Object)this.getBeanInstance("processInstanceId"));
        Assert.assertEquals((Object)pid, (Object)this.getBeanInstance(Execution.class).getId());
        Assert.assertEquals((Object)pid, (Object)this.getBeanInstance("executionId"));
        this.taskService.complete(((Task)this.taskService.createTaskQuery().singleResult()).getId());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/cdi/test/api/BusinessProcessBeanTest.test.bpmn20.xml"})
    public void testResolveTaskBean() {
        BusinessProcess businessProcess = this.getBeanInstance(BusinessProcess.class);
        Assert.assertNull((Object)this.getBeanInstance(Task.class));
        Assert.assertNull((Object)this.getBeanInstance("taskId"));
        businessProcess.startProcessByKey("businessProcessBeanTest");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        businessProcess.startTask(taskId);
        Assert.assertEquals((Object)taskId, (Object)this.getBeanInstance(Task.class).getId());
        Assert.assertEquals((Object)taskId, (Object)this.getBeanInstance("taskId"));
        this.taskService.complete(((Task)this.taskService.createTaskQuery().singleResult()).getId());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/cdi/test/api/BusinessProcessBeanTest.test.bpmn20.xml"})
    public void testGetVariableCache() {
        BusinessProcess businessProcess = this.getBeanInstance(BusinessProcess.class);
        Assert.assertEquals((Object)Collections.EMPTY_MAP, (Object)businessProcess.getVariableCache());
        businessProcess.setVariable("aVariableName", (Object)"aVariableValue");
        Assert.assertEquals(Collections.singletonMap("aVariableName", "aVariableValue"), (Object)businessProcess.getVariableCache());
        Assert.assertEquals(Collections.singletonMap("aVariableName", "aVariableValue"), (Object)businessProcess.getVariableCache());
        businessProcess.startProcessByKey("businessProcessBeanTest");
        Assert.assertEquals((Object)Collections.EMPTY_MAP, (Object)businessProcess.getVariableCache());
        businessProcess.setVariable("anotherVariableName", (Object)"aVariableValue");
        Assert.assertEquals(Collections.singletonMap("anotherVariableName", "aVariableValue"), (Object)businessProcess.getVariableCache());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/cdi/test/api/BusinessProcessBeanTest.test.bpmn20.xml"})
    public void testGetCachedVariableMap() {
        BusinessProcess businessProcess = this.getBeanInstance(BusinessProcess.class);
        Assert.assertEquals((Object)Collections.EMPTY_MAP, (Object)businessProcess.getCachedVariableMap());
        businessProcess.setVariable("aVariableName", (Object)"aVariableValue");
        Assert.assertEquals(Collections.singletonMap("aVariableName", "aVariableValue"), (Object)businessProcess.getCachedVariableMap());
        Assert.assertEquals(Collections.singletonMap("aVariableName", "aVariableValue"), (Object)businessProcess.getCachedVariableMap());
        businessProcess.startProcessByKey("businessProcessBeanTest");
        Assert.assertEquals((Object)Collections.EMPTY_MAP, (Object)businessProcess.getCachedVariableMap());
        businessProcess.setVariable("anotherVariableName", (Object)"aVariableValue");
        Assert.assertEquals(Collections.singletonMap("anotherVariableName", "aVariableValue"), (Object)businessProcess.getCachedVariableMap());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/cdi/test/api/BusinessProcessBeanTest.test.bpmn20.xml"})
    public void testGetAndClearVariableCache() {
        BusinessProcess businessProcess = this.getBeanInstance(BusinessProcess.class);
        Assert.assertEquals((Object)Collections.EMPTY_MAP, (Object)businessProcess.getAndClearVariableCache());
        businessProcess.setVariable("aVariableName", (Object)"aVariableValue");
        Assert.assertEquals(Collections.singletonMap("aVariableName", "aVariableValue"), (Object)businessProcess.getAndClearVariableCache());
        Assert.assertEquals((Object)Collections.EMPTY_MAP, (Object)businessProcess.getAndClearVariableCache());
        businessProcess.startProcessByKey("businessProcessBeanTest");
        Assert.assertEquals((Object)Collections.EMPTY_MAP, (Object)businessProcess.getVariableCache());
        businessProcess.setVariable("anotherVariableName", (Object)"aVariableValue");
        Assert.assertEquals(Collections.singletonMap("anotherVariableName", "aVariableValue"), (Object)businessProcess.getVariableCache());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/cdi/test/api/BusinessProcessBeanTest.test.bpmn20.xml"})
    public void testGetAndClearCachedVariableMap() {
        BusinessProcess businessProcess = this.getBeanInstance(BusinessProcess.class);
        Assert.assertEquals((Object)Collections.EMPTY_MAP, (Object)businessProcess.getAndClearCachedVariableMap());
        businessProcess.setVariable("aVariableName", (Object)"aVariableValue");
        Assert.assertEquals(Collections.singletonMap("aVariableName", "aVariableValue"), (Object)businessProcess.getAndClearCachedVariableMap());
        Assert.assertEquals((Object)Collections.EMPTY_MAP, (Object)businessProcess.getAndClearCachedVariableMap());
        businessProcess.startProcessByKey("businessProcessBeanTest");
        Assert.assertEquals((Object)Collections.EMPTY_MAP, (Object)businessProcess.getAndClearCachedVariableMap());
        businessProcess.setVariable("anotherVariableName", (Object)"aVariableValue");
        Assert.assertEquals(Collections.singletonMap("anotherVariableName", "aVariableValue"), (Object)businessProcess.getAndClearCachedVariableMap());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/cdi/test/api/BusinessProcessBeanTest.test.bpmn20.xml"})
    public void testGetVariableLocalCache() {
        BusinessProcess businessProcess = this.getBeanInstance(BusinessProcess.class);
        Assert.assertEquals((Object)Collections.EMPTY_MAP, (Object)businessProcess.getVariableLocalCache());
        try {
            businessProcess.setVariableLocal("aVariableName", (Object)"aVariableValue");
            Assert.fail((String)"exception expected!");
        }
        catch (ProcessEngineCdiException e) {
            Assert.assertEquals((Object)"Cannot set a local cached variable: neither a Task nor an Execution is associated.", (Object)e.getMessage());
        }
        businessProcess.startProcessByKey("businessProcessBeanTest");
        Assert.assertEquals((Object)Collections.EMPTY_MAP, (Object)businessProcess.getVariableLocalCache());
        businessProcess.setVariableLocal("anotherVariableName", (Object)"aVariableValue");
        Assert.assertEquals(Collections.singletonMap("anotherVariableName", "aVariableValue"), (Object)businessProcess.getVariableLocalCache());
        Assert.assertEquals(Collections.singletonMap("anotherVariableName", "aVariableValue"), (Object)businessProcess.getVariableLocalCache());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/cdi/test/api/BusinessProcessBeanTest.test.bpmn20.xml"})
    public void testGetCachedLocalVariableMap() {
        BusinessProcess businessProcess = this.getBeanInstance(BusinessProcess.class);
        Assert.assertEquals((Object)Collections.EMPTY_MAP, (Object)businessProcess.getCachedLocalVariableMap());
        try {
            businessProcess.setVariableLocal("aVariableName", (Object)"aVariableValue");
            Assert.fail((String)"exception expected!");
        }
        catch (ProcessEngineCdiException e) {
            Assert.assertEquals((Object)"Cannot set a local cached variable: neither a Task nor an Execution is associated.", (Object)e.getMessage());
        }
        businessProcess.startProcessByKey("businessProcessBeanTest");
        Assert.assertEquals((Object)Collections.EMPTY_MAP, (Object)businessProcess.getCachedLocalVariableMap());
        businessProcess.setVariableLocal("anotherVariableName", (Object)"aVariableValue");
        Assert.assertEquals(Collections.singletonMap("anotherVariableName", "aVariableValue"), (Object)businessProcess.getCachedLocalVariableMap());
        Assert.assertEquals(Collections.singletonMap("anotherVariableName", "aVariableValue"), (Object)businessProcess.getCachedLocalVariableMap());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/cdi/test/api/BusinessProcessBeanTest.test.bpmn20.xml"})
    public void testGetVariableLocal() {
        BusinessProcess businessProcess = this.getBeanInstance(BusinessProcess.class);
        ProcessInstance processInstance = businessProcess.startProcessByKey("businessProcessBeanTest");
        TaskService taskService = this.getBeanInstance(TaskService.class);
        Task task = (Task)taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertNotNull((Object)task);
        businessProcess.startTask(task.getId());
        businessProcess.setVariableLocal("aVariableName", (Object)"aVariableValue");
        businessProcess.flushVariableCache();
        Assert.assertTrue((boolean)businessProcess.getCachedLocalVariableMap().isEmpty());
        Assert.assertEquals((Object)"aVariableValue", (Object)businessProcess.getVariableLocal("aVariableName"));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/cdi/test/api/BusinessProcessBeanTest.test.bpmn20.xml"})
    public void testGetAndClearVariableLocalCache() {
        BusinessProcess businessProcess = this.getBeanInstance(BusinessProcess.class);
        Assert.assertEquals((Object)Collections.EMPTY_MAP, (Object)businessProcess.getAndClearVariableLocalCache());
        try {
            businessProcess.setVariableLocal("aVariableName", (Object)"aVariableValue");
            Assert.fail((String)"exception expected!");
        }
        catch (ProcessEngineCdiException e) {
            Assert.assertEquals((Object)"Cannot set a local cached variable: neither a Task nor an Execution is associated.", (Object)e.getMessage());
        }
        Assert.assertEquals((Object)Collections.EMPTY_MAP, (Object)businessProcess.getAndClearVariableLocalCache());
        businessProcess.startProcessByKey("businessProcessBeanTest");
        Assert.assertEquals((Object)Collections.EMPTY_MAP, (Object)businessProcess.getVariableLocalCache());
        businessProcess.setVariableLocal("anotherVariableName", (Object)"aVariableValue");
        Assert.assertEquals(Collections.singletonMap("anotherVariableName", "aVariableValue"), (Object)businessProcess.getVariableLocalCache());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/cdi/test/api/BusinessProcessBeanTest.test.bpmn20.xml"})
    public void testGetAndClearCachedLocalVariableMap() {
        BusinessProcess businessProcess = this.getBeanInstance(BusinessProcess.class);
        Assert.assertEquals((Object)Collections.EMPTY_MAP, (Object)businessProcess.getAndClearCachedLocalVariableMap());
        try {
            businessProcess.setVariableLocal("aVariableName", (Object)"aVariableValue");
            Assert.fail((String)"exception expected!");
        }
        catch (ProcessEngineCdiException e) {
            Assert.assertEquals((Object)"Cannot set a local cached variable: neither a Task nor an Execution is associated.", (Object)e.getMessage());
        }
        Assert.assertEquals((Object)Collections.EMPTY_MAP, (Object)businessProcess.getAndClearCachedLocalVariableMap());
        businessProcess.startProcessByKey("businessProcessBeanTest");
        Assert.assertEquals((Object)Collections.EMPTY_MAP, (Object)businessProcess.getAndClearCachedLocalVariableMap());
        businessProcess.setVariableLocal("anotherVariableName", (Object)"aVariableValue");
        Assert.assertEquals(Collections.singletonMap("anotherVariableName", "aVariableValue"), (Object)businessProcess.getAndClearCachedLocalVariableMap());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/cdi/test/api/BusinessProcessBeanTest.test.bpmn20.xml"})
    public void testFlushVariableCache() {
        BusinessProcess businessProcess = this.getBeanInstance(BusinessProcess.class);
        try {
            businessProcess.flushVariableCache();
            Assert.fail((String)"exception expected!");
        }
        catch (ProcessEngineCdiException e) {
            Assert.assertEquals((Object)"Cannot flush variable cache: neither a Task nor an Execution is associated.", (Object)e.getMessage());
        }
        businessProcess.startProcessByKey("businessProcessBeanTest");
        businessProcess.setVariable("aVariableName", (Object)"aVariable");
        Assert.assertNull((Object)this.runtimeService.getVariable(businessProcess.getExecutionId(), "aVariableName"));
        businessProcess.setVariableLocal("aVariableLocalName", (Object)"aVariableLocal");
        Assert.assertNull((Object)this.runtimeService.getVariable(businessProcess.getExecutionId(), "aVariableLocalName"));
        businessProcess.flushVariableCache();
        Assert.assertNotNull((Object)this.runtimeService.getVariable(businessProcess.getExecutionId(), "aVariableName"));
        Assert.assertNotNull((Object)this.runtimeService.getVariable(businessProcess.getExecutionId(), "aVariableLocalName"));
        Assert.assertEquals((Object)Collections.EMPTY_MAP, (Object)businessProcess.getCachedVariableMap());
        Assert.assertEquals((Object)Collections.EMPTY_MAP, (Object)businessProcess.getCachedLocalVariableMap());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/cdi/test/api/BusinessProcessBeanTest.test.bpmn20.xml"})
    public void testSaveTask() {
        BusinessProcess businessProcess = this.getBeanInstance(BusinessProcess.class);
        try {
            businessProcess.saveTask();
            Assert.fail();
        }
        catch (ProcessEngineCdiException e) {
            Assert.assertEquals((Object)"No task associated. Call businessProcess.startTask() first.", (Object)e.getMessage());
        }
        String processInstanceId = businessProcess.startProcessByKey("businessProcessBeanTest", Collections.singletonMap("key", "value")).getId();
        Assert.assertEquals((Object)"value", (Object)this.runtimeService.getVariable(processInstanceId, "key"));
        businessProcess.startTask(((Task)this.taskService.createTaskQuery().singleResult()).getId());
        Assert.assertNull((Object)this.taskService.createTaskQuery().taskAssignee("jonny").singleResult());
        Task task = businessProcess.getTask();
        task.setAssignee("jonny");
        Assert.assertNull((Object)this.taskService.createTaskQuery().taskAssignee("jonny").singleResult());
        businessProcess.saveTask();
        Assert.assertNotNull((Object)this.taskService.createTaskQuery().taskAssignee("jonny").singleResult());
        Assert.assertTrue((boolean)businessProcess.isTaskAssociated());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/cdi/test/api/BusinessProcessBeanTest.test.bpmn20.xml"})
    public void testStopTask() {
        BusinessProcess businessProcess = this.getBeanInstance(BusinessProcess.class);
        try {
            businessProcess.stopTask();
            Assert.fail();
        }
        catch (ProcessEngineCdiException e) {
            Assert.assertEquals((Object)"No task associated. Call businessProcess.startTask() first.", (Object)e.getMessage());
        }
        String processInstanceId = businessProcess.startProcessByKey("businessProcessBeanTest", Collections.singletonMap("key", "value")).getId();
        Assert.assertEquals((Object)"value", (Object)this.runtimeService.getVariable(processInstanceId, "key"));
        businessProcess.startTask(((Task)this.taskService.createTaskQuery().singleResult()).getId());
        Assert.assertNull((Object)this.taskService.createTaskQuery().taskAssignee("jonny").singleResult());
        Task task = businessProcess.getTask();
        task.setAssignee("jonny");
        businessProcess.stopTask();
        Assert.assertNull((Object)this.taskService.createTaskQuery().taskAssignee("jonny").singleResult());
        Assert.assertFalse((boolean)businessProcess.isTaskAssociated());
        Assert.assertFalse((boolean)businessProcess.isAssociated());
    }
}

