/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.spin.plugin.impl;

import org.camunda.bpm.engine.impl.variable.serializer.ValueFields;
import org.camunda.bpm.engine.variable.impl.value.UntypedValueImpl;
import org.camunda.spin.DataFormats;
import org.camunda.spin.json.SpinJsonNode;
import org.camunda.spin.plugin.impl.SpinValueSerializer;
import org.camunda.spin.plugin.variable.SpinValues;
import org.camunda.spin.plugin.variable.type.SpinValueType;
import org.camunda.spin.plugin.variable.value.SpinValue;
import org.camunda.spin.plugin.variable.value.impl.JsonValueImpl;
import org.camunda.spin.spi.DataFormat;

public class JsonValueSerializer
extends SpinValueSerializer {
    public JsonValueSerializer(DataFormat<SpinJsonNode> dataFormat) {
        super(SpinValueType.JSON, dataFormat, "json");
    }

    public JsonValueSerializer() {
        this((DataFormat<SpinJsonNode>)DataFormats.json());
    }

    public SpinValue convertToTypedValue(UntypedValueImpl untypedValue) {
        return (SpinValue)SpinValues.jsonValue((SpinJsonNode)untypedValue.getValue()).create();
    }

    protected SpinValue createDeserializedValue(Object deserializedObject, String serializedStringValue, ValueFields valueFields) {
        SpinJsonNode value = (SpinJsonNode)deserializedObject;
        return new JsonValueImpl(value, serializedStringValue, value.getDataFormatName(), true);
    }

    protected SpinValue createSerializedValue(String serializedStringValue, ValueFields valueFields) {
        return new JsonValueImpl(serializedStringValue, this.serializationDataFormat);
    }
}

