/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl.optimize;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricTaskInstance;
import org.camunda.bpm.engine.history.HistoricVariableUpdate;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.rest.dto.converter.DateConverter;
import org.camunda.bpm.engine.rest.dto.history.HistoricActivityInstanceDto;
import org.camunda.bpm.engine.rest.dto.history.HistoricDecisionInstanceDto;
import org.camunda.bpm.engine.rest.dto.history.HistoricProcessInstanceDto;
import org.camunda.bpm.engine.rest.dto.history.HistoricTaskInstanceDto;
import org.camunda.bpm.engine.rest.dto.history.UserOperationLogEntryDto;
import org.camunda.bpm.engine.rest.dto.history.optimize.HistoricOptimizeVariableUpdateDto;
import org.camunda.bpm.engine.rest.impl.AbstractRestProcessEngineAware;

@Produces(value={"application/json"})
public class OptimizeRestService
extends AbstractRestProcessEngineAware {
    public static final String PATH = "/optimize";
    private DateConverter dateConverter = new DateConverter();

    public OptimizeRestService(String engineName, ObjectMapper objectMapper) {
        super(engineName, objectMapper);
        this.dateConverter.setObjectMapper(objectMapper);
    }

    @GET
    @Path(value="/activity-instance/completed")
    public List<HistoricActivityInstanceDto> getCompletedHistoricActivityInstances(@QueryParam(value="finishedAfter") String finishedAfterAsString, @QueryParam(value="finishedAt") String finishedAtAsString, @QueryParam(value="maxResults") int maxResults) {
        Date finishedAfter = this.dateConverter.convertQueryParameterToType(finishedAfterAsString);
        Date finishedAt = this.dateConverter.convertQueryParameterToType(finishedAtAsString);
        maxResults = this.ensureValidMaxResults(maxResults);
        ProcessEngineConfigurationImpl config = (ProcessEngineConfigurationImpl)this.getProcessEngine().getProcessEngineConfiguration();
        List historicActivityInstances = config.getOptimizeService().getCompletedHistoricActivityInstances(finishedAfter, finishedAt, maxResults);
        ArrayList<HistoricActivityInstanceDto> result = new ArrayList<HistoricActivityInstanceDto>();
        for (HistoricActivityInstance instance : historicActivityInstances) {
            HistoricActivityInstanceDto dto = HistoricActivityInstanceDto.fromHistoricActivityInstance(instance);
            result.add(dto);
        }
        return result;
    }

    @GET
    @Path(value="/activity-instance/running")
    public List<HistoricActivityInstanceDto> getRunningHistoricActivityInstances(@QueryParam(value="startedAfter") String startedAfterAsString, @QueryParam(value="startedAt") String startedAtAsString, @QueryParam(value="maxResults") int maxResults) {
        Date startedAfter = this.dateConverter.convertQueryParameterToType(startedAfterAsString);
        Date startedAt = this.dateConverter.convertQueryParameterToType(startedAtAsString);
        maxResults = this.ensureValidMaxResults(maxResults);
        ProcessEngineConfigurationImpl config = (ProcessEngineConfigurationImpl)this.getProcessEngine().getProcessEngineConfiguration();
        List historicActivityInstances = config.getOptimizeService().getRunningHistoricActivityInstances(startedAfter, startedAt, maxResults);
        ArrayList<HistoricActivityInstanceDto> result = new ArrayList<HistoricActivityInstanceDto>();
        for (HistoricActivityInstance instance : historicActivityInstances) {
            HistoricActivityInstanceDto dto = HistoricActivityInstanceDto.fromHistoricActivityInstance(instance);
            result.add(dto);
        }
        return result;
    }

    @GET
    @Path(value="/task-instance/completed")
    public List<HistoricTaskInstanceDto> getCompletedHistoricTaskInstances(@QueryParam(value="finishedAfter") String finishedAfterAsString, @QueryParam(value="finishedAt") String finishedAtAsString, @QueryParam(value="maxResults") int maxResults) {
        Date finishedAfter = this.dateConverter.convertQueryParameterToType(finishedAfterAsString);
        Date finishedAt = this.dateConverter.convertQueryParameterToType(finishedAtAsString);
        maxResults = this.ensureValidMaxResults(maxResults);
        ProcessEngineConfigurationImpl config = (ProcessEngineConfigurationImpl)this.getProcessEngine().getProcessEngineConfiguration();
        List historicTaskInstances = config.getOptimizeService().getCompletedHistoricTaskInstances(finishedAfter, finishedAt, maxResults);
        ArrayList<HistoricTaskInstanceDto> result = new ArrayList<HistoricTaskInstanceDto>();
        for (HistoricTaskInstance instance : historicTaskInstances) {
            HistoricTaskInstanceDto dto = HistoricTaskInstanceDto.fromHistoricTaskInstance(instance);
            result.add(dto);
        }
        return result;
    }

    @GET
    @Path(value="/task-instance/running")
    public List<HistoricTaskInstanceDto> getRunningHistoricTaskInstances(@QueryParam(value="startedAfter") String startedAfterAsString, @QueryParam(value="startedAt") String startedAtAsString, @QueryParam(value="maxResults") int maxResults) {
        Date startedAfter = this.dateConverter.convertQueryParameterToType(startedAfterAsString);
        Date startedAt = this.dateConverter.convertQueryParameterToType(startedAtAsString);
        maxResults = this.ensureValidMaxResults(maxResults);
        ProcessEngineConfigurationImpl config = (ProcessEngineConfigurationImpl)this.getProcessEngine().getProcessEngineConfiguration();
        List historicTaskInstances = config.getOptimizeService().getRunningHistoricTaskInstances(startedAfter, startedAt, maxResults);
        ArrayList<HistoricTaskInstanceDto> result = new ArrayList<HistoricTaskInstanceDto>();
        for (HistoricTaskInstance instance : historicTaskInstances) {
            HistoricTaskInstanceDto dto = HistoricTaskInstanceDto.fromHistoricTaskInstance(instance);
            result.add(dto);
        }
        return result;
    }

    @GET
    @Path(value="/user-operation")
    public List<UserOperationLogEntryDto> getHistoricUserOperationLogs(@QueryParam(value="occurredAfter") String occurredAfterAsString, @QueryParam(value="occurredAt") String occurredAtAsString, @QueryParam(value="maxResults") int maxResults) {
        Date occurredAfter = this.dateConverter.convertQueryParameterToType(occurredAfterAsString);
        Date occurredAt = this.dateConverter.convertQueryParameterToType(occurredAtAsString);
        maxResults = this.ensureValidMaxResults(maxResults);
        ProcessEngineConfigurationImpl config = (ProcessEngineConfigurationImpl)this.getProcessEngine().getProcessEngineConfiguration();
        List operationLogEntries = config.getOptimizeService().getHistoricUserOperationLogs(occurredAfter, occurredAt, maxResults);
        ArrayList<UserOperationLogEntryDto> result = new ArrayList<UserOperationLogEntryDto>();
        for (UserOperationLogEntry logEntry : operationLogEntries) {
            UserOperationLogEntryDto dto = UserOperationLogEntryDto.map(logEntry);
            result.add(dto);
        }
        return result;
    }

    @GET
    @Path(value="/process-instance/completed")
    public List<HistoricProcessInstanceDto> getCompletedHistoricProcessInstances(@QueryParam(value="finishedAfter") String finishedAfterAsString, @QueryParam(value="finishedAt") String finishedAtAsString, @QueryParam(value="maxResults") int maxResults) {
        Date finishedAfter = this.dateConverter.convertQueryParameterToType(finishedAfterAsString);
        Date finishedAt = this.dateConverter.convertQueryParameterToType(finishedAtAsString);
        maxResults = this.ensureValidMaxResults(maxResults);
        ProcessEngineConfigurationImpl config = (ProcessEngineConfigurationImpl)this.getProcessEngine().getProcessEngineConfiguration();
        List historicProcessInstances = config.getOptimizeService().getCompletedHistoricProcessInstances(finishedAfter, finishedAt, maxResults);
        ArrayList<HistoricProcessInstanceDto> result = new ArrayList<HistoricProcessInstanceDto>();
        for (HistoricProcessInstance instance : historicProcessInstances) {
            HistoricProcessInstanceDto dto = HistoricProcessInstanceDto.fromHistoricProcessInstance(instance);
            result.add(dto);
        }
        return result;
    }

    @GET
    @Path(value="/process-instance/running")
    public List<HistoricProcessInstanceDto> getRunningHistoricProcessInstances(@QueryParam(value="startedAfter") String startedAfterAsString, @QueryParam(value="startedAt") String startedAtAsString, @QueryParam(value="maxResults") int maxResults) {
        Date startedAfter = this.dateConverter.convertQueryParameterToType(startedAfterAsString);
        Date startedAt = this.dateConverter.convertQueryParameterToType(startedAtAsString);
        maxResults = this.ensureValidMaxResults(maxResults);
        ProcessEngineConfigurationImpl config = (ProcessEngineConfigurationImpl)this.getProcessEngine().getProcessEngineConfiguration();
        List historicProcessInstances = config.getOptimizeService().getRunningHistoricProcessInstances(startedAfter, startedAt, maxResults);
        ArrayList<HistoricProcessInstanceDto> result = new ArrayList<HistoricProcessInstanceDto>();
        for (HistoricProcessInstance instance : historicProcessInstances) {
            HistoricProcessInstanceDto dto = HistoricProcessInstanceDto.fromHistoricProcessInstance(instance);
            result.add(dto);
        }
        return result;
    }

    @GET
    @Path(value="/variable-update")
    public List<HistoricOptimizeVariableUpdateDto> getHistoricVariableUpdates(@QueryParam(value="occurredAfter") String occurredAfterAsString, @QueryParam(value="occurredAt") String occurredAtAsString, @QueryParam(value="maxResults") int maxResults) {
        Date occurredAfter = this.dateConverter.convertQueryParameterToType(occurredAfterAsString);
        Date occurredAt = this.dateConverter.convertQueryParameterToType(occurredAtAsString);
        maxResults = this.ensureValidMaxResults(maxResults);
        ProcessEngineConfigurationImpl config = (ProcessEngineConfigurationImpl)this.getProcessEngine().getProcessEngineConfiguration();
        List historicVariableUpdates = config.getOptimizeService().getHistoricVariableUpdates(occurredAfter, occurredAt, maxResults);
        ArrayList<HistoricOptimizeVariableUpdateDto> result = new ArrayList<HistoricOptimizeVariableUpdateDto>();
        for (HistoricVariableUpdate instance : historicVariableUpdates) {
            HistoricOptimizeVariableUpdateDto dto = HistoricOptimizeVariableUpdateDto.fromHistoricVariableUpdate(instance);
            result.add(dto);
        }
        return result;
    }

    @GET
    @Path(value="/decision-instance")
    public List<HistoricDecisionInstanceDto> getHistoricDecisionInstances(@QueryParam(value="evaluatedAfter") String evaluatedAfterAsString, @QueryParam(value="evaluatedAt") String evaluatedAtAsString, @QueryParam(value="maxResults") int maxResults) {
        Date evaluatedAfter = this.dateConverter.convertQueryParameterToType(evaluatedAfterAsString);
        Date evaluatedAt = this.dateConverter.convertQueryParameterToType(evaluatedAtAsString);
        maxResults = this.ensureValidMaxResults(maxResults);
        ProcessEngineConfigurationImpl config = (ProcessEngineConfigurationImpl)this.getProcessEngine().getProcessEngineConfiguration();
        List historicDecisionInstances = config.getOptimizeService().getHistoricDecisionInstances(evaluatedAfter, evaluatedAt, maxResults);
        ArrayList<HistoricDecisionInstanceDto> resultList = new ArrayList<HistoricDecisionInstanceDto>();
        for (HistoricDecisionInstance historicDecisionInstance : historicDecisionInstances) {
            HistoricDecisionInstanceDto dto = HistoricDecisionInstanceDto.fromHistoricDecisionInstance(historicDecisionInstance);
            resultList.add(dto);
        }
        return resultList;
    }

    protected int ensureValidMaxResults(int givenMaxResults) {
        return givenMaxResults > 0 ? givenMaxResults : Integer.MAX_VALUE;
    }
}

