/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.rest.dto.AbstractQueryDto;
import org.camunda.bpm.engine.rest.dto.CamundaQueryParam;
import org.camunda.bpm.engine.rest.dto.ConditionQueryParameterDto;
import org.camunda.bpm.engine.rest.dto.converter.BooleanConverter;
import org.camunda.bpm.engine.rest.dto.converter.ConditionListConverter;
import org.camunda.bpm.engine.rest.dto.converter.DateConverter;
import org.camunda.bpm.engine.rest.dto.converter.LongConverter;
import org.camunda.bpm.engine.rest.dto.converter.StringListConverter;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.runtime.JobQuery;

public class JobQueryDto
extends AbstractQueryDto<JobQuery> {
    private static final String SORT_BY_JOB_ID_VALUE = "jobId";
    private static final String SORT_BY_EXECUTION_ID_VALUE = "executionId";
    private static final String SORT_BY_PROCESS_INSTANCE_ID_VALUE = "processInstanceId";
    private static final String SORT_BY_PROCESS_DEFINITION_ID_VALUE = "processDefinitionId";
    private static final String SORT_BY_PROCESS_DEFINITION_KEY_VALUE = "processDefinitionKey";
    private static final String SORT_BY_JOB_RETRIES_VALUE = "jobRetries";
    private static final String SORT_BY_JOB_DUEDATE_VALUE = "jobDueDate";
    private static final String SORT_BY_JOB_PRIORITY_VALUE = "jobPriority";
    private static final String SORT_BY_TENANT_ID = "tenantId";
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList<String>();
    protected String activityId;
    protected String jobId;
    protected String executionId;
    protected String processInstanceId;
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected Boolean withRetriesLeft;
    protected Boolean executable;
    protected Boolean timers;
    protected Boolean messages;
    protected Boolean withException;
    protected String exceptionMessage;
    protected Boolean noRetriesLeft;
    protected Boolean active;
    protected Boolean suspended;
    protected Long priorityHigherThanOrEquals;
    protected Long priorityLowerThanOrEquals;
    protected String jobDefinitionId;
    protected List<String> tenantIds;
    protected Boolean withoutTenantId;
    protected Boolean includeJobsWithoutTenantId;
    protected List<ConditionQueryParameterDto> dueDates;
    protected List<ConditionQueryParameterDto> createTimes;

    public JobQueryDto() {
    }

    public JobQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @CamundaQueryParam(value="activityId")
    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    @CamundaQueryParam(value="jobId")
    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    @CamundaQueryParam(value="executionId")
    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    @CamundaQueryParam(value="processInstanceId")
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @CamundaQueryParam(value="processDefinitionId")
    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @CamundaQueryParam(value="processDefinitionKey")
    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    @CamundaQueryParam(value="withRetriesLeft", converter=BooleanConverter.class)
    public void setWithRetriesLeft(Boolean withRetriesLeft) {
        this.withRetriesLeft = withRetriesLeft;
    }

    @CamundaQueryParam(value="executable", converter=BooleanConverter.class)
    public void setExecutable(Boolean executable) {
        this.executable = executable;
    }

    @CamundaQueryParam(value="timers", converter=BooleanConverter.class)
    public void setTimers(Boolean timers) {
        this.timers = timers;
    }

    @CamundaQueryParam(value="withException", converter=BooleanConverter.class)
    public void setWithException(Boolean withException) {
        this.withException = withException;
    }

    @CamundaQueryParam(value="messages", converter=BooleanConverter.class)
    public void setMessages(Boolean messages) {
        this.messages = messages;
    }

    @CamundaQueryParam(value="exceptionMessage")
    public void setExceptionMessage(String exceptionMessage) {
        this.exceptionMessage = exceptionMessage;
    }

    @CamundaQueryParam(value="dueDates", converter=ConditionListConverter.class)
    public void setDueDates(List<ConditionQueryParameterDto> dueDates) {
        this.dueDates = dueDates;
    }

    @CamundaQueryParam(value="createTimes", converter=ConditionListConverter.class)
    public void setCreateTimes(List<ConditionQueryParameterDto> createTimes) {
        this.createTimes = createTimes;
    }

    @CamundaQueryParam(value="noRetriesLeft", converter=BooleanConverter.class)
    public void setNoRetriesLeft(Boolean noRetriesLeft) {
        this.noRetriesLeft = noRetriesLeft;
    }

    @CamundaQueryParam(value="active", converter=BooleanConverter.class)
    public void setActive(Boolean active) {
        this.active = active;
    }

    @CamundaQueryParam(value="suspended", converter=BooleanConverter.class)
    public void setSuspended(Boolean suspended) {
        this.suspended = suspended;
    }

    @CamundaQueryParam(value="priorityHigherThanOrEquals", converter=LongConverter.class)
    public void setPriorityHigherThanOrEquals(Long priorityHigherThanOrEquals) {
        this.priorityHigherThanOrEquals = priorityHigherThanOrEquals;
    }

    @CamundaQueryParam(value="priorityLowerThanOrEquals", converter=LongConverter.class)
    public void setPriorityLowerThanOrEquals(Long priorityLowerThanOrEquals) {
        this.priorityLowerThanOrEquals = priorityLowerThanOrEquals;
    }

    @CamundaQueryParam(value="jobDefinitionId")
    public void setJobDefinitionId(String jobDefinitionId) {
        this.jobDefinitionId = jobDefinitionId;
    }

    @CamundaQueryParam(value="tenantIdIn", converter=StringListConverter.class)
    public void setTenantIdIn(List<String> tenantIds) {
        this.tenantIds = tenantIds;
    }

    @CamundaQueryParam(value="withoutTenantId", converter=BooleanConverter.class)
    public void setWithoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
    }

    @CamundaQueryParam(value="includeJobsWithoutTenantId", converter=BooleanConverter.class)
    public void setIncludeJobsWithoutTenantId(Boolean includeJobsWithoutTenantId) {
        this.includeJobsWithoutTenantId = includeJobsWithoutTenantId;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    @Override
    protected JobQuery createNewQuery(ProcessEngine engine) {
        return engine.getManagementService().createJobQuery();
    }

    @Override
    protected void applyFilters(final JobQuery query) {
        if (this.activityId != null) {
            query.activityId(this.activityId);
        }
        if (this.jobId != null) {
            query.jobId(this.jobId);
        }
        if (this.executionId != null) {
            query.executionId(this.executionId);
        }
        if (this.processInstanceId != null) {
            query.processInstanceId(this.processInstanceId);
        }
        if (this.processDefinitionId != null) {
            query.processDefinitionId(this.processDefinitionId);
        }
        if (this.processDefinitionKey != null) {
            query.processDefinitionKey(this.processDefinitionKey);
        }
        if (Boolean.TRUE.equals(this.withRetriesLeft)) {
            query.withRetriesLeft();
        }
        if (Boolean.TRUE.equals(this.executable)) {
            query.executable();
        }
        if (Boolean.TRUE.equals(this.timers)) {
            if (this.messages != null && this.messages.booleanValue()) {
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Parameter timers cannot be used together with parameter messages.");
            }
            query.timers();
        }
        if (Boolean.TRUE.equals(this.messages)) {
            if (this.timers != null && this.timers.booleanValue()) {
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Parameter messages cannot be used together with parameter timers.");
            }
            query.messages();
        }
        if (Boolean.TRUE.equals(this.withException)) {
            query.withException();
        }
        if (this.exceptionMessage != null) {
            query.exceptionMessage(this.exceptionMessage);
        }
        if (Boolean.TRUE.equals(this.noRetriesLeft)) {
            query.noRetriesLeft();
        }
        if (Boolean.TRUE.equals(this.active)) {
            query.active();
        }
        if (Boolean.TRUE.equals(this.suspended)) {
            query.suspended();
        }
        if (this.priorityHigherThanOrEquals != null) {
            query.priorityHigherThanOrEquals(this.priorityHigherThanOrEquals.longValue());
        }
        if (this.priorityLowerThanOrEquals != null) {
            query.priorityLowerThanOrEquals(this.priorityLowerThanOrEquals.longValue());
        }
        if (this.jobDefinitionId != null) {
            query.jobDefinitionId(this.jobDefinitionId);
        }
        if (this.dueDates != null) {
            new ApplyDates(){

                @Override
                void setGreaterThan(Date date) {
                    query.duedateHigherThan(date);
                }

                @Override
                void setLowerThan(Date date) {
                    query.duedateLowerThan(date);
                }

                @Override
                String fieldName() {
                    return "due date";
                }
            }.run(this.dueDates);
        }
        if (this.createTimes != null) {
            new ApplyDates(){

                @Override
                void setGreaterThan(Date date) {
                    query.createdAfter(date);
                }

                @Override
                void setLowerThan(Date date) {
                    query.createdBefore(date);
                }

                @Override
                String fieldName() {
                    return "create time";
                }
            }.run(this.createTimes);
        }
        if (this.tenantIds != null && !this.tenantIds.isEmpty()) {
            query.tenantIdIn(this.tenantIds.toArray(new String[this.tenantIds.size()]));
        }
        if (Boolean.TRUE.equals(this.withoutTenantId)) {
            query.withoutTenantId();
        }
        if (Boolean.TRUE.equals(this.includeJobsWithoutTenantId)) {
            query.includeJobsWithoutTenantId();
        }
    }

    @Override
    protected void applySortBy(JobQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (sortBy.equals(SORT_BY_JOB_ID_VALUE)) {
            query.orderByJobId();
        } else if (sortBy.equals(SORT_BY_EXECUTION_ID_VALUE)) {
            query.orderByExecutionId();
        } else if (sortBy.equals(SORT_BY_PROCESS_INSTANCE_ID_VALUE)) {
            query.orderByProcessInstanceId();
        } else if (sortBy.equals(SORT_BY_PROCESS_DEFINITION_ID_VALUE)) {
            query.orderByProcessDefinitionId();
        } else if (sortBy.equals(SORT_BY_PROCESS_DEFINITION_KEY_VALUE)) {
            query.orderByProcessDefinitionKey();
        } else if (sortBy.equals(SORT_BY_JOB_RETRIES_VALUE)) {
            query.orderByJobRetries();
        } else if (sortBy.equals(SORT_BY_JOB_DUEDATE_VALUE)) {
            query.orderByJobDuedate();
        } else if (sortBy.equals(SORT_BY_JOB_PRIORITY_VALUE)) {
            query.orderByJobPriority();
        } else if (sortBy.equals(SORT_BY_TENANT_ID)) {
            query.orderByTenantId();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_JOB_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_EXECUTION_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_INSTANCE_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_DEFINITION_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_DEFINITION_KEY_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_JOB_RETRIES_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_JOB_DUEDATE_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_JOB_PRIORITY_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_TENANT_ID);
    }

    private abstract class ApplyDates {
        private ApplyDates() {
        }

        void run(List<ConditionQueryParameterDto> dates) {
            DateConverter dateConverter = new DateConverter();
            dateConverter.setObjectMapper(JobQueryDto.this.objectMapper);
            for (ConditionQueryParameterDto conditionQueryParam : dates) {
                Date date;
                String op = conditionQueryParam.getOperator();
                try {
                    date = dateConverter.convertQueryParameterToType((String)conditionQueryParam.getValue());
                }
                catch (RestException e) {
                    throw new InvalidRequestException(e.getStatus(), e, "Invalid " + this.fieldName() + " format: " + e.getMessage());
                }
                if (op.equals("gt")) {
                    this.setGreaterThan(date);
                    continue;
                }
                if (op.equals("lt")) {
                    this.setLowerThan(date);
                    continue;
                }
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Invalid " + this.fieldName() + " comparator specified: " + op);
            }
        }

        abstract String fieldName();

        abstract void setGreaterThan(Date var1);

        abstract void setLowerThan(Date var1);
    }
}

