/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.rest.VariableInstanceRestService;
import org.camunda.bpm.engine.rest.dto.CountResultDto;
import org.camunda.bpm.engine.rest.dto.runtime.VariableInstanceDto;
import org.camunda.bpm.engine.rest.dto.runtime.VariableInstanceQueryDto;
import org.camunda.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import org.camunda.bpm.engine.rest.sub.runtime.VariableInstanceResource;
import org.camunda.bpm.engine.rest.sub.runtime.impl.VariableInstanceResourceImpl;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.runtime.VariableInstanceQuery;

public class VariableInstanceRestServiceImpl
extends AbstractRestProcessEngineAware
implements VariableInstanceRestService {
    public VariableInstanceRestServiceImpl(String engineName, ObjectMapper objectMapper) {
        super(engineName, objectMapper);
    }

    @Override
    public VariableInstanceResource getVariableInstance(String id) {
        return new VariableInstanceResourceImpl(id, this.processEngine);
    }

    @Override
    public List<VariableInstanceDto> getVariableInstances(UriInfo uriInfo, Integer firstResult, Integer maxResults, boolean deserializeObjectValues) {
        VariableInstanceQueryDto queryDto = new VariableInstanceQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryVariableInstances(queryDto, firstResult, maxResults, deserializeObjectValues);
    }

    @Override
    public List<VariableInstanceDto> queryVariableInstances(VariableInstanceQueryDto queryDto, Integer firstResult, Integer maxResults, boolean deserializeObjectValues) {
        ProcessEngine engine = this.getProcessEngine();
        queryDto.setObjectMapper(this.getObjectMapper());
        VariableInstanceQuery query = (VariableInstanceQuery)queryDto.toQuery(engine);
        query.disableBinaryFetching();
        if (!deserializeObjectValues) {
            query.disableCustomObjectDeserialization();
        }
        List<VariableInstance> matchingInstances = firstResult != null || maxResults != null ? this.executePaginatedQuery(query, firstResult, maxResults) : query.list();
        ArrayList<VariableInstanceDto> instanceResults = new ArrayList<VariableInstanceDto>();
        for (VariableInstance instance : matchingInstances) {
            VariableInstanceDto resultInstance = VariableInstanceDto.fromVariableInstance(instance);
            instanceResults.add(resultInstance);
        }
        return instanceResults;
    }

    private List<VariableInstance> executePaginatedQuery(VariableInstanceQuery query, Integer firstResult, Integer maxResults) {
        if (firstResult == null) {
            firstResult = 0;
        }
        if (maxResults == null) {
            maxResults = Integer.MAX_VALUE;
        }
        return query.listPage(firstResult.intValue(), maxResults.intValue());
    }

    @Override
    public CountResultDto getVariableInstancesCount(UriInfo uriInfo) {
        VariableInstanceQueryDto queryDto = new VariableInstanceQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryVariableInstancesCount(queryDto);
    }

    @Override
    public CountResultDto queryVariableInstancesCount(VariableInstanceQueryDto queryDto) {
        ProcessEngine engine = this.getProcessEngine();
        queryDto.setObjectMapper(this.getObjectMapper());
        VariableInstanceQuery query = (VariableInstanceQuery)queryDto.toQuery(engine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }
}

