/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub.identity.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.rest.dto.ResourceOptionsDto;
import org.camunda.bpm.engine.rest.sub.identity.TenantGroupMembersResource;
import org.camunda.bpm.engine.rest.sub.identity.impl.AbstractIdentityResource;
import org.camunda.bpm.engine.rest.util.PathUtil;

public class TenantGroupMembersResourceImpl
extends AbstractIdentityResource
implements TenantGroupMembersResource {
    public TenantGroupMembersResourceImpl(String processEngineName, String resourceId, String rootResourcePath, ObjectMapper objectMapper) {
        super(processEngineName, (Resource)Resources.TENANT_MEMBERSHIP, resourceId, objectMapper);
        this.relativeRootResourcePath = rootResourcePath;
    }

    @Override
    public void createMembership(String groupId) {
        this.ensureNotReadOnly();
        groupId = PathUtil.decodePathParam(groupId);
        this.identityService.createTenantGroupMembership(this.resourceId, groupId);
    }

    @Override
    public void deleteMembership(String groupId) {
        this.ensureNotReadOnly();
        groupId = PathUtil.decodePathParam(groupId);
        this.identityService.deleteTenantGroupMembership(this.resourceId, groupId);
    }

    @Override
    public ResourceOptionsDto availableOperations(UriInfo context) {
        ResourceOptionsDto dto = new ResourceOptionsDto();
        URI uri = context.getBaseUriBuilder().path(this.relativeRootResourcePath).path("/tenant").path(this.resourceId).path("/group-members").build(new Object[0]);
        if (!this.identityService.isReadOnly() && this.isAuthorized((Permission)Permissions.DELETE)) {
            dto.addReflexiveLink(uri, "DELETE", "delete");
        }
        if (!this.identityService.isReadOnly() && this.isAuthorized((Permission)Permissions.CREATE)) {
            dto.addReflexiveLink(uri, "PUT", "create");
        }
        return dto;
    }
}

