/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.ParseException;
import org.camunda.bpm.engine.Problem;
import org.camunda.bpm.engine.ResourceReport;
import org.camunda.bpm.engine.rest.dto.ExceptionDto;
import org.camunda.bpm.engine.rest.dto.ProblemDto;
import org.camunda.bpm.engine.rest.dto.ResourceReportDto;

public class ParseExceptionDto
extends ExceptionDto {
    protected Map<String, ResourceReportDto> details = new HashMap<String, ResourceReportDto>();

    public static ParseExceptionDto fromException(ParseException exception) {
        ParseExceptionDto dto = new ParseExceptionDto();
        dto.setType(ParseException.class.getSimpleName());
        dto.setMessage(exception.getMessage());
        for (ResourceReport report : exception.getResorceReports()) {
            Object error2;
            ArrayList<ProblemDto> errorDtos = new ArrayList<ProblemDto>();
            for (Object error2 : report.getErrors()) {
                errorDtos.add(ProblemDto.fromProblem((Problem)error2));
            }
            ArrayList<ProblemDto> warningDtos = new ArrayList<ProblemDto>();
            error2 = report.getWarnings().iterator();
            while (error2.hasNext()) {
                Problem warning = (Problem)error2.next();
                warningDtos.add(ProblemDto.fromProblem(warning));
            }
            ResourceReportDto resourceReportDto = new ResourceReportDto(errorDtos, warningDtos);
            dto.details.put(report.getResourceName(), resourceReportDto);
        }
        return dto;
    }

    public Map<String, ResourceReportDto> getDetails() {
        return this.details;
    }

    public void setDetails(Map<String, ResourceReportDto> details) {
        this.details = details;
    }
}

