/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.telemetry;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.camunda.bpm.engine.rest.dto.telemetry.ApplicationServerDto;
import org.camunda.bpm.engine.rest.dto.telemetry.CommandDto;
import org.camunda.bpm.engine.rest.dto.telemetry.DatabaseDto;
import org.camunda.bpm.engine.rest.dto.telemetry.JdkDto;
import org.camunda.bpm.engine.rest.dto.telemetry.LicenseKeyDataDto;
import org.camunda.bpm.engine.rest.dto.telemetry.MetricDto;
import org.camunda.bpm.engine.telemetry.Internals;
import org.camunda.bpm.engine.telemetry.LicenseKeyData;

public class InternalsDto {
    public static final String SERIALIZED_APPLICATION_SERVER = "application-server";
    public static final String SERIALIZED_CAMUNDA_INTEGRATION = "camunda-integration";
    public static final String SERIALIZED_LICENSE_KEY = "license-key";
    protected DatabaseDto database;
    @JsonProperty(value="application-server")
    protected ApplicationServerDto applicationServer;
    @JsonProperty(value="license-key")
    protected LicenseKeyDataDto licenseKey;
    protected Map<String, CommandDto> commands;
    @JsonProperty(value="camunda-integration")
    protected Set<String> camundaIntegration;
    protected Map<String, MetricDto> metrics;
    protected Set<String> webapps;
    protected JdkDto jdk;

    public InternalsDto(DatabaseDto database, ApplicationServerDto server, LicenseKeyDataDto licenseKey, JdkDto jdk) {
        this.database = database;
        this.applicationServer = server;
        this.licenseKey = licenseKey;
        this.commands = new HashMap<String, CommandDto>();
        this.jdk = jdk;
        this.camundaIntegration = new HashSet<String>();
    }

    public DatabaseDto getDatabase() {
        return this.database;
    }

    public void setDatabase(DatabaseDto database) {
        this.database = database;
    }

    public ApplicationServerDto getApplicationServer() {
        return this.applicationServer;
    }

    public void setApplicationServer(ApplicationServerDto applicationServer) {
        this.applicationServer = applicationServer;
    }

    public Map<String, CommandDto> getCommands() {
        return this.commands;
    }

    public void setCommands(Map<String, CommandDto> commands) {
        this.commands = commands;
    }

    public Map<String, MetricDto> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(Map<String, MetricDto> metrics) {
        this.metrics = metrics;
    }

    public JdkDto getJdk() {
        return this.jdk;
    }

    public void setJdk(JdkDto jdk) {
        this.jdk = jdk;
    }

    public Set<String> getCamundaIntegration() {
        return this.camundaIntegration;
    }

    public void setCamundaIntegration(Set<String> camundaIntegration) {
        this.camundaIntegration = camundaIntegration;
    }

    public LicenseKeyDataDto getLicenseKey() {
        return this.licenseKey;
    }

    public void setLicenseKey(LicenseKeyDataDto licenseKey) {
        this.licenseKey = licenseKey;
    }

    public Set<String> getWebapps() {
        return this.webapps;
    }

    public void setWebapps(Set<String> webapps) {
        this.webapps = webapps;
    }

    public static InternalsDto fromEngineDto(Internals other) {
        LicenseKeyData licenseKey = other.getLicenseKey();
        InternalsDto dto = new InternalsDto(DatabaseDto.fromEngineDto(other.getDatabase()), ApplicationServerDto.fromEngineDto(other.getApplicationServer()), licenseKey != null ? LicenseKeyDataDto.fromEngineDto(licenseKey) : null, JdkDto.fromEngineDto(other.getJdk()));
        dto.commands = new HashMap<String, CommandDto>();
        other.getCommands().forEach((name, command) -> dto.commands.put((String)name, new CommandDto(command.getCount())));
        dto.metrics = new HashMap<String, MetricDto>();
        other.getMetrics().forEach((name, metric) -> dto.metrics.put((String)name, new MetricDto(metric.getCount())));
        dto.setWebapps(other.getWebapps());
        dto.setCamundaIntegration(other.getCamundaIntegration());
        return dto;
    }
}

