/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.hal.user;

import javax.ws.rs.core.UriBuilder;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.rest.UserRestService;
import org.camunda.bpm.engine.rest.hal.HalIdResource;
import org.camunda.bpm.engine.rest.hal.HalRelation;
import org.camunda.bpm.engine.rest.hal.HalResource;

public class HalUser
extends HalResource<HalUser>
implements HalIdResource {
    public static final HalRelation REL_SELF = HalRelation.build("self", UserRestService.class, UriBuilder.fromPath((String)"/user").path("{id}"));
    protected String id;
    protected String firstName;
    protected String lastName;
    protected String email;

    public static HalUser fromUser(User user) {
        HalUser halUser = new HalUser();
        halUser.id = user.getId();
        halUser.firstName = user.getFirstName();
        halUser.lastName = user.getLastName();
        halUser.email = user.getEmail();
        halUser.linker.createLink(REL_SELF, user.getId());
        return halUser;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getEmail() {
        return this.email;
    }
}

