/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.rest.ProcessInstanceRestService;
import org.camunda.bpm.engine.rest.dto.AbstractQueryDto;
import org.camunda.bpm.engine.rest.dto.CountResultDto;
import org.camunda.bpm.engine.rest.dto.VariableValueDto;
import org.camunda.bpm.engine.rest.dto.batch.BatchDto;
import org.camunda.bpm.engine.rest.dto.history.HistoricProcessInstanceQueryDto;
import org.camunda.bpm.engine.rest.dto.runtime.ProcessInstanceDto;
import org.camunda.bpm.engine.rest.dto.runtime.ProcessInstanceQueryDto;
import org.camunda.bpm.engine.rest.dto.runtime.ProcessInstanceSuspensionStateAsyncDto;
import org.camunda.bpm.engine.rest.dto.runtime.ProcessInstanceSuspensionStateDto;
import org.camunda.bpm.engine.rest.dto.runtime.SetJobRetriesByProcessDto;
import org.camunda.bpm.engine.rest.dto.runtime.batch.CorrelationMessageAsyncDto;
import org.camunda.bpm.engine.rest.dto.runtime.batch.DeleteProcessInstancesDto;
import org.camunda.bpm.engine.rest.dto.runtime.batch.SetVariablesAsyncDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import org.camunda.bpm.engine.rest.sub.runtime.ProcessInstanceResource;
import org.camunda.bpm.engine.rest.sub.runtime.impl.ProcessInstanceResourceImpl;
import org.camunda.bpm.engine.runtime.MessageCorrelationAsyncBuilder;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.variable.VariableMap;

public class ProcessInstanceRestServiceImpl
extends AbstractRestProcessEngineAware
implements ProcessInstanceRestService {
    public ProcessInstanceRestServiceImpl(String engineName, ObjectMapper objectMapper) {
        super(engineName, objectMapper);
    }

    @Override
    public List<ProcessInstanceDto> getProcessInstances(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        ProcessInstanceQueryDto queryDto = new ProcessInstanceQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryProcessInstances(queryDto, firstResult, maxResults);
    }

    @Override
    public List<ProcessInstanceDto> queryProcessInstances(ProcessInstanceQueryDto queryDto, Integer firstResult, Integer maxResults) {
        ProcessEngine engine = this.getProcessEngine();
        queryDto.setObjectMapper(this.getObjectMapper());
        ProcessInstanceQuery query = (ProcessInstanceQuery)queryDto.toQuery(engine);
        List<ProcessInstance> matchingInstances = firstResult != null || maxResults != null ? this.executePaginatedQuery(query, firstResult, maxResults) : query.list();
        ArrayList<ProcessInstanceDto> instanceResults = new ArrayList<ProcessInstanceDto>();
        for (ProcessInstance instance : matchingInstances) {
            ProcessInstanceDto resultInstance = ProcessInstanceDto.fromProcessInstance(instance);
            instanceResults.add(resultInstance);
        }
        return instanceResults;
    }

    private List<ProcessInstance> executePaginatedQuery(ProcessInstanceQuery query, Integer firstResult, Integer maxResults) {
        if (firstResult == null) {
            firstResult = 0;
        }
        if (maxResults == null) {
            maxResults = Integer.MAX_VALUE;
        }
        return query.listPage(firstResult.intValue(), maxResults.intValue());
    }

    @Override
    public CountResultDto getProcessInstancesCount(UriInfo uriInfo) {
        ProcessInstanceQueryDto queryDto = new ProcessInstanceQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryProcessInstancesCount(queryDto);
    }

    @Override
    public CountResultDto queryProcessInstancesCount(ProcessInstanceQueryDto queryDto) {
        ProcessEngine engine = this.getProcessEngine();
        queryDto.setObjectMapper(this.getObjectMapper());
        ProcessInstanceQuery query = (ProcessInstanceQuery)queryDto.toQuery(engine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }

    @Override
    public ProcessInstanceResource getProcessInstance(String processInstanceId) {
        return new ProcessInstanceResourceImpl(this.getProcessEngine(), processInstanceId, this.getObjectMapper());
    }

    @Override
    public void updateSuspensionState(ProcessInstanceSuspensionStateDto dto) {
        dto.updateSuspensionState(this.getProcessEngine());
    }

    @Override
    public BatchDto updateSuspensionStateAsync(ProcessInstanceSuspensionStateAsyncDto dto) {
        Batch batch = null;
        try {
            batch = dto.updateSuspensionStateAsync(this.getProcessEngine());
            return BatchDto.fromBatch(batch);
        }
        catch (BadUserRequestException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
    }

    @Override
    public BatchDto deleteAsync(DeleteProcessInstancesDto dto) {
        RuntimeService runtimeService = this.getProcessEngine().getRuntimeService();
        ProcessInstanceQuery processInstanceQuery = null;
        if (dto.getProcessInstanceQuery() != null) {
            processInstanceQuery = (ProcessInstanceQuery)dto.getProcessInstanceQuery().toQuery(this.getProcessEngine());
        }
        Batch batch = null;
        try {
            batch = runtimeService.deleteProcessInstancesAsync(dto.getProcessInstanceIds(), processInstanceQuery, dto.getDeleteReason(), dto.isSkipCustomListeners(), dto.isSkipSubprocesses());
            return BatchDto.fromBatch(batch);
        }
        catch (BadUserRequestException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
    }

    @Override
    public BatchDto deleteAsyncHistoricQueryBased(DeleteProcessInstancesDto deleteProcessInstancesDto) {
        HistoricProcessInstanceQuery historicProcessInstanceQuery = null;
        if (deleteProcessInstancesDto.getHistoricProcessInstanceQuery() != null) {
            historicProcessInstanceQuery = (HistoricProcessInstanceQuery)deleteProcessInstancesDto.getHistoricProcessInstanceQuery().toQuery(this.getProcessEngine());
        }
        RuntimeService runtimeService = this.getProcessEngine().getRuntimeService();
        try {
            Batch batch = runtimeService.deleteProcessInstancesAsync(deleteProcessInstancesDto.getProcessInstanceIds(), null, historicProcessInstanceQuery, deleteProcessInstancesDto.getDeleteReason(), deleteProcessInstancesDto.isSkipCustomListeners(), deleteProcessInstancesDto.isSkipSubprocesses());
            return BatchDto.fromBatch(batch);
        }
        catch (BadUserRequestException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
    }

    @Override
    public BatchDto setRetriesByProcess(SetJobRetriesByProcessDto setJobRetriesDto) {
        try {
            EnsureUtil.ensureNotNull((String)"setJobRetriesDto", (Object)setJobRetriesDto);
            EnsureUtil.ensureNotNull((String)"retries", (Object)setJobRetriesDto.getRetries());
        }
        catch (NullValueException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
        ProcessInstanceQuery processInstanceQuery = null;
        if (setJobRetriesDto.getProcessInstanceQuery() != null) {
            processInstanceQuery = (ProcessInstanceQuery)setJobRetriesDto.getProcessInstanceQuery().toQuery(this.getProcessEngine());
        }
        try {
            Batch batch = this.getProcessEngine().getManagementService().setJobRetriesAsync(setJobRetriesDto.getProcessInstances(), processInstanceQuery, setJobRetriesDto.getRetries().intValue());
            return BatchDto.fromBatch(batch);
        }
        catch (BadUserRequestException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
    }

    @Override
    public BatchDto setRetriesByProcessHistoricQueryBased(SetJobRetriesByProcessDto setJobRetriesDto) {
        HistoricProcessInstanceQueryDto queryDto = setJobRetriesDto.getHistoricProcessInstanceQuery();
        HistoricProcessInstanceQuery query = null;
        if (queryDto != null) {
            query = (HistoricProcessInstanceQuery)queryDto.toQuery(this.getProcessEngine());
        }
        try {
            ManagementService managementService = this.getProcessEngine().getManagementService();
            Batch batch = managementService.setJobRetriesAsync(setJobRetriesDto.getProcessInstances(), null, query, setJobRetriesDto.getRetries().intValue());
            return BatchDto.fromBatch(batch);
        }
        catch (BadUserRequestException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
    }

    @Override
    public BatchDto setVariablesAsync(SetVariablesAsyncDto setVariablesAsyncDto) {
        Map<String, VariableValueDto> variables = setVariablesAsyncDto.getVariables();
        VariableMap variableMap = null;
        try {
            variableMap = VariableValueDto.toMap(variables, this.processEngine, this.objectMapper);
        }
        catch (RestException e) {
            String errorMessage = String.format("Cannot set variables: %s", e.getMessage());
            throw new InvalidRequestException(e.getStatus(), e, errorMessage);
        }
        List<String> ids = setVariablesAsyncDto.getProcessInstanceIds();
        ProcessInstanceQuery runtimeQuery = (ProcessInstanceQuery)this.toQuery(setVariablesAsyncDto.getProcessInstanceQuery());
        HistoricProcessInstanceQuery historyQuery = (HistoricProcessInstanceQuery)this.toQuery(setVariablesAsyncDto.getHistoricProcessInstanceQuery());
        RuntimeService runtimeService = this.getProcessEngine().getRuntimeService();
        Batch batch = null;
        try {
            batch = runtimeService.setVariablesAsync(ids, runtimeQuery, historyQuery, (Map)variableMap);
        }
        catch (AuthorizationException | BadUserRequestException e) {
            throw e;
        }
        catch (ProcessEngineException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
        return BatchDto.fromBatch(batch);
    }

    @Override
    public BatchDto correlateMessageAsync(CorrelationMessageAsyncDto correlationMessageAsyncDto) {
        Map<String, VariableValueDto> variables = correlationMessageAsyncDto.getVariables();
        VariableMap variableMap = null;
        try {
            variableMap = VariableValueDto.toMap(variables, this.processEngine, this.objectMapper);
        }
        catch (RestException e) {
            String errorMessage = String.format("Cannot set variables: %s", e.getMessage());
            throw new InvalidRequestException(e.getStatus(), e, errorMessage);
        }
        String messageName = correlationMessageAsyncDto.getMessageName();
        List<String> ids = correlationMessageAsyncDto.getProcessInstanceIds();
        ProcessInstanceQuery runtimeQuery = (ProcessInstanceQuery)this.toQuery(correlationMessageAsyncDto.getProcessInstanceQuery());
        HistoricProcessInstanceQuery historyQuery = (HistoricProcessInstanceQuery)this.toQuery(correlationMessageAsyncDto.getHistoricProcessInstanceQuery());
        RuntimeService runtimeService = this.getProcessEngine().getRuntimeService();
        Batch batch = null;
        try {
            MessageCorrelationAsyncBuilder messageCorrelationBuilder = runtimeService.createMessageCorrelationAsync(messageName).setVariables((Map)variableMap);
            if (ids != null) {
                messageCorrelationBuilder.processInstanceIds(ids);
            }
            if (runtimeQuery != null) {
                messageCorrelationBuilder.processInstanceQuery(runtimeQuery);
            }
            if (historyQuery != null) {
                messageCorrelationBuilder.historicProcessInstanceQuery(historyQuery);
            }
            batch = messageCorrelationBuilder.correlateAllAsync();
        }
        catch (NullValueException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
        return BatchDto.fromBatch(batch);
    }

    protected <T extends Query, R extends AbstractQueryDto> T toQuery(R query) {
        if (query == null) {
            return null;
        }
        return query.toQuery(this.processEngine);
    }
}

