/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.rest.TelemetryRestService;
import org.camunda.bpm.engine.rest.dto.TelemetryConfigurationDto;
import org.camunda.bpm.engine.rest.dto.telemetry.TelemetryDataDto;
import org.camunda.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import org.camunda.bpm.engine.telemetry.TelemetryData;

public class TelemetryRestServiceImpl
extends AbstractRestProcessEngineAware
implements TelemetryRestService {
    public TelemetryRestServiceImpl(String engineName, ObjectMapper objectMapper) {
        super(engineName, objectMapper);
    }

    @Override
    public void configureTelemetry(TelemetryConfigurationDto dto) {
        boolean enableTelemetry = dto.isEnableTelemetry();
        ManagementService managementService = this.processEngine.getManagementService();
        managementService.toggleTelemetry(enableTelemetry);
    }

    @Override
    public TelemetryConfigurationDto getTelemetryConfiguration() {
        ManagementService managementService = this.processEngine.getManagementService();
        Boolean telemetryEnabled = managementService.isTelemetryEnabled();
        return new TelemetryConfigurationDto(telemetryEnabled);
    }

    @Override
    public TelemetryDataDto getTelemetryData() {
        ManagementService managementService = this.processEngine.getManagementService();
        TelemetryData data = managementService.getTelemetryData();
        return TelemetryDataDto.fromEngineDto(data);
    }
}

