/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.history.HistoricIdentityLinkLogQuery;
import org.camunda.bpm.engine.rest.dto.AbstractQueryDto;
import org.camunda.bpm.engine.rest.dto.CamundaQueryParam;
import org.camunda.bpm.engine.rest.dto.converter.DateConverter;
import org.camunda.bpm.engine.rest.dto.converter.StringListConverter;

public class HistoricIdentityLinkLogQueryDto
extends AbstractQueryDto<HistoricIdentityLinkLogQuery> {
    private static final String SORT_BY_TIME = "time";
    private static final String SORT_BY_TYPE = "type";
    private static final String SORT_BY_USER_ID = "userId";
    private static final String SORT_BY_GROUP_ID = "groupId";
    private static final String SORT_BY_TASK_ID = "taskId";
    private static final String SORT_BY_PROCESS_DEFINITION_ID = "processDefinitionId";
    private static final String SORT_BY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
    private static final String SORT_BY_OPERATION_TYPE = "operationType";
    private static final String SORT_BY_ASSIGNER_ID = "assignerId";
    private static final String SORT_BY_TENANT_ID = "tenantId";
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList<String>();
    protected Date dateBefore;
    protected Date dateAfter;
    protected String type;
    protected String userId;
    protected String groupId;
    protected String taskId;
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected String operationType;
    protected String assignerId;
    protected List<String> tenantIds;

    public HistoricIdentityLinkLogQueryDto() {
    }

    public HistoricIdentityLinkLogQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    @Override
    protected HistoricIdentityLinkLogQuery createNewQuery(ProcessEngine engine) {
        return engine.getHistoryService().createHistoricIdentityLinkLogQuery();
    }

    @CamundaQueryParam(value="type")
    public void setType(String type) {
        this.type = type;
    }

    @CamundaQueryParam(value="userId")
    public void setUserId(String userId) {
        this.userId = userId;
    }

    @CamundaQueryParam(value="groupId")
    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @CamundaQueryParam(value="dateBefore", converter=DateConverter.class)
    public void setDateBefore(Date dateBefore) {
        this.dateBefore = dateBefore;
    }

    @CamundaQueryParam(value="dateAfter", converter=DateConverter.class)
    public void setDateAfter(Date dateAfter) {
        this.dateAfter = dateAfter;
    }

    @CamundaQueryParam(value="taskId")
    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    @CamundaQueryParam(value="processDefinitionId")
    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @CamundaQueryParam(value="processDefinitionKey")
    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    @CamundaQueryParam(value="operationType")
    public void setOperationType(String operationType) {
        this.operationType = operationType;
    }

    @CamundaQueryParam(value="assignerId")
    public void setAssignerId(String assignerId) {
        this.assignerId = assignerId;
    }

    @CamundaQueryParam(value="tenantIdIn", converter=StringListConverter.class)
    public void setTenantIdIn(List<String> tenantIds) {
        this.tenantIds = tenantIds;
    }

    @Override
    protected void applyFilters(HistoricIdentityLinkLogQuery query) {
        if (this.dateBefore != null) {
            query.dateBefore(this.dateBefore);
        }
        if (this.dateAfter != null) {
            query.dateAfter(this.dateAfter);
        }
        if (this.type != null) {
            query.type(this.type);
        }
        if (this.userId != null) {
            query.userId(this.userId);
        }
        if (this.groupId != null) {
            query.groupId(this.groupId);
        }
        if (this.taskId != null) {
            query.taskId(this.taskId);
        }
        if (this.processDefinitionId != null) {
            query.processDefinitionId(this.processDefinitionId);
        }
        if (this.processDefinitionKey != null) {
            query.processDefinitionKey(this.processDefinitionKey);
        }
        if (this.operationType != null) {
            query.operationType(this.operationType);
        }
        if (this.assignerId != null) {
            query.assignerId(this.assignerId);
        }
        if (this.tenantIds != null && !this.tenantIds.isEmpty()) {
            query.tenantIdIn(this.tenantIds.toArray(new String[this.tenantIds.size()]));
        }
    }

    @Override
    protected void applySortBy(HistoricIdentityLinkLogQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (sortBy.equals(SORT_BY_TIME)) {
            query.orderByTime();
        } else if (sortBy.equals(SORT_BY_TYPE)) {
            query.orderByType();
        } else if (sortBy.equals(SORT_BY_USER_ID)) {
            query.orderByUserId();
        } else if (sortBy.equals(SORT_BY_GROUP_ID)) {
            query.orderByGroupId();
        } else if (sortBy.equals(SORT_BY_TASK_ID)) {
            query.orderByTaskId();
        } else if (sortBy.equals(SORT_BY_OPERATION_TYPE)) {
            query.orderByOperationType();
        } else if (sortBy.equals(SORT_BY_ASSIGNER_ID)) {
            query.orderByAssignerId();
        } else if (sortBy.equals(SORT_BY_PROCESS_DEFINITION_ID)) {
            query.orderByProcessDefinitionId();
        } else if (sortBy.equals(SORT_BY_PROCESS_DEFINITION_KEY)) {
            query.orderByProcessDefinitionKey();
        } else if (sortBy.equals(SORT_BY_TENANT_ID)) {
            query.orderByTenantId();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_TIME);
        VALID_SORT_BY_VALUES.add(SORT_BY_TYPE);
        VALID_SORT_BY_VALUES.add(SORT_BY_USER_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_GROUP_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_TASK_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_DEFINITION_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_DEFINITION_KEY);
        VALID_SORT_BY_VALUES.add(SORT_BY_OPERATION_TYPE);
        VALID_SORT_BY_VALUES.add(SORT_BY_ASSIGNER_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_TENANT_ID);
    }
}

