/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.ExternalTaskService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.externaltask.ExternalTask;
import org.camunda.bpm.engine.externaltask.ExternalTaskQuery;
import org.camunda.bpm.engine.externaltask.ExternalTaskQueryBuilder;
import org.camunda.bpm.engine.externaltask.UpdateExternalTaskRetriesBuilder;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.rest.ExternalTaskRestService;
import org.camunda.bpm.engine.rest.dto.CountResultDto;
import org.camunda.bpm.engine.rest.dto.batch.BatchDto;
import org.camunda.bpm.engine.rest.dto.externaltask.ExternalTaskDto;
import org.camunda.bpm.engine.rest.dto.externaltask.ExternalTaskQueryDto;
import org.camunda.bpm.engine.rest.dto.externaltask.FetchExternalTasksDto;
import org.camunda.bpm.engine.rest.dto.externaltask.LockedExternalTaskDto;
import org.camunda.bpm.engine.rest.dto.externaltask.SetRetriesForExternalTasksDto;
import org.camunda.bpm.engine.rest.dto.history.HistoricProcessInstanceQueryDto;
import org.camunda.bpm.engine.rest.dto.runtime.ProcessInstanceQueryDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import org.camunda.bpm.engine.rest.sub.externaltask.ExternalTaskResource;
import org.camunda.bpm.engine.rest.sub.externaltask.impl.ExternalTaskResourceImpl;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;

public class ExternalTaskRestServiceImpl
extends AbstractRestProcessEngineAware
implements ExternalTaskRestService {
    public ExternalTaskRestServiceImpl(String processEngine, ObjectMapper objectMapper) {
        super(processEngine, objectMapper);
    }

    @Override
    public List<ExternalTaskDto> getExternalTasks(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        ExternalTaskQueryDto queryDto = new ExternalTaskQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryExternalTasks(queryDto, firstResult, maxResults);
    }

    @Override
    public List<ExternalTaskDto> queryExternalTasks(ExternalTaskQueryDto queryDto, Integer firstResult, Integer maxResults) {
        ProcessEngine engine = this.getProcessEngine();
        queryDto.setObjectMapper(this.getObjectMapper());
        ExternalTaskQuery query = (ExternalTaskQuery)queryDto.toQuery(engine);
        List<ExternalTask> matchingTasks = firstResult != null || maxResults != null ? this.executePaginatedQuery(query, firstResult, maxResults) : query.list();
        ArrayList<ExternalTaskDto> taskResults = new ArrayList<ExternalTaskDto>();
        for (ExternalTask task : matchingTasks) {
            ExternalTaskDto resultInstance = ExternalTaskDto.fromExternalTask(task);
            taskResults.add(resultInstance);
        }
        return taskResults;
    }

    protected List<ExternalTask> executePaginatedQuery(ExternalTaskQuery query, Integer firstResult, Integer maxResults) {
        if (firstResult == null) {
            firstResult = 0;
        }
        if (maxResults == null) {
            maxResults = Integer.MAX_VALUE;
        }
        return query.listPage(firstResult.intValue(), maxResults.intValue());
    }

    @Override
    public CountResultDto getExternalTasksCount(UriInfo uriInfo) {
        ExternalTaskQueryDto queryDto = new ExternalTaskQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryExternalTasksCount(queryDto);
    }

    @Override
    public CountResultDto queryExternalTasksCount(ExternalTaskQueryDto queryDto) {
        ProcessEngine engine = this.getProcessEngine();
        queryDto.setObjectMapper(this.getObjectMapper());
        ExternalTaskQuery query = (ExternalTaskQuery)queryDto.toQuery(engine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }

    @Override
    public List<LockedExternalTaskDto> fetchAndLock(FetchExternalTasksDto fetchingDto) {
        ExternalTaskQueryBuilder fetchBuilder = fetchingDto.buildQuery(this.processEngine);
        List externalTasks = fetchBuilder.execute();
        return LockedExternalTaskDto.fromLockedExternalTasks(externalTasks);
    }

    @Override
    public ExternalTaskResource getExternalTask(String externalTaskId) {
        return new ExternalTaskResourceImpl(this.getProcessEngine(), externalTaskId, this.getObjectMapper());
    }

    @Override
    public BatchDto setRetriesAsync(SetRetriesForExternalTasksDto retriesDto) {
        UpdateExternalTaskRetriesBuilder builder = this.updateRetries(retriesDto);
        int retries = retriesDto.getRetries();
        try {
            Batch batch = builder.setAsync(retries);
            return BatchDto.fromBatch(batch);
        }
        catch (NotFoundException e) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, e.getMessage());
        }
        catch (BadUserRequestException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
    }

    @Override
    public void setRetries(SetRetriesForExternalTasksDto retriesDto) {
        UpdateExternalTaskRetriesBuilder builder = this.updateRetries(retriesDto);
        int retries = retriesDto.getRetries();
        try {
            builder.set(retries);
        }
        catch (NotFoundException e) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, e.getMessage());
        }
        catch (BadUserRequestException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
    }

    protected UpdateExternalTaskRetriesBuilder updateRetries(SetRetriesForExternalTasksDto retriesDto) {
        HistoricProcessInstanceQueryDto historicProcessInstanceQueryDto;
        ProcessInstanceQueryDto processInstanceQueryDto;
        ExternalTaskService externalTaskService = this.getProcessEngine().getExternalTaskService();
        List<String> externalTaskIds = retriesDto.getExternalTaskIds();
        List<String> processInstanceIds = retriesDto.getProcessInstanceIds();
        ExternalTaskQuery externalTaskQuery = null;
        ProcessInstanceQuery processInstanceQuery = null;
        HistoricProcessInstanceQuery historicProcessInstanceQuery = null;
        ExternalTaskQueryDto externalTaskQueryDto = retriesDto.getExternalTaskQuery();
        if (externalTaskQueryDto != null) {
            externalTaskQuery = (ExternalTaskQuery)externalTaskQueryDto.toQuery(this.getProcessEngine());
        }
        if ((processInstanceQueryDto = retriesDto.getProcessInstanceQuery()) != null) {
            processInstanceQuery = (ProcessInstanceQuery)processInstanceQueryDto.toQuery(this.getProcessEngine());
        }
        if ((historicProcessInstanceQueryDto = retriesDto.getHistoricProcessInstanceQuery()) != null) {
            historicProcessInstanceQuery = (HistoricProcessInstanceQuery)historicProcessInstanceQueryDto.toQuery(this.getProcessEngine());
        }
        return externalTaskService.updateRetries().externalTaskIds(externalTaskIds).processInstanceIds(processInstanceIds).externalTaskQuery(externalTaskQuery).processInstanceQuery(processInstanceQuery).historicProcessInstanceQuery(historicProcessInstanceQuery);
    }
}

